/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipeMeta;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.utils.JSON;
import java.util.stream.Collectors;

public class GroupRecipePlaceholders {
    private GroupRecipePlaceholders() {
    }

    public static void assertIsGroupingRecipe(SerializedRecipe sr) throws BadTemplatePlaceholderException {
        if (!GroupingRecipeMeta.META.getType().equals(sr.type)) {
            throw new BadTemplatePlaceholderException("This placeholder is only available for a Grouping recipe. " + sr.name + " has type " + sr.type + ".");
        }
    }

    public static GroupingRecipePayloadParams getPayload(FlowDocumentContext context, SerializedRecipe sr) throws PlaceholderExpectedException {
        GroupRecipePlaceholders.assertIsGroupingRecipe(sr);
        return (GroupingRecipePayloadParams)JSON.parse((String)context.getCachedPayload(sr), GroupingRecipePayloadParams.class);
    }

    public static class GroupKeys
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            GroupingRecipePayloadParams params = GroupRecipePlaceholders.getPayload(context, recipe);
            return new PlaceholderOutput.Text(params.getRawGroupingKeys().stream().map(gk -> gk.column).collect(Collectors.joining(", ")));
        }
    }
}

