/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeMeta;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.utils.JSON;

public class SplitRecipePlaceholders {
    private SplitRecipePlaceholders() {
    }

    public static void assertIsSplitRecipe(SerializedRecipe sr) throws BadTemplatePlaceholderException {
        if (!SplitRecipeMeta.META.getType().equals(sr.type)) {
            throw new BadTemplatePlaceholderException("This placeholder is only available for a Split recipe. " + sr.name + " has type " + sr.type + ".");
        }
    }

    public static SplitRecipePayloadParams getPayload(FlowDocumentContext context, SerializedRecipe sr) throws PlaceholderExpectedException {
        SplitRecipePlaceholders.assertIsSplitRecipe(sr);
        return (SplitRecipePayloadParams)JSON.parse((String)context.getCachedPayload(sr), SplitRecipePayloadParams.class);
    }

    public static class Mode
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(SplitRecipePlaceholders.getPayload((FlowDocumentContext)context, (SerializedRecipe)recipe).mode.uiDescription);
        }
    }
}

