/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.grouping;

import com.dataiku.dip.eda.compute.filtering.AndFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CrossGrouping
extends Grouping {
    public static final String TYPE = "cross";
    public List<Grouping> groupings;

    private CrossGrouping() {
    }

    public CrossGrouping(Grouping ... groupings) {
        this.groupings = Lists.newArrayList((Object[])groupings);
    }

    public CrossGrouping(List<Grouping> groupings) {
        this.groupings = groupings;
    }

    public static class CrossGroupingResult
    extends GroupingResult {
        public List<GroupingResult> groups;

        public CrossGroupingResult(GroupingResult ... groups) {
            this.groups = Lists.newArrayList((Object[])groups);
        }

        public CrossGroupingResult(List<GroupingResult> groups) {
            this.groups = Lists.newArrayList(groups);
        }

        private CrossGroupingResult() {
        }

        public int flattenIndex(int ... indexes) {
            assert (indexes.length == this.groups.size());
            int[] sizes = new int[indexes.length];
            for (int dim = 0; dim < indexes.length; ++dim) {
                sizes[dim] = this.groups.get(dim).size();
            }
            int output = 0;
            for (int dim = 0; dim < indexes.length; ++dim) {
                output = sizes[dim] * output + indexes[dim];
            }
            return output;
        }

        public int[] unflattenIndex(int flatIndex) {
            int[] indexes = new int[this.groups.size()];
            for (int dim = indexes.length - 1; dim >= 0; --dim) {
                int size = this.groups.get(dim).size();
                indexes[dim] = flatIndex % size;
                flatIndex /= size;
            }
            return indexes;
        }

        @Override
        public List<Filter> listFilters() {
            assert (this.groups.size() > 0);
            ArrayList<List<Filter>> groupsFilters = new ArrayList<List<Filter>>();
            for (GroupingResult gr : this.groups) {
                groupsFilters.add(gr.listFilters());
            }
            ArrayList<Filter> out = new ArrayList<Filter>();
            Filter[] currentFilters = new Filter[this.groups.size()];
            this.listFiltersRec(0, currentFilters, groupsFilters, out);
            return out;
        }

        private void listFiltersRec(int level, Filter[] currentFilters, List<List<Filter>> groupsFilters, List<Filter> out) {
            if (level == this.groups.size()) {
                out.add(new AndFilter(null, (Filter[])currentFilters.clone()));
                return;
            }
            Iterator<Filter> iterator = groupsFilters.get(level).iterator();
            while (iterator.hasNext()) {
                Filter filter;
                currentFilters[level] = filter = iterator.next();
                this.listFiltersRec(level + 1, currentFilters, groupsFilters, out);
            }
        }

        @Override
        public int size() {
            int size = 1;
            for (GroupingResult gr : this.groups) {
                size *= gr.size();
            }
            return size;
        }
    }
}

