/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.timeseries.MannKendallTest;
import com.dataiku.dip.eda.compute.computations.timeseries.TimeSeriesComputation;
import com.dataiku.dip.eda.worksheets.cards.TimeSeriesCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.eda.worksheets.cards.fragments.TimeInfoFragment;
import com.dataiku.dip.eda.worksheets.models.Variable;
import javax.annotation.Nullable;

public class MannKendallTestCard
extends TimeSeriesCard
implements CardWithConfidenceLevel {
    public static final String TYPE = "mann_kendall_test";
    public double confidenceLevel;

    public MannKendallTestCard(Variable seriesColumn, Variable timeColumn) {
        super(seriesColumn, timeColumn);
    }

    private MannKendallTestCard() {
    }

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    protected TimeSeriesComputation getMainComputation() {
        double alpha = 1.0 - this.confidenceLevel;
        return new MannKendallTest(this.seriesColumn.name, this.timeColumn.name, alpha);
    }

    @Override
    protected TimeSeriesCard.TimeSeriesCardResult buildCardResult(AvailableResult mainComputationResult, BoxPlotFragment boxPlot, TimeInfoFragment timeInfo) {
        MannKendallTest.MannKendallTestResult result = mainComputationResult.as(MannKendallTest.MannKendallTestResult.class);
        return new MannKendallTestCardResult(result, boxPlot, timeInfo);
    }

    public static class MannKendallTestCardResult
    extends TimeSeriesCard.TimeSeriesCardResult {
        public double statistic;
        public double pValue;
        public MannKendallTest.Trend trend;
        public double tau;
        @Nullable
        public Double slope;
        @Nullable
        public Double intercept;

        public MannKendallTestCardResult(MannKendallTest.MannKendallTestResult result, BoxPlotFragment boxPlot, TimeInfoFragment timeInfo) {
            super(boxPlot, timeInfo);
            this.statistic = result.statistic;
            this.pValue = result.pValue;
            this.trend = result.trend;
            this.tau = result.tau;
            this.slope = result.slope;
            this.intercept = result.intercept;
        }

        private MannKendallTestCardResult() {
        }
    }
}

