/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.exposition.LocalProcessExposition;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ExpositionAdapter implements JSON.Adapter<Exposition>
{
    INSTANCE;

    private static final Map<String, Class<? extends ExpositionParams>> expositionParamsMap;
    static DKULogger logger;

    public static void registerType(String type, Class<? extends ExpositionParams> clazz) {
        expositionParamsMap.put(type, clazz);
    }

    public Exposition deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) {
        Exposition exposition = new Exposition();
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        exposition.type = this.has(jsonObj, "type") ? jsonObj.get("type").getAsString() : LocalProcessExposition.META.getType();
        Class<? extends ExpositionParams> clazz = expositionParamsMap.get(exposition.type);
        if (clazz == null) {
            throw new JsonParseException("Web app exposition type " + exposition.type + " is unknown");
        }
        if (this.has(jsonObj, "params")) {
            exposition.params = (ExpositionParams)ctx.deserialize(jsonObj.get("params"), clazz);
        } else {
            try {
                exposition.params = clazz.newInstance();
            }
            catch (Exception e) {
                logger.info((Object)"Failed to instanciate webapp params", (Throwable)e);
            }
        }
        if (exposition.params == null) {
            throw new JsonParseException("Web params are required");
        }
        return exposition;
    }

    public JsonElement serialize(Exposition webApp, Type type, JsonSerializationContext ctx) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("type", webApp.type);
        if (webApp.params != null) {
            jsonObj.add("params", ctx.serialize((Object)webApp.params));
        }
        return jsonObj;
    }

    private boolean has(JsonObject jsonObj, String field) {
        return jsonObj.has(field) && !jsonObj.get(field).isJsonNull();
    }

    static {
        expositionParamsMap = Collections.synchronizedMap(new HashMap());
        logger = DKULogger.getLogger((String)"dku.webapps.serialization");
    }
}

