/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.databricks;

import com.dataiku.dip.externalinfras.ExternalInfrasInputValidator;
import com.dataiku.dip.utils.ErrorContext;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DatabricksInputValidator
extends ExternalInfrasInputValidator {
    private static final Pattern DATABRICKS_ENDPOINT_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9]([\\w-]{0,61}[a-zA-Z0-9])?$");
    public static final int DATABRICKS_ENDPOINT_NAME_MAX_LENGTH = 63;
    private static final Pattern DATABRICKS_WORKSPACE_MODEL_NAME_PATTERN = Pattern.compile("^(?!.*(/.:\\s))[\\p{L}\\d-_]{1,63}$");
    private static final Pattern DATABRICKS_UNITY_CATALOG_MODEL_NAME_PATTERN = Pattern.compile("^(?!.*(/.:\\s)).+\\..+\\.[\\p{L}\\d-_]{1,63}$");
    private static final int DATABRICKS_SERVED_MODEL_NAME_MAX_LENGTH = 63;
    private static final int DATABRICKS_EXPERIMENT_NAME_MAX_LENGTH = 500;

    public static void validateEndpointName(@Nullable String endpointName) {
        if (StringUtils.isEmpty((CharSequence)endpointName)) {
            throw ErrorContext.iae((String)"Databricks endpoint name should not be empty.");
        }
        if (endpointName.length() > 63) {
            throw ErrorContext.iaef((String)"Databricks endpoint name exceeds max length of %d characters: %s", (Object)63, (Object[])new Object[]{endpointName});
        }
        if (!DatabricksInputValidator.matches(DATABRICKS_ENDPOINT_NAME_PATTERN, endpointName)) {
            throw ErrorContext.iaef((String)"Invalid Databricks endpoint name: '%s'", (Object)endpointName, (Object[])new Object[0]);
        }
    }

    @Nonnull
    public static String validateCatalogName(@Nullable String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw ErrorContext.iae((String)"Databricks Unity Catalog catalog name should not be empty.");
        }
        return name;
    }

    @Nonnull
    public static String validateSchemaName(@Nullable String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw ErrorContext.iae((String)"Databricks Unity Catalog schema name should not be empty.");
        }
        return name;
    }

    private static void validateServedModelName(@Nonnull String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw ErrorContext.iae((String)"Databricks served model name should not be empty.");
        }
        if (name.length() > 63) {
            throw ErrorContext.iaef((String)"Databricks served model name exceeds max length of %d characters: %s", (Object)63, (Object[])new Object[]{name});
        }
    }

    public static void validateWorkspaceRegistryModelName(@Nonnull String name) {
        DatabricksInputValidator.validateServedModelName(name);
        if (name.contains(".")) {
            throw ErrorContext.iaef((String)"Databricks Workspace Registry model names shouldn't contain dots: '%s'", (Object)name, (Object[])new Object[0]);
        }
        if (!DatabricksInputValidator.matches(DATABRICKS_WORKSPACE_MODEL_NAME_PATTERN, name)) {
            throw ErrorContext.iaef((String)"Invalid Databricks Workspace Registry model name: '%s'", (Object)name, (Object[])new Object[0]);
        }
    }

    public static void validateUnityCatalogModelName(@Nonnull String name) {
        DatabricksInputValidator.validateServedModelName(name);
        if (!name.contains(".")) {
            throw ErrorContext.iaef((String)"Databricks Unity Catalog model name doesn't meet the required format '<catalog-name>.<schema-name>.<model-name>': '%s'", (Object)name, (Object[])new Object[0]);
        }
        if (!DatabricksInputValidator.matches(DATABRICKS_UNITY_CATALOG_MODEL_NAME_PATTERN, name)) {
            throw ErrorContext.iaef((String)"Invalid Databricks Unity Catalog model name: '%s'", (Object)name, (Object[])new Object[0]);
        }
    }

    @Nonnull
    public static String validateExperimentName(@Nullable String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw ErrorContext.iae((String)"Databricks experiment name should not be empty.");
        }
        if (name.length() > 500) {
            throw ErrorContext.iaef((String)"Databricks experiment name exceeds max length of %d characters: %s", (Object)500, (Object[])new Object[]{name});
        }
        return name;
    }
}

