/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.dataflow.JobKernelUtils;
import com.dataiku.dip.futures.FutureKernelServlet;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.rpc.LocalBackendPrivilegedIntercomAPIClient;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.util.PoiUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SystemUtils;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ServerConnector;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.util.Iterator;
import java.util.function.Supplier;

public class DSSFutureKernelMain {
    public static String id;
    private static int port;
    private static final DKULogger logger;

    public static void main(String[] args) {
        SystemUtils.runAndExitIfExceptionIsThrown(() -> DSSFutureKernelMain.runFekServer(args));
    }

    public static void runFekServer(String[] args) throws Exception {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        ApplicationConfigurator.autoconfigure();
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.FEK);
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.FEK);
        ClusterSelector.setContext(MainLoggingConfigurator.ProcessType.FEK);
        System.setProperty("h2.bindAddress", "127.0.0.1");
        id = args[0];
        logger.info((Object)("Future kernel " + id + " starting, process: " + ManagementFactory.getRuntimeMXBean().getName()));
        BuiltinsLoader.load();
        CLISetup.doFEKSetup();
        logger.info((Object)"Classes loaded, starting server");
        MainLoggingConfigurator.configureLimits();
        HadoopSettings hadoopSettings = new ClusterSelector().selectGlobal().getHadoopSettings();
        HadoopLoader.initializeSecurity(hadoopSettings, true, false);
        if (BuiltinsLoader.apachePoiAvailable()) {
            PoiUtils.initializePoi();
        }
        DKUtils.forceInit(PivotTableRequest.class);
        DKUtils.forceInit(PivotTableResponse.class);
        ScriptStep.loadClass();
        new Thread("stdin-watcher"){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        if (System.in.read() != -1) {
                            continue;
                        }
                        logger.warn((Object)"Standard input closed, exiting");
                        System.exit(0);
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Error reading standard input, exiting", (Throwable)e);
                    System.exit(1);
                    return;
                }
            }
        }.start();
        Server server = DSSFutureKernelMain.getServer();
        port = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
        RemoteRunNetworkingUtils.setServer(MainLoggingConfigurator.ProcessType.FEK, port);
        logger.info((Object)("Kernel FEK started on port " + port + ", registering it"));
        try {
            LocalBackendPrivilegedIntercomAPIClient apiClient = new LocalBackendPrivilegedIntercomAPIClient();
            apiClient.postFormToJSON("/dip/api/pintercom/futures/kernel-register", Void.class, new Object[]{"kernelId", id, "port", port});
            apiClient.close();
            logger.info((Object)"Registration OK, kernel is now ready");
        }
        catch (Exception e) {
            logger.info((Object)"Registration failed, aborting", (Throwable)e);
            System.exit(1);
        }
        server.join();
    }

    private static Server getServer() throws Exception {
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        Server server = null;
        Supplier<HttpServlet> servletProducer = () -> {
            FutureKernelServlet ks = new FutureKernelServlet(SharedSecretUtils.getSharedSecret((boolean)false));
            SpringUtils.getInstance().autowire((Object)ks);
            return ks;
        };
        if (!dssPortRange.enabled) {
            server = JobKernelUtils.createServerWithServlet(0, servletProducer, "/future/*");
            server.start();
        } else {
            assert (dssPortRange.isValid()) : "Port range not defined properly";
            boolean portFound = false;
            Iterator iterator = dssPortRange.getRange().iterator();
            while (iterator.hasNext()) {
                int portCandidate = (Integer)iterator.next();
                server = JobKernelUtils.createServerWithServlet(portCandidate, servletProducer, "/future/*");
                try {
                    server.start();
                    portFound = true;
                    break;
                }
                catch (IOException e) {
                    logger.info((Object)String.format("Task can't use port %d", portCandidate), (Throwable)e);
                }
            }
            if (!portFound) {
                throw new BindException(String.format("Task failed to find usable port in range [%d, %d]", dssPortRange.start, dssPortRange.end));
            }
        }
        return server;
    }

    public static int getKernelPort() {
        if (port == 0) {
            throw new RuntimeException("You're not in a FEK, or the FEK has not been correctly initialized");
        }
        return port;
    }

    public static void setPortDEBUGONLY(int _port) {
        port = _port;
    }

    static {
        port = 0;
        logger = DKULogger.getLogger((String)"dku.future");
    }
}

