/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.input.formats.parquet.LoggingRecordConsumer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;

public class ReusableParquetRow
extends RecordConsumer {
    private static final Action START_MESSAGE = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.startMessage();
        }
    };
    private static final Action END_MESSAGE = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.endMessage();
        }
    };
    private static final Action START_GROUP = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.startGroup();
        }
    };
    private static final Action END_GROUP = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.endGroup();
        }
    };
    private static final Action ADD_BOOLEAN_TRUE = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.addBoolean(true);
        }
    };
    private static final Action ADD_BOOLEAN_FALSE = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.addBoolean(false);
        }
    };
    private static final Action ADD_DOUBLE_ZERO = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.addDouble(0.0);
        }
    };
    private static final Action ADD_DOUBLE_ONE = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.addDouble(1.0);
        }
    };
    private static final Action ADD_FLOAT_ZERO = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.addFloat(0.0f);
        }
    };
    private static final Action ADD_FLOAT_ONE = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.addFloat(1.0f);
        }
    };
    private static final Action ADD_BINARY_EMPTY = new Action(){

        @Override
        public void runOn(RecordConsumer rc) {
            rc.addBinary(Binary.EMPTY);
        }
    };
    private static final int INTEGER_CACHE_MIN = -128;
    private static final int INTEGER_CACHE_MAX = 127;
    private static final Action[] ADD_INTEGER_CACHE = new Action[256];
    private static final int LONG_CACHE_MIN = -128;
    private static final int LONG_CACHE_MAX = 127;
    private static final Action[] ADD_LONG_CACHE;
    private static Logger logger;
    private List<Action> actionQueue = new ArrayList<Action>();

    public void logBuffer() {
        LoggingRecordConsumer log = new LoggingRecordConsumer(new LoggingRecordConsumer.RecordConsumerLogger(){

            @Override
            public void log(int depth, String message) {
                logger.debug((Object)(StringUtils.repeat((String)"   ", (int)(depth + 1)) + message));
            }
        });
        for (Action action : this.actionQueue) {
            action.runOn(log);
        }
    }

    public int size() {
        return this.actionQueue.size();
    }

    public void clear() {
        this.actionQueue.clear();
    }

    public void replay(RecordConsumer rc) {
        int currentPosition = 0;
        try {
            for (Action action : this.actionQueue) {
                action.runOn(rc);
                ++currentPosition;
            }
        }
        catch (Exception e) {
            final int finalCurrentPosition = currentPosition;
            LoggingRecordConsumer loggingRecordConsumer = new LoggingRecordConsumer(new LoggingRecordConsumer.RecordConsumerLogger(){
                int logPosition = 0;

                @Override
                public void log(int depth, String message) {
                    logger.error((Object)(StringUtils.repeat((String)"   ", (int)(depth + 1)) + message));
                    if (this.logPosition == finalCurrentPosition) {
                        logger.error((Object)("=> Parquet reported an error here : " + e.getMessage()));
                    }
                    ++this.logPosition;
                }
            });
            logger.error((Object)"An error occurred when writing a Parquet file. Here is the detailed event buffer:");
            for (Action action : this.actionQueue) {
                action.runOn(loggingRecordConsumer);
            }
            logger.error((Object)"End of Parquet's event buffer\n");
            throw e;
        }
    }

    public void startMessage() {
        this.actionQueue.add(START_MESSAGE);
    }

    public void endMessage() {
        this.actionQueue.add(END_MESSAGE);
    }

    public void startField(final String s, final int i) {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(RecordConsumer rc) {
                rc.startField(s, i);
            }
        });
    }

    public void endField(final String s, final int i) {
        this.actionQueue.add(new Action(){

            @Override
            public void runOn(RecordConsumer rc) {
                rc.endField(s, i);
            }
        });
    }

    public void startGroup() {
        this.actionQueue.add(START_GROUP);
    }

    public void endGroup() {
        this.actionQueue.add(END_GROUP);
    }

    public void addInteger(final int i) {
        if (i >= -128 && i <= 127) {
            this.actionQueue.add(ADD_INTEGER_CACHE[i - -128]);
        } else {
            this.actionQueue.add(new Action(){

                @Override
                public void runOn(RecordConsumer rc) {
                    rc.addInteger(i);
                }
            });
        }
    }

    public void addLong(final long l) {
        if (l >= -128L && l <= 127L) {
            this.actionQueue.add(ADD_LONG_CACHE[(int)(l - -128L)]);
        } else {
            this.actionQueue.add(new Action(){

                @Override
                public void runOn(RecordConsumer rc) {
                    rc.addLong(l);
                }
            });
        }
    }

    public void addBoolean(boolean b) {
        if (b) {
            this.actionQueue.add(ADD_BOOLEAN_TRUE);
        } else {
            this.actionQueue.add(ADD_BOOLEAN_FALSE);
        }
    }

    public void addBinary(final Binary binary) {
        if (binary.length() == 0) {
            this.actionQueue.add(ADD_BINARY_EMPTY);
        } else {
            this.actionQueue.add(new Action(){

                @Override
                public void runOn(RecordConsumer rc) {
                    rc.addBinary(binary);
                }
            });
        }
    }

    public void addFloat(final float v) {
        if (v == 1.0f) {
            this.actionQueue.add(ADD_FLOAT_ONE);
        } else if (v == 0.0f) {
            this.actionQueue.add(ADD_FLOAT_ZERO);
        } else {
            this.actionQueue.add(new Action(){

                @Override
                public void runOn(RecordConsumer rc) {
                    rc.addFloat(v);
                }
            });
        }
    }

    public void addDouble(final double v) {
        if (v == 1.0) {
            this.actionQueue.add(ADD_DOUBLE_ONE);
        } else if (v == 0.0) {
            this.actionQueue.add(ADD_DOUBLE_ZERO);
        } else {
            this.actionQueue.add(new Action(){

                @Override
                public void runOn(RecordConsumer rc) {
                    rc.addDouble(v);
                }
            });
        }
    }

    static {
        int i = -128;
        while (i <= 127) {
            final int val = i++;
            int idx = val - -128;
            ReusableParquetRow.ADD_INTEGER_CACHE[idx] = new Action(){

                @Override
                public void runOn(RecordConsumer rc) {
                    rc.addInteger(val);
                }
            };
        }
        ADD_LONG_CACHE = new Action[256];
        for (i = -128; i <= 127; ++i) {
            final long val = i;
            int idx = i - -128;
            ReusableParquetRow.ADD_LONG_CACHE[idx] = new Action(){

                @Override
                public void runOn(RecordConsumer rc) {
                    rc.addLong(val);
                }
            };
        }
        logger = Logger.getLogger(ReusableParquetRow.class);
    }

    private static interface Action {
        public void runOn(RecordConsumer var1);
    }
}

