/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.im;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.AbstractHttpIntegrationEventHandler;
import com.dataiku.dip.integrations.ChannelizableIntegrationParams;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.IntegrationChannelMeta;
import com.dataiku.dip.integrations.IntegrationChannelParams;
import com.dataiku.dip.integrations.IntegrationEventHandler;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationMeta;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.notifications.DefaultEventMessageBuilder;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.scheduler.reports.ScenarioReportEvent;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IntegrationChannelPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.markups.Markup;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class GoogleChatIntegrationHandler
extends AbstractHttpIntegrationEventHandler {
    public static final IntegrationChannelMeta CHANNEL_META = new IntegrationChannelMeta(){

        public Class<? extends IntegrationChannelParams> paramsClass() {
            return GoogleChatChannelParams.class;
        }

        public String getType() {
            return "google-chat";
        }

        public String getAssociatedIntegrationType() {
            return "google-chat-scenario";
        }
    };
    public static final IntegrationMeta SCENARIO_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "google-chat-scenario";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return GoogleChatScenarioIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new GoogleChatIntegrationHandler(authCtx, messaging.getConfigurationAs(AbstractGoogleChatIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
            configuration.getConfigurationAs(AbstractGoogleChatIntegrationParams.class).encryptFields(symetricCryptoService, security);
        }
    };
    public static final IntegrationMeta PROJECT_META = new IntegrationMeta(){

        @Override
        public String getType() {
            return "google-chat-project";
        }

        @Override
        public Class<? extends IntegrationParams> configurationClass() {
            return GoogleChatProjectIntegrationParams.class;
        }

        @Override
        public IntegrationEventHandler buildHandler(AuthCtx authCtx, IntegrationHook messaging, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
            return new GoogleChatIntegrationHandler(authCtx, messaging.getConfigurationAs(AbstractGoogleChatIntegrationParams.class), permissionCheckContext);
        }

        @Override
        public void prepareForSave(IntegrationHook configuration, PasswordEncryptionService symetricCryptoService, GeneralSettingsDAO.SecuritySettings security) {
            configuration.getConfigurationAs(AbstractGoogleChatIntegrationParams.class).encryptFields(symetricCryptoService, security);
        }
    };
    private final AbstractGoogleChatIntegrationParams params;
    private final GoogleChatChannelParams channelParams;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IntegrationChannelsDAO channelsDao;
    @Autowired
    private PasswordEncryptionService cryptoService;
    @Autowired
    private IntegrationChannelPermissionsService integrationChannelPermissionsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sender.googlechat");

    public GoogleChatIntegrationHandler(AuthCtx authCtx, AbstractGoogleChatIntegrationParams params, IntegrationMeta.PermissionCheckContext permissionCheckContext) throws IOException, DKUSecurityException {
        SpringUtils.getInstance().autowire((Object)this);
        this.params = params;
        if (params.useGlobalChannel()) {
            IntegrationChannel channel;
            try (Transaction ignored = this.transactionService.beginRead();){
                channel = this.channelsDao.getMandatory(params.channelId);
            }
            if (permissionCheckContext.checkCanUseIntegrationChannel) {
                this.integrationChannelPermissionsService.checkIntegrationChannelUse(authCtx, channel);
            }
            this.channelParams = (GoogleChatChannelParams)channel.getConfigurationAs(GoogleChatChannelParams.class);
        } else {
            this.channelParams = new GoogleChatChannelParams();
            this.channelParams.useProxy = params.useProxy;
            this.channelParams.webhookUrl = params.webhookUrl;
            this.channelParams.webhookKey = params.webhookKey;
            this.channelParams.webhookToken = params.webhookToken;
        }
        this.channelParams.webhookKey = this.cryptoService.decryptIfEncrypted(this.channelParams.webhookKey);
        this.channelParams.webhookToken = this.cryptoService.decryptIfEncrypted(this.channelParams.webhookToken);
    }

    @Override
    public void handleEvent(DSSEvent event, InfoMessage.InfoMessages messages) throws Exception {
        if (event instanceof ScenarioReportEvent) {
            ScenarioReportEvent sevent = (ScenarioReportEvent)event;
            GoogleChatScenarioIntegrationParams sconf = (GoogleChatScenarioIntegrationParams)this.params;
            StrSubstitutor substitutor = new StrSubstitutor((StrLookup)sevent.lookup);
            this.send(substitutor.replace(sconf.message));
        } else {
            GoogleChatProjectIntegrationParams pconf = (GoogleChatProjectIntegrationParams)this.params;
            if (!pconf.selection.shouldSend(event)) {
                return;
            }
            String msg = new DefaultEventMessageBuilder().build(event, Markup.GOOGLE_CHAT_MARKDOWN);
            msg = this.markdownify(msg);
            this.send(msg);
        }
    }

    private String markdownify(String msg) {
        return msg.replaceAll("<a\\s(?!</a)href=\"([^\"]*)\"\\s*>([^<]*)</a\\s*>", "<$1|$2>").replaceAll("<br\\s*/>", "\n");
    }

    private void send(String message) throws IOException {
        String json;
        if (StringUtils.isBlank((String)this.channelParams.webhookUrl)) {
            throw new IllegalArgumentException("Webhook url not defined");
        }
        if (message.trim().startsWith("{") && message.trim().endsWith("}")) {
            json = message;
        } else {
            JsonObject payload = new JsonObject();
            payload.addProperty("text", message);
            json = JSON.json((Object)payload);
        }
        URI webhookUrl = this.getWebhookURI(this.channelParams.webhookUrl, this.channelParams.webhookKey, this.channelParams.webhookToken);
        URI webhookUrlForDisplay = this.getWebhookURI(this.channelParams.webhookUrl, "********", "********");
        logger.infoV("Posting GoogleChat message via Webhook %s:\n%s", new Object[]{webhookUrlForDisplay, json});
        AbstractHttpIntegrationEventHandler.RequestResponse response = this.postJsonRequest(webhookUrl, this.channelParams.useProxy, json, NO_AUTH);
        if (!response.isSuccess()) {
            throw new IOException("API call to post message on GoogleChat failed: " + response.statusCode + " with reason " + response.statusReason);
        }
        logger.info((Object)("Report posted on GoogleChat: " + response.content));
    }

    private URI getWebhookURI(String url, @Nullable String key, @Nullable String token) throws IOException {
        try {
            URI webhookUrl = new URI(url);
            if (StringUtils.isNotBlank((String)key) || StringUtils.isNotBlank((String)token)) {
                HashMap<String, String> queryParamsOverrides = new HashMap<String, String>();
                if (StringUtils.isNotBlank((String)key)) {
                    queryParamsOverrides.put("key", key);
                }
                if (StringUtils.isNotBlank((String)token)) {
                    queryParamsOverrides.put("token", token);
                }
                return this.overrideQueryParamsInURI(webhookUrl, queryParamsOverrides);
            }
            return webhookUrl;
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid webhook URL for GoogleChat channel", e);
        }
    }

    private URI overrideQueryParamsInURI(URI uri, Map<String, String> queryParamsOverrides) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(uri);
        ArrayList<Object> patchedQueryParams = new ArrayList<Object>();
        for (Map.Entry<String, String> e : queryParamsOverrides.entrySet()) {
            patchedQueryParams.add(new BasicNameValuePair(e.getKey(), e.getValue()));
        }
        for (NameValuePair queryParam : uriBuilder.getQueryParams()) {
            if (queryParamsOverrides.containsKey(queryParam.getName())) continue;
            patchedQueryParams.add(queryParam);
        }
        return uriBuilder.clearParameters().addParameters(patchedQueryParams).build();
    }

    public static abstract class AbstractGoogleChatIntegrationParams
    extends ChannelizableIntegrationParams
    implements IntegrationParams {
        public String webhookUrl;
        public String webhookKey;
        public String webhookToken;
        public boolean useProxy = true;

        @Override
        public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
            if (securitySettings.secureSecretKeys) {
                this.webhookKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.webhookKey);
                this.webhookToken = cryptoService.encryptIfNotEncryptedOrEmpty(this.webhookToken);
            }
        }
    }

    public static class GoogleChatChannelParams
    extends AbstractHttpIntegrationEventHandler.HTTPChannelConfiguration {
        public String webhookUrl;
        public String webhookKey;
        public String webhookToken;

        public void encryptFields(PasswordEncryptionService cryptoService) {
            this.webhookKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.webhookKey);
            this.webhookToken = cryptoService.encryptIfNotEncryptedOrEmpty(this.webhookToken);
        }
    }

    public static class GoogleChatScenarioIntegrationParams
    extends AbstractGoogleChatIntegrationParams {
        public String message;
    }

    public static class GoogleChatProjectIntegrationParams
    extends AbstractGoogleChatIntegrationParams {
        public SerializedProject.MessagingLikeProjectIntegrationSelection selection = new SerializedProject.MessagingLikeProjectIntegrationSelection();
    }
}

