/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.io.BinaryUtils;
import java.io.IOException;
import org.apache.fontbox.ttf.BufferedRandomAccessFile;

public class BinaryStreamDecoderRAF {
    private byte[] buffer = new byte[10];
    private BufferedRandomAccessFile raf;

    public BinaryStreamDecoderRAF(BufferedRandomAccessFile raf) {
        this.raf = raf;
    }

    public int readLE32() throws IOException {
        this.raf.readFully(this.buffer, 0, 4);
        return BinaryUtils.decodeLE32(this.buffer, 0);
    }

    public void readRawDoubleBlock(int nb, double[] buf) throws IOException {
        byte[] b = new byte[nb * 8];
        this.raf.readFully(b);
        for (int i = 0; i < nb; ++i) {
            long lng = BinaryUtils.decodeLE64(b, 8 * i);
            buf[i] = Double.longBitsToDouble(lng);
        }
    }

    public void readLE32Block(int nb, int[] buf) throws IOException {
        byte[] b = new byte[nb * 4];
        this.raf.readFully(b);
        for (int i = 0; i < nb; ++i) {
            buf[i] = BinaryUtils.decodeLE32(b, 4 * i);
        }
    }

    public String readUTF8(int lengthInBytes) throws IOException {
        byte[] b = new byte[lengthInBytes];
        this.raf.readFully(b);
        return new String(b, "utf8");
    }

    public byte readByte() throws IOException {
        return this.raf.readByte();
    }
}

