/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.labeling.ImageLabelingTask;
import com.dataiku.dip.labeling.ImageViewSettings;
import com.dataiku.dip.labeling.RecordLabelingTask;
import com.dataiku.dip.labeling.TextLabelingTask;
import com.dataiku.dip.labeling.TokenizedTextLabelingTask;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Strings;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@UIModel
public abstract class LabelingTask
extends TaggableObjectsService.TaggableObject {
    @JSON.FileTransient
    public String id;
    @JSON.FileTransient
    public String projectKey;
    public String owner;
    public String name;
    public LabelingTaskType type;
    public ConsensusStrategy consensusStrategy;
    @Nullable
    public String idColumn;
    public String labelColumnName;
    @Nullable
    public String preLabelColumn;
    public List<String> extraColumns = new ArrayList<String>();
    public Map<String, InputRole> inputs = new HashMap<String, InputRole>();
    public Map<String, OutputRole> outputs = new HashMap<String, OutputRole>();
    public List<SimpleKeyValue> classes = new ArrayList<SimpleKeyValue>();
    public String instructions = "";
    public String inputPlaceholder = "Label...";
    public boolean allowEmptyLabels = true;
    public int minNbAnnotatorsPerRecord = 1;
    public boolean autoValidateAnswers = false;
    public List<LabelingPermissionItem> permissions = new ArrayList<LabelingPermissionItem>();
    public LabelingCommentSettings commentSettings = new LabelingCommentSettings();

    @Nullable
    public abstract String dataColumn();

    public ConsensusStrategy getConsensusStrategy() {
        return this.consensusStrategy == null ? ConsensusStrategy.getDefaultStrategy(this.type) : this.consensusStrategy;
    }

    public AnyLoc getMetadataLoc() {
        return this.inputs.get((Object)"metadata").items.get(0).getLoc(this.getProjectKey());
    }

    public AnyLoc getManagedFolderLoc() {
        return this.inputs.get((Object)"data").items.get(0).getLoc(this.getProjectKey());
    }

    public List<LabelingTaskInput> getFlatInputs() {
        ArrayList<LabelingTaskInput> ret = new ArrayList<LabelingTaskInput>();
        for (InputRole role : this.inputs.values()) {
            ret.addAll(role.items);
        }
        return ret;
    }

    public List<LabelingTaskOutput> getFlatOutputs() {
        ArrayList<LabelingTaskOutput> ret = new ArrayList<LabelingTaskOutput>();
        for (OutputRole role : this.outputs.values()) {
            ret.addAll(role.items);
        }
        return ret;
    }

    public void clearOutput(String role, String ref) {
        if (this.outputs.get(role) == null) {
            throw ErrorContext.iaef((String)"Labeling task has no output for role '%s'", (Object)role, (Object[])new Object[0]);
        }
        this.outputs.get((Object)role).items.removeIf(labelingTaskOutput -> labelingTaskOutput.ref.equals(ref));
    }

    public static String getDefaultLabelColumnName(LabelingTaskType type) {
        switch (type) {
            case NAMED_ENTITY_EXTRACTION: 
            case OBJECT_DETECTION: {
                return "labels";
            }
            case IMAGE_CLASSIFICATION: 
            case RECORD_CLASSIFICATION: 
            case TEXT_CLASSIFICATION: 
            case RECORD_FREETEXT: {
                return "label";
            }
        }
        throw new IllegalArgumentException("Unknown labeling task type " + String.valueOf((Object)type));
    }

    private String getMissingMinimalPreconditions() {
        if (this.type.dataType.idColumnMandatory && StringUtils.isBlank((String)this.idColumn)) {
            return "Labeling task is missing mandatory " + this.type.dataType.idColumnName + " column";
        }
        if (this.type.dataType.dataColumnMandatory && StringUtils.isBlank((String)this.dataColumn())) {
            return "Labeling task is missing mandatory data column";
        }
        return null;
    }

    public void checkMinimalPreconditions() {
        String missingCondition = this.getMissingMinimalPreconditions();
        if (missingCondition != null) {
            throw new IllegalStateException(missingCondition);
        }
    }

    public boolean hasMinimalPreconditions() {
        return this.getMissingMinimalPreconditions() == null;
    }

    public boolean hasInputMetadataDataset() {
        return this.inputs.containsKey("metadata");
    }

    @Override
    public String getSubtype() {
        return this.type.name();
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.LABELING_TASK;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Nullable
    public String getPreLabelOutputColumnName() {
        if (Strings.isNullOrEmpty((String)this.preLabelColumn)) {
            return null;
        }
        if (this.preLabelColumn.equalsIgnoreCase(this.labelColumnName)) {
            return "input_" + this.preLabelColumn;
        }
        return this.preLabelColumn;
    }

    public boolean hasCommentsEnabled() {
        return this.commentSettings != null && this.commentSettings.enabled;
    }

    static {
        JSON.registerAdapter(LabelingTask.class, (Object)new JSON.Adapter<LabelingTask>(){

            public LabelingTask deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                LabelingTaskType type = LabelingTaskType.valueOf(jsonObj.get("type").getAsString());
                if (type.dataType == LabelingDataType.IMAGE) {
                    return (LabelingTask)jsonDeserializationContext.deserialize(jsonElement, ImageLabelingTask.class);
                }
                if (type.dataType == LabelingDataType.RECORD) {
                    return (LabelingTask)jsonDeserializationContext.deserialize(jsonElement, RecordLabelingTask.class);
                }
                if (type.dataType == LabelingDataType.TEXT) {
                    if (type == LabelingTaskType.NAMED_ENTITY_EXTRACTION) {
                        return (LabelingTask)jsonDeserializationContext.deserialize(jsonElement, TokenizedTextLabelingTask.class);
                    }
                    return (LabelingTask)jsonDeserializationContext.deserialize(jsonElement, TextLabelingTask.class);
                }
                throw new IllegalArgumentException("Unknown labeling task type: " + String.valueOf((Object)type));
            }

            public JsonElement serialize(LabelingTask task, Type type, JsonSerializationContext ctx) {
                return ctx.serialize((Object)task);
            }
        });
    }

    public static class LabelingCommentSettings {
        public boolean enabled = false;
        public String columnName = "comment";
        public String placeholder = "Comments...";
        public AutoValidateCommentStrategy autoValidateStrategy = AutoValidateCommentStrategy.CONCATENATE_IF_DIFFERENT;
    }

    public static enum ConsensusStrategy {
        AVERAGE,
        MAJORITY;


        private static ConsensusStrategy getDefaultStrategy(LabelingTaskType labelingTaskType) {
            switch (labelingTaskType) {
                case IMAGE_CLASSIFICATION: 
                case NAMED_ENTITY_EXTRACTION: 
                case RECORD_CLASSIFICATION: 
                case TEXT_CLASSIFICATION: 
                case RECORD_FREETEXT: {
                    return MAJORITY;
                }
                case OBJECT_DETECTION: {
                    return AVERAGE;
                }
            }
            return null;
        }
    }

    public static enum LabelingTaskType {
        IMAGE_CLASSIFICATION(LabelingDataType.IMAGE, ImageViewSettings.AnnotationType.IMAGE_CLASSIFICATION, false, true),
        OBJECT_DETECTION(LabelingDataType.IMAGE, ImageViewSettings.AnnotationType.OBJECT_DETECTION, true, true),
        NAMED_ENTITY_EXTRACTION(LabelingDataType.TEXT, null, true, true),
        RECORD_CLASSIFICATION(LabelingDataType.RECORD, null, false, true),
        TEXT_CLASSIFICATION(LabelingDataType.TEXT, null, false, true),
        RECORD_FREETEXT(LabelingDataType.RECORD, null, false, false);

        final ImageViewSettings.AnnotationType annotationType;
        final LabelingDataType dataType;
        public final boolean emptyAnnotationsAllowed;
        public final boolean hasClasses;

        private LabelingTaskType(LabelingDataType dataType, ImageViewSettings.AnnotationType annotationType, boolean emptyAnnotationsAllowed, boolean hasClasses) {
            this.annotationType = annotationType;
            this.dataType = dataType;
            this.emptyAnnotationsAllowed = emptyAnnotationsAllowed;
            this.hasClasses = hasClasses;
        }
    }

    public static class InputRole {
        public List<LabelingTaskInput> items = new ArrayList<LabelingTaskInput>();
    }

    public static class LabelingTaskInput {
        public String ref;

        public AnyLoc getLoc(String contextProjectKey) {
            return AnyLoc.resolveSmart(contextProjectKey, this.ref);
        }

        public LabelingTaskInput(String ref) {
            this.ref = ref;
        }
    }

    public static class OutputRole {
        public List<LabelingTaskOutput> items = new ArrayList<LabelingTaskOutput>();
    }

    public static enum LabelingDataType {
        IMAGE("path", true, false),
        TEXT("id", false, true),
        RECORD("id", true, false);

        public final String idColumnName;
        public final boolean idColumnMandatory;
        public final boolean dataColumnMandatory;

        private LabelingDataType(String idColumnName, boolean idColumnMandatory, boolean dataColumnMandatory) {
            this.idColumnName = idColumnName;
            this.idColumnMandatory = idColumnMandatory;
            this.dataColumnMandatory = dataColumnMandatory;
        }
    }

    public static class LabelingTaskOutput {
        public String ref;

        public AnyLoc getLoc(String contextProjectKey) {
            return AnyLoc.resolveSmart(contextProjectKey, this.ref);
        }

        public LabelingTaskOutput(String ref) {
            this.ref = ref;
        }
    }

    public static class LabelingTaskListItem
    extends TaggableObjectsService.TaggableListItem {
        public String owner;
        public LabelingTaskType type;

        public LabelingTaskListItem(LabelingTask labelingTask) {
            super(labelingTask);
            this.owner = labelingTask.owner;
            this.type = labelingTask.type;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.LABELING_TASK;
        }
    }

    public static class LabelingPermissionItem {
        public String group;
        public String user;
        public boolean annotate;
        public boolean review;
    }

    public static enum AutoValidateCommentStrategy {
        CONCATENATE_IF_DIFFERENT,
        BLOCK_IF_ANY,
        BLOCK_IF_DIFFERENT;

    }
}

