/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.entityextraction;

import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.classification.ClassificationAnnotation;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.Objects;

@UIModel
public class NamedEntity
extends ClassificationAnnotation {
    public String text;
    public Long beginningIndex;
    public Long endIndex;

    public NamedEntity(String category, String text, long beginningIndex, long endIndex) {
        super(category);
        this.text = text;
        this.beginningIndex = beginningIndex;
        this.endIndex = endIndex;
    }

    public void checkFormat() {
        ArrayList<String> missingAttributes = new ArrayList<String>();
        if (Strings.isNullOrEmpty((String)this.category)) {
            missingAttributes.add("category");
        }
        if (Strings.isNullOrEmpty((String)this.text)) {
            missingAttributes.add("text");
        }
        if (this.beginningIndex == null) {
            missingAttributes.add("beginningIndex");
        }
        if (this.endIndex == null) {
            missingAttributes.add("endIndex");
        }
        if (!missingAttributes.isEmpty()) {
            throw new IllegalArgumentException("Invalid annotation format, missing attributes: " + String.join((CharSequence)", ", missingAttributes));
        }
        if (this.beginningIndex < 0L) {
            throw new IllegalArgumentException("Invalid beginningIndex, unexpected negative number: " + this.beginningIndex);
        }
        if (this.endIndex < 0L) {
            throw new IllegalArgumentException("Invalid endIndex, unexpected negative number: " + this.endIndex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        NamedEntity entity = (NamedEntity)o;
        return Objects.equals(this.category, entity.category) && Objects.equals(this.beginningIndex, entity.beginningIndex) && Objects.equals(this.endIndex, entity.endIndex) && Objects.equals(this.text, entity.text);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.text, this.beginningIndex, this.endIndex);
    }

    @Override
    public void validate(LabelingTask task) {
        super.validate(task);
        if (this.text.length() <= 0) {
            throw ErrorContext.iae((String)"Empty labeled text");
        }
        if (this.beginningIndex < 0L || this.endIndex < 0L || this.beginningIndex >= this.endIndex || (long)this.text.length() != this.endIndex - this.beginningIndex) {
            throw ErrorContext.iae((String)"Invalid indices for entity");
        }
    }
}

