/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm;

import com.dataiku.dip.analysis.model.llm.LLMModelSnippetData;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.LLMClient;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nonnull;

public interface LLMModelHandle<M extends Model> {
    public LLMStructuredRef getRef();

    public EnrichedLLMStructuredRef getEnrichedRef();

    public M getModel();

    public static interface FineTuneableModel<FM extends Model>
    extends Model {
        public FM toFineTunedModel(LLMModelSnippetData var1);
    }

    public static interface Model {
        default public boolean canBeFineTuned() {
            return false;
        }

        public Double getPromptCost();

        public Double getCompletionCost();

        public Double getTextEmbeddingCost();

        public Double getImageEmbeddingCost();

        default public Integer getEmbeddingSize() {
            return null;
        }

        default public Integer getMaxTokensLimit() {
            return null;
        }

        public boolean canBeUsedForPurpose(@Nonnull AbstractLLMConnection.LLMUsagePurpose var1);

        public String getId();

        public String getDisplayName();

        default public Optional<String> getInvalidityReason() {
            return Optional.empty();
        }

        default public boolean isValid() {
            return this.getInvalidityReason().isEmpty();
        }

        default public double getEstimatedCompletionCost(Integer promptTokens, Integer completionTokens) {
            Double promptCost = this.getPromptCost();
            Double completionCost = this.getCompletionCost();
            double totalCost = 0.0;
            if (promptCost != null && promptTokens != null) {
                totalCost += promptCost * (double)promptTokens.intValue() / 1000.0;
            }
            if (completionCost != null && completionTokens != null) {
                totalCost += completionCost * (double)completionTokens.intValue() / 1000.0;
            }
            return totalCost;
        }

        default public double getEstimatedEmbeddingCost(Integer promptTokens, int nb_images) {
            Double textCost = this.getTextEmbeddingCost();
            Double imgCost = this.getImageEmbeddingCost();
            double totalCost = 0.0;
            if (textCost != null && promptTokens != null) {
                totalCost += textCost * (double)promptTokens.intValue() / 1000.0;
            }
            if (imgCost != null) {
                totalCost += imgCost * (double)nb_images;
            }
            return totalCost;
        }

        default public double getEstimatedImageGenerationCost(LLMClient.ImageGenerationQuery query) {
            LLMClient.logger.warn((Object)("Unknown pricing for model: " + query.llmId));
            return 0.0;
        }

        public AbstractLLMConnection.ModelCapabilities getModelCapabilities();

        public boolean isEnabled();

        public OptionalInt getBatchSize();

        default public String getBaseModelId() {
            return null;
        }

        default public boolean isOriginalLLMUnreferenced() {
            return false;
        }
    }
}

