/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.langchain;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.llm.langchain.AbstractAgentLLMClient;
import com.dataiku.dip.llm.langchain.PythonLLMServer;
import com.dataiku.dip.llm.langchain.PythonLLMServerKernelPool;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class PythonAgentLLMClient
extends AbstractAgentLLMClient {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.python");

    public PythonAgentLLMClient(DSSAuthCtx authCtx, SavedModel sm, SavedModel.SavedModelInlineVersion smiv, boolean devKernel) {
        super(authCtx, sm, smiv, devKernel);
    }

    @Override
    protected synchronized void initOnce() throws IOException {
        block7: {
            if (this.serverAPI == null) {
                try {
                    String envName = new CodeEnvSelector().selectForPythonRecipe(this.savedModel.projectKey, this.smiv.pythonAgentSettings.codeEnvSelection);
                    String containerConfName = new ContainerExecConfigSelector().selectConfName_autoTXN(this.authCtx, this.savedModel.projectKey, this.smiv.pythonAgentSettings.containerExecSelection);
                    String clusterId = new ClusterSelector().selectForProject(this.authCtx, this.savedModel.projectKey).getClusterId();
                    PythonLLMServerKernelPool kernelPool = (PythonLLMServerKernelPool)SpringUtils.getBean(PythonLLMServerKernelPool.class);
                    if (this.isDevMode()) {
                        File logBaseDir = DKUApp.getFile((String[])new String[]{"saved_models", this.savedModel.projectKey, this.savedModel.id, "versions", this.smiv.versionId, "logs"});
                        PythonLLMServer server = new PythonLLMServer(this.authCtx, this.savedModel.projectKey, this.savedModel.id, this.smiv.versionId, null, this.smiv.code, envName, containerConfName, null, null, logBaseDir, null, null, true, false, true);
                        try {
                            server.start();
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Kernel failed to start, closing it", (Throwable)e);
                            IOUtils.closeQuietly((Closeable)server, null);
                            throw e;
                        }
                        this.serverAPI = server;
                        break block7;
                    }
                    this.serverAPI = kernelPool.getServerAPI(this.authCtx, this.savedModel.projectKey, this.savedModel.id, this.smiv, null, this.smiv.code, null, null, envName, containerConfName, null, null, true, clusterId, this.smiv.pythonAgentSettings, this.devKernel);
                }
                catch (CustomPythonKernelException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException("Failed to initialize Python LLM", e);
                }
            }
        }
    }

    @Override
    public String getProviderId() {
        return "python-agent";
    }
}

