/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.retrieval.RAGKernelPool;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.savedmodels.SavedModelsRetrievalAugmentedLlmService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetrievableKnowledgeCRUDService {
    @Autowired
    private RetrievableKnowledgeDAO dao;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    TaggableObjectDiffService taggableObjectDiffService;
    @Autowired
    PubSubService pubSubService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private RAGKernelPool ragKernelPool;
    @Autowired
    protected PermissionsService permissionsService;
    @Autowired
    private SavedModelsRetrievalAugmentedLlmService retrievalAugmentedLlmService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private SavedModelsCRUDService savedModelsCRUDService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.services.retrievableknowledge");

    public RetrievableKnowledge save(RetrievableKnowledge rk, boolean summaryOnly) throws IOException, CodedException {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)rk.projectKey);
        Preconditions.checkNotNull((Object)rk.id);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RetrievableKnowledge preExisting = (RetrievableKnowledge)this.dao.getOrNullUnsafe(rk.projectKey, rk.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(rk, preExisting);
        TaggableObjectDiffService.TaggableObjectsDiff diff = new TaggableObjectDiffService.TaggableObjectsDiff();
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", rk.name);
        if (rk.name != null && preExisting != null && !rk.name.equals(preExisting.name)) {
            action = TaggableObjectChangedEvent.ActionType.RETRIEVABLE_KNOWLEDGE_RENAME;
            details.addProperty("newName", rk.name);
            details.addProperty("oldName", preExisting.name);
        } else {
            action = TaggableObjectChangedEvent.ActionType.RETRIEVABLE_KNOWLEDGE_EDIT;
            diff = this.taggableObjectDiffService.diff(preExisting, rk, t.getUser().getIdentifier());
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)this.dao.getOrNull(rk.projectKey, rk.id), rk);
        this.dao.save(rk);
        if (diff.metadataChanged()) {
            this.taggableObjectDiffService.publishAfterTransaction(diff);
        }
        if (!summaryOnly) {
            this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE, rk.projectKey, rk.id, t.getUser(), action).withDetails(details));
        }
        this.taggingService.onObjectSaved(rk.projectKey, rk.tags);
        if (action == TaggableObjectChangedEvent.ActionType.RETRIEVABLE_KNOWLEDGE_RENAME) {
            this.graphService.invalidateCache();
        }
        return rk;
    }

    public void delete(AuthCtx liu, String projectKey, String id, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        RetrievableKnowledge rk = (RetrievableKnowledge)this.dao.getOrNull(projectKey, id);
        this.customPolicyHooksRegistry.onPreObjectDelete(liu, rk);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", rk.name);
        this.dao.delete(projectKey, id);
        TaggableObjectsDeletionService.DeletionImpact di = this.computeDeletionImpact(liu, projectKey, id, ignored);
        for (TaggableObjectsDeletionService.ImpactedRecipe recipe : di.deletedRecipes) {
            this.recipeSaveService.delete(recipe.projectKey, recipe.name);
        }
        for (TaggableObjectsDeletionService.ImpactedSavedModel savedModel : di.deletedSavedModels) {
            this.savedModelsDAO.delete(savedModel.projectKey, savedModel.id);
        }
        this.pubSubService.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE, projectKey, id, liu, TaggableObjectChangedEvent.ActionType.RETRIEVABLE_KNOWLEDGE_DELETE).withDetails(details));
    }

    private void addImplicitRecipesToDeletionImpact(AuthCtx authCtx, List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowImplicitRecipe)) continue;
                for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                    if (!(graphNode2 instanceof FlowDataset)) continue;
                    FlowDataset fd = (FlowDataset)graphNode2;
                    SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    di.deletedDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                    di.merge(this.datasetDeletionService.computeDeletionImpact(authCtx, Dataset.fromSerialized(sds), ignored, false));
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get knowledge bank info: ", (Throwable)e);
            }
        }
    }

    private void addForeignImplicitRecipesToDeletionImpact(List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowImplicitRecipe)) continue;
                for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                    if (!(graphNode2 instanceof FlowDataset)) continue;
                    FlowDataset fd = (FlowDataset)graphNode2;
                    SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    di.foreignReadableDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get knowledge bank info: ", (Throwable)e);
            }
        }
    }

    private void addRecipeToDeletionImpact(AuthCtx authCtx, SerializedRecipe sr, TaggableObjectsDeletionService.DeletionImpact di, @Nonnull String contextProjectKey, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws DKUSecurityException {
        String recipeProjectKey = sr.getProjectKey();
        if (ignored == null || !ignored.contains(new TaggableObjectsService.TaggableObjectRef(sr.getProjectKey(), ITaggingService.TaggableType.RECIPE, sr.name))) {
            TaggableObjectsDeletionService.ImpactedRecipe impactedRecipe = new TaggableObjectsDeletionService.ImpactedRecipe(recipeProjectKey, sr.name, sr.type);
            if (contextProjectKey.equals(recipeProjectKey)) {
                di.deletedRecipes.add(impactedRecipe);
            } else if (this.permissionsService.hasProjectPrivilege(authCtx, recipeProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                di.foreignReadableRecipes.add(impactedRecipe);
            }
        }
    }

    private void addRAModelToDeletionImpact(AuthCtx authCtx, SavedModel raModel, TaggableObjectsDeletionService.DeletionImpact di, @Nonnull String contextProjectKey, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        String raModelProjectKey = raModel.getProjectKey();
        if (ignored == null || !ignored.contains(new TaggableObjectsService.TaggableObjectRef(raModelProjectKey, ITaggingService.TaggableType.SAVED_MODEL, raModel.name))) {
            TaggableObjectsDeletionService.ImpactedSavedModel impactedRaModel = new TaggableObjectsDeletionService.ImpactedSavedModel(raModel.projectKey, raModel.getId(), raModel.name, raModel.savedModelType);
            if (contextProjectKey.equals(raModelProjectKey)) {
                di.deletedSavedModels.add(impactedRaModel);
                di.merge(this.savedModelsCRUDService.computeDeletionImpact(authCtx, contextProjectKey, raModelProjectKey, raModel.id, ignored));
            } else if (this.permissionsService.hasProjectPrivilege(authCtx, raModelProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                di.foreignReadableSavedModels.add(impactedRaModel);
            }
        }
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, String projectKey, String rkId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        return this.computeDeletionImpact(authCtx, projectKey, projectKey, rkId, ignored);
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, @Nonnull String contextProjectKey, String projectKey, String rkId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        ProjectFlowGraph graphUnsafe;
        FlowComputable flowComputable;
        TaggableObjectsDeletionService.DeletionImpact di = new TaggableObjectsDeletionService.DeletionImpact();
        AnyLoc rkLoc = new AnyLoc(projectKey, rkId);
        List<SerializedRecipe> connectedRecipes = this.graphService.getSuccessorAndPredecessorRecipesAcrossProjectsUnsafe(rkLoc);
        for (SerializedRecipe serializedRecipe : connectedRecipes) {
            this.addRecipeToDeletionImpact(authCtx, serializedRecipe, di, contextProjectKey, ignored);
        }
        for (SavedModel savedModel : this.retrievalAugmentedLlmService.listRetrievalAugmentedLLMFromKbRef(projectKey, rkId)) {
            this.addRAModelToDeletionImpact(authCtx, savedModel, di, contextProjectKey, ignored);
        }
        if (!contextProjectKey.equals(projectKey)) {
            for (SerializedRecipe serializedRecipe : this.recipesDAO.listUnsafe(contextProjectKey)) {
                if (!serializedRecipe.getFlatInputs().stream().map(input -> input.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(rkLoc)) && !serializedRecipe.getFlatOutputs().stream().map(output -> output.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(rkLoc))) continue;
                this.addRecipeToDeletionImpact(authCtx, serializedRecipe, di, contextProjectKey, ignored);
            }
            String contextRkId = rkLoc.getSmartName(contextProjectKey);
            for (SavedModel raModel : this.retrievalAugmentedLlmService.listRetrievalAugmentedLLMFromKbRef(contextProjectKey, contextRkId)) {
                this.addRAModelToDeletionImpact(authCtx, raModel, di, contextProjectKey, ignored);
            }
        }
        if ((flowComputable = (graphUnsafe = this.graphService.getProjectGraphUnsafe(projectKey)).getComputable(projectKey + "." + rkId)) != null) {
            this.addImplicitRecipesToDeletionImpact(authCtx, flowComputable.getSuccessors(), di, ignored);
        }
        Set<String> smExpositionTargetProjects = this.projectsService.getObjectExpositionTargetProjects(rkLoc.getProjectKey(), rkLoc.getId());
        for (String targetProject : smExpositionTargetProjects) {
            if (!this.permissionsService.hasProjectPrivilege(authCtx, targetProject, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
            ProjectFlowGraph foreignGraphUnsafe = this.graphService.getProjectGraphUnsafe(targetProject);
            FlowComputable foreignFcUnsafe = foreignGraphUnsafe.getComputable(projectKey + "." + rkId);
            if (foreignFcUnsafe != null) {
                this.addForeignImplicitRecipesToDeletionImpact(foreignFcUnsafe.getSuccessors(), di, ignored);
            }
            String targetRkId = rkLoc.getSmartName(targetProject);
            for (SavedModel raModel : this.retrievalAugmentedLlmService.listRetrievalAugmentedLLMFromKbRef(targetProject, targetRkId)) {
                this.addRAModelToDeletionImpact(authCtx, raModel, di, projectKey, ignored);
            }
        }
        return di;
    }
}

