/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec.engine;

import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.engine.SmoothlyClosableRunner;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.drift.DriftParams;
import com.dataiku.dip.mec.drift.DriftResult;
import com.dataiku.dip.mec.engine.DriftKernelProtocol;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DriftRunner
extends SmoothlyClosableRunner<DriftKernelProtocol> {
    Lock lock = new ReentrantLock();

    public DriftRunner(DriftKernelProtocol runner) {
        super(runner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DriftResult compute(DriftParams params, ModelLikeId referenceModelLikeId, ModelLikeId currentModelLikeId, String jobId, boolean computePredictionDrift, double referenceThreshold, double currentThreshold) throws Exception {
        this.incRefCount();
        Object referenceId = referenceModelLikeId.toString();
        try {
            this.lock.lockInterruptibly();
            if (this.isDeadKernel()) {
                ((DriftKernelProtocol)this.runner).getKernel().start();
            }
            if (referenceModelLikeId.equals(currentModelLikeId) && referenceModelLikeId instanceof FullModelEvaluationId) {
                if (!((FullModelEvaluationId)referenceModelLikeId).hasDriftReference()) throw new IllegalArgumentException("Reference not available");
                referenceId = (String)referenceId + "-reference";
                ((DriftKernelProtocol)this.runner).loadReferenceModelEvaluationWithDriftReferenceAndStatistics((FullModelEvaluationId)referenceModelLikeId);
            } else {
                ((DriftKernelProtocol)this.runner).loadModelLike(referenceModelLikeId);
            }
            ((DriftKernelProtocol)this.runner).loadModelLike(currentModelLikeId);
            DriftResult driftResult = ((DriftKernelProtocol)this.runner).computeDrift(params, (String)referenceId, currentModelLikeId.toString(), jobId, computePredictionDrift, referenceThreshold, currentThreshold);
            return driftResult;
        }
        catch (Exception e) {
            ((DriftKernelProtocol)this.runner).close();
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDeadKernel() {
        return ((DriftKernelProtocol)this.runner).getKernel().getLink() == null || !((DriftKernelProtocol)this.runner).getKernel().isAlive();
    }
}

