/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.notebooks;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.notebooks.NotebookExpansionKernel;
import com.dataiku.dip.notebooks.NotebookTemplateDesc;
import com.dataiku.dip.plugins.model.ComputedPluginContent;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.util.AbstractTemplateService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class NotebooksTemplatesService
extends AbstractTemplateService<NotebookTemplateDesc> {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.notebooks.templates");

    @Override
    protected void finalizeTemplate(NotebookTemplateDesc td, Map<String, String> params) {
        if (td != null && params != null && params.containsKey("language")) {
            td.language = params.get("language");
        }
    }

    public AbstractTemplateService.TemplateDescs<NotebookTemplateDesc> listOfType(NotebookTemplateDesc.NotebookTemplateType type, String language) throws IOException {
        String typeLower = type.toString().toLowerCase();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("language", language);
        AbstractTemplateService.TemplateDescs<NotebookTemplateDesc> ret = this.listTemplates(NotebookTemplateDesc.class, params, "notebook-templates", typeLower, language);
        ListIterator it = ret.templates.listIterator();
        while (it.hasNext()) {
            NotebookTemplateDesc td = (NotebookTemplateDesc)it.next();
            logger.info((Object)("Template is for " + td.onlyForSparkVersion + "  sv is " + SparkSubmitHelper.SPARK_VERSION));
            if (td.onlyForSparkVersion == null || SparkSubmitHelper.SPARK_VERSION.startsWith(td.onlyForSparkVersion)) continue;
            it.remove();
        }
        return ret;
    }

    public List<ComputedPluginContent.ContributionWithId> listTemplatesInPluginOfType(String pluginId, File pluginDir, String type, String language) {
        String typeToLower = type.toLowerCase();
        return this.listTemplatesInPlugin(pluginId, pluginDir, "notebook-templates", typeToLower, language);
    }

    public JupyterUtils.NotebookSafeForWritingNew expandJupyter(String targetProjectKey, NotebookTemplateDesc desc, NotebookTemplateDesc.NotebookTemplateType type, TaggableObjectsService.TaggableObject taggableObject) throws Exception {
        String typeLower = type.toString().toLowerCase();
        File templateDir = this.getTemplateDirectory(desc, "notebook-templates", typeLower, desc.language, desc.id);
        File templateFile = DKUFileUtils.getWithin((File)templateDir, (String[])new String[]{"notebook.ipynb"});
        File expanderFile = DKUFileUtils.getWithin((File)templateDir, (String[])new String[]{"expand.py"});
        logger.info((Object)("Reading notebook template from " + String.valueOf(templateFile)));
        String rawNotebook = DKUFileUtils.readFileToStringUTF8((File)templateFile);
        switch (type) {
            case DATASET: {
                rawNotebook = this.expandDataset(rawNotebook, targetProjectKey, expanderFile, (SerializedDataset)taggableObject);
                break;
            }
            case STANDALONE: {
                if (taggableObject != null) {
                    throw new IllegalArgumentException("With STANDALONE template type no TaggableObject should be provided");
                }
                rawNotebook = this.expandWithPythonScript(expanderFile, rawNotebook, targetProjectKey, null);
                break;
            }
            case RETRIEVABLE_KNOWLEDGE: {
                rawNotebook = this.expandRetrievableKnowledge(rawNotebook, (RetrievableKnowledge)taggableObject);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf((Object)type) + " is not a valid notebook template type");
            }
        }
        JupyterUtils.NotebookSafeForWritingNew nsf = (JupyterUtils.NotebookSafeForWritingNew)JSON.parse((String)rawNotebook, JupyterUtils.NotebookSafeForWritingNew.class);
        for (JupyterUtils.CellForWriting cell : nsf.cells) {
            if (!"code".equals(cell.cell_type)) {
                cell.execution_count = null;
                cell.outputs = null;
                continue;
            }
            cell.execution_count = 0;
        }
        return nsf;
    }

    private String expandWithPythonScript(File expanderFile, String rawNotebook, String targetProjectKey, SerializedDataset dataset) throws Exception {
        if (expanderFile.exists()) {
            logger.info((Object)("An expansion script is available, we will use it to expand the notebook template: " + expanderFile.getPath()));
            String expansionCode = DKUFileUtils.readFileToStringUTF8((File)expanderFile);
            rawNotebook = this.runPythonExpansion(rawNotebook, expansionCode, targetProjectKey, dataset);
        }
        return rawNotebook;
    }

    private String expandDataset(String rawNotebook, String targetProjectKey, File expanderFile, SerializedDataset dataset) throws Exception {
        if (expanderFile.exists()) {
            rawNotebook = this.expandWithPythonScript(expanderFile, rawNotebook, targetProjectKey, dataset);
        } else {
            rawNotebook = rawNotebook.replace("__INPUT_DATASET_FULL_NAME__", dataset.getFullName());
            rawNotebook = rawNotebook.replace("__INPUT_DATASET_SMART_NAME__", AnyLoc.resolveFull(dataset.getFullName()).getSmartName(targetProjectKey));
            rawNotebook = rawNotebook.replace("__INPUT_DATASET_CLEAN_NAME__", dataset.name);
        }
        return rawNotebook;
    }

    private String expandRetrievableKnowledge(String rawNotebook, RetrievableKnowledge rk) {
        rawNotebook = rawNotebook.replace("__RETRIEVABLE_KNOWLEDGE_ID__", rk.id);
        return rawNotebook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runPythonExpansion(String notebookData, String expansionCode, String projectKey, SerializedDataset dataset) throws Exception {
        String secret = SecretKeyGenerator.generate((int)16);
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        SingleCommandKernelLink link = new SingleCommandKernelLink(secret, dssPortRange);
        NotebookExpansionKernel kernel = new NotebookExpansionKernel(link, projectKey);
        kernel.start();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            NotebookExpansionKernel.PythonCommand command = new NotebookExpansionKernel.PythonCommand(notebookData, expansionCode);
            if (StringUtils.isNotBlank((String)projectKey)) {
                command = command.withProjectKey(projectKey);
            }
            if (dataset != null) {
                command = command.withDataset(dataset.getProjectKey(), dataset.name);
            }
            try {
                link.executeStream((Object)command, (OutputStream)baos);
            }
            finally {
                link.acknowledgeLastCall((DSSKernelBase)kernel, null, "Failed to expand notebook template");
            }
            if (baos.size() > 0) {
                String string = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                return string;
            }
            String string = null;
            return string;
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)kernel);
            throw kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        finally {
            logger.info((Object)"Cleaning up python expander");
            logger.info((Object)Joiner.on((String)"\n").join((Iterable)kernel.getLogTail().lines));
            link.close();
            kernel.killWithoutMercy();
        }
    }
}

