/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.datebinner;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.Weeks;
import com.google.common.annotations.VisibleForTesting;

class WeekYear {
    private static final DateTime ORIGIN = WeekYear.buildDateTime(0, 1);
    int weekOfYear;
    int year;
    int weekNumberSinceOrigin;

    private WeekYear(int year, int weekOfYear) {
        this.weekOfYear = weekOfYear;
        this.year = year;
        this.weekNumberSinceOrigin = this.computeWeeksSinceOrigin();
    }

    @VisibleForTesting
    WeekYear(int year, int weekOfYear, int weekNumberSinceOrigin) {
        this.year = year;
        this.weekOfYear = weekOfYear;
        this.weekNumberSinceOrigin = weekNumberSinceOrigin;
    }

    static WeekYear fromTimestamp(long timestamp) {
        DateTime dt = new DateTime(timestamp, DateTimeZone.UTC);
        return new WeekYear(dt.getWeekyear(), dt.getWeekOfWeekyear());
    }

    static WeekYear fromWeekNumberSinceOrigin(int weekNumberSinceOrigin) {
        if (weekNumberSinceOrigin == 0) {
            throw new IllegalArgumentException("Week number starts at 1.");
        }
        DateTime dateTime = ORIGIN.plusWeeks(weekNumberSinceOrigin - 1);
        return new WeekYear(dateTime.getWeekyear(), dateTime.getWeekOfWeekyear(), weekNumberSinceOrigin);
    }

    long getWeekStartTimestamp() {
        return WeekYear.buildDateTime(this.year, this.weekOfYear).getMillis();
    }

    String getWeekLabel() {
        return String.format("%s-W%s", this.year, this.weekOfYear);
    }

    private int computeWeeksSinceOrigin() {
        DateTime dateTime = WeekYear.buildDateTime(this.year, this.weekOfYear);
        return Weeks.weeksBetween((ReadableInstant)ORIGIN, (ReadableInstant)dateTime).getWeeks() + 1;
    }

    private static DateTime buildDateTime(int weekYear, int weekOfWeekYear) {
        return new DateTime(0, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC).withWeekyear(weekYear).withWeekOfWeekyear(weekOfWeekYear).withDayOfWeek(1);
    }
}

