/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSStartedEvent;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.PivotTablesService;
import com.dataiku.dip.pivot.backend.dss.LinoCacheBuilderService;
import com.dataiku.dip.pivot.backend.dss.LinoUtils;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.ColumnSummary;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.maps.PivotTableWebappResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.model.ShakerSamplingUtils;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NamedRWLock;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class LinoPivotTablesService
implements ApplicationListener<DSSStartedEvent> {
    @Autowired
    private DataService shakerDataService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private LinoUtils linoUtils;
    @Autowired
    private VariablesService variablesService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.charts.lino.service");

    public static LinoReader getCachedReader(File cacheFolder, PivotTableRequest request) throws IOException {
        if (cacheFolder != null && cacheFolder.isDirectory()) {
            LinoReader cacheReader;
            logger.info((Object)("Open cache: " + String.valueOf(cacheFolder)));
            try {
                cacheReader = new LinoReader(cacheFolder, "cache");
            }
            catch (IOException e) {
                logger.info((Object)"Invalid cache", (Throwable)e);
                DKUFileUtils.deleteDirectory((File)cacheFolder);
                return null;
            }
            logger.info((Object)"Cache is open");
            if (request == null || LinoUtils.hasAllColumns(request, cacheReader)) {
                return cacheReader;
            }
            logger.info((Object)"Don't use cache, bad column");
        } else {
            logger.info((Object)"No cache");
        }
        return null;
    }

    public static File getLinoCacheFolder(String shakerId, String sampleId, long minimumRefreshTrigger) {
        Preconditions.checkNotNull((Object)shakerId);
        Preconditions.checkNotNull((Object)sampleId);
        File sampleIdFolder = ApplicationConfigurator.getFile((String[])new String[]{"caches/shaker-full-pivot-lino/", shakerId, sampleId});
        if (sampleIdFolder.isDirectory()) {
            logger.debug((Object)("There are existing samples for " + shakerId + ", checking for one matching minimumRefreshTrigger=" + minimumRefreshTrigger));
            for (File f : sampleIdFolder.listFiles()) {
                long refreshTrigger;
                if (!f.isDirectory() || !StringUtils.isNumeric((String)f.getName()) || (refreshTrigger = Long.parseLong(f.getName())) < minimumRefreshTrigger) continue;
                logger.info((Object)("Accepted:" + String.valueOf(f)));
                return f;
            }
            logger.debug((Object)"None matched minimumRefreshTrigger");
        } else {
            logger.debug((Object)("There are no existing samples for " + shakerId));
        }
        long now = System.currentTimeMillis();
        long usedRefreshTrigger = Math.max(now, minimumRefreshTrigger);
        return new File(sampleIdFolder, "" + usedRefreshTrigger);
    }

    public ColumnSummary getColumnSummary_NT(AuthCtx authCtx, Dataset dataset, SerializedShakerScript scriptForTypes, SerializedShakerScript.RefreshableStreamableSelection sampleSettings, List<ScriptStep> steps) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        MemTable mt = this.shakerDataService.get_NOTRANSACTION((Dataset)dataset, (SerializedShakerScript)scriptForTypes, null, null, (boolean)true, (AuthCtx)authCtx).table;
        ColumnSummary ret = new ColumnSummary();
        ret.requiredSampleId = ShakerSamplingUtils.computeSampleId(authCtx, dataset, sampleSettings, steps, mt);
        this.linoUtils.fillUsableColumns(mt, ret);
        return ret;
    }

    public FutureResponse<PivotTablesService.Response> getResponse_NT(AuthCtx authCtx, Dataset ds, String requestedSampleId, SerializedShakerScript scriptForTypes, SerializedShakerScript.RefreshableStreamableSelection sampleSettings, List<ScriptStep> steps, PivotTableRequest request) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        MemTable mt = null;
        if (StringUtils.isBlank((String)requestedSampleId)) {
            logger.debug((Object)"No requestedSampleId, computing it now");
            mt = this.shakerDataService.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)scriptForTypes, null, null, (boolean)true, (AuthCtx)authCtx).table;
            requestedSampleId = ShakerSamplingUtils.computeSampleId(authCtx, ds, sampleSettings, steps, mt);
        }
        logger.info((Object)("Lookup cache requestedSampleId: " + requestedSampleId));
        String datasetPath = ds.getProjectKey() + "_" + ds.getName();
        File cacheFolder = LinoPivotTablesService.getLinoCacheFolder(datasetPath, requestedSampleId, sampleSettings._refreshTrigger);
        String lockName = "dku.pivot.lino.cacheBuild." + datasetPath + "." + requestedSampleId;
        try (AutoCloseableLock lock = NamedRWLock.acquireRead((String)lockName);){
            LinoReader cacheReader;
            block22: {
                cacheReader = LinoPivotTablesService.getCachedReader(cacheFolder, request);
                try {
                    if (request instanceof PivotTableTensorRequest) {
                        for (AxisDef axis : ((PivotTableTensorRequest)request).axes) {
                            Preconditions.checkNotNull((Object)axis);
                        }
                    }
                    if (cacheReader == null) break block22;
                    logger.info((Object)"Got cache, start execution");
                    FutureResponse fr = new FutureResponse();
                    fr.hasResult = true;
                    fr.result = new PivotTablesService.Response();
                    ((PivotTablesService.Response)fr.result).updatedSampleId = requestedSampleId;
                    ((PivotTablesService.Response)fr.result).pivotResponse = LinoUtils.fromLino(request, cacheReader, this.variablesService.getContext(scriptForTypes.contextProjectKey));
                    LinoUtils.enrichWithSamplingMetadata(((PivotTablesService.Response)fr.result).pivotResponse, cacheFolder);
                    if (((PivotTablesService.Response)fr.result).pivotResponse instanceof PivotTableWebappResponse) {
                        ((PivotTableWebappResponse)((PivotTablesService.Response)fr.result).pivotResponse).projectKey = ds.getProjectKey();
                        ((PivotTableWebappResponse)((PivotTablesService.Response)fr.result).pivotResponse).datasetName = ds.getName();
                    }
                    if (request.computeUsableColumns) {
                        logger.debug((Object)"Computing usable columns");
                        if (mt == null) {
                            logger.debug((Object)"Need to open Shaker MemTable first");
                            mt = this.shakerDataService.get_NOTRANSACTION((Dataset)ds, (SerializedShakerScript)scriptForTypes, null, null, (boolean)true, (AuthCtx)authCtx).table;
                        }
                        ((PivotTablesService.Response)fr.result).pivotResponse.columnsSummary = new ColumnSummary();
                        this.linoUtils.fillUsableColumns(mt, ((PivotTablesService.Response)fr.result).pivotResponse.columnsSummary);
                    }
                    FutureResponse futureResponse = fr;
                    if (cacheReader != null) {
                        cacheReader.close();
                    }
                    return futureResponse;
                }
                catch (Throwable throwable) {
                    if (cacheReader != null) {
                        try {
                            cacheReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            PivotResponseFutureThread ftfd = new PivotResponseFutureThread(request, ds, scriptForTypes, sampleSettings, steps, (DSSAuthCtx)authCtx, this.shakerDataService, this.futureService, lockName, requestedSampleId);
            FutureResponse<PivotTablesService.Response> futureResponse = this.futureService.runFuture(ftfd, 0L, new TypeToken<FutureResponse<PivotTablesService.Response>>(){});
            if (cacheReader != null) {
                cacheReader.close();
            }
            return futureResponse;
        }
    }

    public static FuturePayload buildFuturePayload(Dataset dataset) {
        FuturePayload fp = new FuturePayload();
        fp.action = "refresh_chart_script";
        fp.targets.add(DSSFuturePayloadUtils.forDataset(dataset).withPart("charts"));
        fp.displayName = "Refreshing plotted values";
        return fp;
    }

    public void onApplicationEvent(DSSStartedEvent dssStartedEvent) {
        try {
            File rootAggregators = ApplicationConfigurator.getFile((String[])new String[]{"tmp", "aggregators"});
            if (rootAggregators.exists()) {
                DKUFileUtils.forceDelete((File)rootAggregators);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Cannot delete temporary folder for aggregators", (Throwable)e);
        }
    }

    public static class PivotResponseFutureThread
    extends FutureThread<PivotTablesService.Response> {
        final DataService shakerDataService;
        final FutureService futureService;
        final SerializedShakerScript scriptForTypeHandling;
        final List<ScriptStep> steps;
        final FuturePayload futurePayload;
        private final String rwLockName;
        final SerializedShakerScript.RefreshableStreamableSelection sampleSettings;
        final Dataset dataset;
        String usedSampleId;
        final String originallyRequestedSampleId;
        final PivotTableRequest request;
        PivotTableResponse response;
        @Autowired
        private LinoUtils linoUtils;
        @Autowired
        private VariablesService variablesService;

        public PivotResponseFutureThread(PivotTableRequest request, Dataset dataset, SerializedShakerScript scriptForTypeHandling, SerializedShakerScript.RefreshableStreamableSelection sampleSettings, List<ScriptStep> steps, DSSAuthCtx user, DataService shakerDataService, FutureService futureService, String rwLockName, String originallyRequestedSampleId) {
            super(user);
            this.request = request;
            this.dataset = dataset;
            this.scriptForTypeHandling = scriptForTypeHandling;
            this.sampleSettings = sampleSettings;
            this.steps = steps;
            this.rwLockName = rwLockName;
            this.shakerDataService = shakerDataService;
            this.futureService = futureService;
            this.futurePayload = LinoPivotTablesService.buildFuturePayload(dataset);
            this.originallyRequestedSampleId = originallyRequestedSampleId;
            SpringUtils.getInstance().autowire((Object)this);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() throws Exception {
            logger.info((Object)"Starting execution thread");
            String shakerId = this.dataset.getProjectKey() + "_" + this.dataset.getName();
            File originallyRequestedCacheFolder = LinoPivotTablesService.getLinoCacheFolder(shakerId, this.originallyRequestedSampleId, this.sampleSettings._refreshTrigger);
            try (AutoCloseableLock lock = NamedRWLock.acquireWrite((String)this.rwLockName);){
                logger.info((Object)("Rechecking cache: " + String.valueOf(originallyRequestedCacheFolder)));
                LinoReader cacheReader = LinoPivotTablesService.getCachedReader(originallyRequestedCacheFolder, this.request);
                if (cacheReader == null) {
                    logger.info((Object)"Cache is still not here, building it for real");
                    LinoCacheBuilderService cacheBuilderService = new LinoCacheBuilderService(this.request, this.dataset, this.scriptForTypeHandling, this.sampleSettings, this.steps, this.owner, this.shakerDataService);
                    try (FutureAborter.AutoCloseableAbortHook abort = FutureAborter.pushAutoCloseableHook(cacheBuilderService::abortHook);){
                        cacheBuilderService.buildLinoCache();
                        this.usedSampleId = cacheBuilderService.usedSampleId;
                    }
                } else {
                    logger.info((Object)"Cache got filled, not building it!");
                    cacheReader.close();
                    this.usedSampleId = this.originallyRequestedSampleId;
                }
                if (!this.usedSampleId.equals(this.originallyRequestedSampleId)) {
                    logger.warnV("Built a sample different than the one initially requested: initial=%s built=%s", new Object[]{originallyRequestedCacheFolder, this.usedSampleId});
                }
                File cacheFolder = LinoPivotTablesService.getLinoCacheFolder(shakerId, this.usedSampleId, this.sampleSettings._refreshTrigger);
                try (LinoReader reader = new LinoReader(cacheFolder, "cache");){
                    this.response = LinoUtils.fromLino(this.request, reader, this.variablesService.getContext(this.dataset.getProjectKey()));
                    LinoUtils.enrichWithSamplingMetadata(this.response, cacheFolder);
                }
                if (this.response instanceof PivotTableWebappResponse) {
                    ((PivotTableWebappResponse)this.response).projectKey = this.dataset.getProjectKey();
                    ((PivotTableWebappResponse)this.response).datasetName = this.dataset.getName();
                }
                if (this.request.computeUsableColumns) {
                    logger.debug((Object)"Computing usable columns, opening Shaker MemTable first");
                    MemTable mt = this.shakerDataService.get_NOTRANSACTION((Dataset)this.dataset, (SerializedShakerScript)this.scriptForTypeHandling, null, null, (boolean)true, (AuthCtx)this.owner).table;
                    this.response.columnsSummary = new ColumnSummary();
                    this.linoUtils.fillUsableColumns(mt, this.response.columnsSummary);
                }
            }
        }

        public PivotTablesService.Response getResult() {
            PivotTablesService.Response r = new PivotTablesService.Response();
            r.pivotResponse = this.response;
            r.updatedSampleId = this.usedSampleId;
            return r;
        }
    }
}

