/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.executors.GlobalStatsSQLExecutor;
import com.dataiku.dip.pivot.backend.sql.queries.BasicStatsToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class GlobalStatsHybridExecutor
implements Callable<BasicStatsBuilder.BasicStats> {
    private static final DKULogger logger = DKULogger.getLogger(GlobalStatsHybridExecutor.class);
    private final Future<ColumnMapper> colMappingFuture;
    private final ExecutionContext ctx;

    public GlobalStatsHybridExecutor(ExecutionContext ctx, Future<ColumnMapper> colMappingFuture) {
        this.colMappingFuture = colMappingFuture;
        this.ctx = ctx;
    }

    @Override
    public BasicStatsBuilder.BasicStats call() throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Computing global column statistics...");){
            ArrayList<String> bsCols = new ArrayList<String>();
            for (AxisDef axisDef : BasicStatsToSQL.determineDependentColumns(this.ctx.req, true)) {
                bsCols.add(axisDef.column);
            }
            BasicStatsBuilder.BasicStats stats = this.ctx.cache.columnsStatsCache.get(bsCols);
            if (stats != null) {
                logger.info((Object)"Computed global column stats from cache");
                BasicStatsBuilder.BasicStats basicStats = stats;
                return basicStats;
            }
            if (bsCols.isEmpty()) {
                BasicStatsBuilder.BasicStats basicStats = null;
                return basicStats;
            }
            GlobalStatsSQLExecutor globalStatsSQLExecutor = new GlobalStatsSQLExecutor(this.ctx, this.colMappingFuture);
            stats = globalStatsSQLExecutor.call();
            this.ctx.cache.columnsStatsCache.put(stats);
            BasicStatsBuilder.BasicStats basicStats = stats;
            return basicStats;
        }
    }
}

