/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.pivot.backend.common.PivotPostprocessor;
import com.dataiku.dip.pivot.backend.common.automaticbin.SqlEngineAutomaticRequestHandler;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.model.SideResponseKey;
import com.dataiku.dip.pivot.backend.model.SimpleAggregatedRequest;
import com.dataiku.dip.pivot.backend.sql.SQLPivotListener;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.builders.InMemoryResultSet;
import com.dataiku.dip.pivot.backend.sql.builders.NonBinnedBuilder;
import com.dataiku.dip.pivot.backend.sql.builders.SimplePivotBuilder;
import com.dataiku.dip.pivot.backend.sql.builders.TensorPivotBuilder;
import com.dataiku.dip.pivot.backend.sql.cache.AxisCache;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.executors.SqlExecutionHelper;
import com.dataiku.dip.pivot.backend.sql.queries.AxisMaterializerToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.BasicStatsToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.SimpleAxisToSQL;
import com.dataiku.dip.pivot.backend.sql.queries.TensorToSQL;
import com.dataiku.dip.pivot.backend.sql.utils.AxisUtils;
import com.dataiku.dip.pivot.backend.sql.utils.ConnectionPool;
import com.dataiku.dip.pivot.backend.sql.utils.ConnectionsUtils;
import com.dataiku.dip.pivot.backend.sql.utils.NullableDoubleArrayList;
import com.dataiku.dip.pivot.backend.sql.utils.NullableLongArrayList;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.PrestoSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class MainPivotHybridExecutor
implements Callable<PivotTableResponse> {
    private static final String CREATING_CHART = "Creating chart...";
    private final Future<ColumnMapper> colMappingFuture;
    private final ExecutionContext ctx;
    private final Future<BasicStatsBuilder.BasicStats> basicStatsFuture;
    private final Future<BasicStatsBuilder.BasicStats> globalStatsFuture;
    private ConnectionPool.PooledConnection connection;
    private final SQLDialect dialect;
    private final List<String> dropTables = new ArrayList<String>();
    private static final DKULogger logger = DKULogger.getLogger(MainPivotHybridExecutor.class);

    public MainPivotHybridExecutor(ExecutionContext ctx, Future<ColumnMapper> colMappingFuture, Future<BasicStatsBuilder.BasicStats> basicStatsFuture, Future<BasicStatsBuilder.BasicStats> globalStatsFuture) {
        this.ctx = ctx;
        this.colMappingFuture = colMappingFuture;
        this.basicStatsFuture = basicStatsFuture;
        this.globalStatsFuture = globalStatsFuture;
        this.dialect = ctx.input.dialect;
    }

    private void buildIndexesOnTempTable(AxisMaterializerToSQL.MaterializedAxesContext axes, List<InMemoryResultSet> axesData) throws SQLException, InterruptedException {
        if (this.ctx.input.dialect.supportsIndexingOnTemporaryTables()) {
            for (int i = 0; i < axes.axes.size(); ++i) {
                AxisMaterializerToSQL.MaterializedAxis axis = axes.axes.get(i);
                boolean requireJoin = axes.axes.size() == 1 ? SimpleAxisToSQL.requireJoin(axis, axesData.get(i)) : TensorToSQL.requireJoin(axis.axis.def, axesData.get(i));
                if (!requireJoin) continue;
                try (ConnectionPool.ManagedStatement stmt = this.getConnection().getStatement();
                     FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);){
                    logger.info((Object)("\n\n-- SQL query for indexing axis table:\n\n" + axis.createIndexQuery + "\n"));
                    SqlExecutionHelper.execute(this.connection, stmt, axis.createIndexQuery, false);
                    continue;
                }
            }
        }
    }

    private void recreateAxisTableFromCache(AxisCache.CachedAxis axis, SQLUtils.SQLTable table, String axisName) throws SQLException, InterruptedException {
        Object values = axis.imrs.axes[0];
        String sqlType = values instanceof NullableDoubleArrayList || values instanceof NullableLongArrayList ? this.dialect.getSQLType((SchemaColumn)new SchemaColumn((String)"", (Type)Type.DOUBLE), null).sqlDecl : this.dialect.getSQLType((SchemaColumn)new SchemaColumn((String)"", (Type)Type.STRING).withMaxLength((int)1999), null).sqlDecl;
        String createTableQuery = this.dialect.createTemporaryTable(table, this.dialect.quoteIdentifier(axisName) + " " + sqlType);
        try (ConnectionPool.ManagedStatement stmt = this.getConnection().getStatement();
             FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);){
            logger.info((Object)("\n\n-- SQL query for creating axis table:\n\n" + createTableQuery + "\n"));
            stmt.executeCTAS(createTableQuery);
        }
        if (this.dialect instanceof BigQuerySQLDialect) {
            this.insertAxisValuesAsSingleBulkStatement(table, axisName, values);
        } else {
            this.insertAxisValues(table, axisName, values);
        }
    }

    private void insertAxisValues(SQLUtils.SQLTable table, String axisName, Object values) throws SQLException, InterruptedException {
        String insertQuery = "INSERT INTO " + this.dialect.getQuotedTableFullName(table) + " (" + this.dialect.quoteIdentifier(axisName) + ") VALUES( ? )";
        try (ConnectionPool.ManagedPreparedStatement stmt = this.getConnection().getPreparedStatement(insertQuery);
             FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);){
            logger.info((Object)("\n\n-- SQL query for populating axis table from cache:\n\n" + insertQuery + "\n"));
            if (values instanceof NullableDoubleArrayList) {
                NullableDoubleArrayList valuesCasted = (NullableDoubleArrayList)((Object)values);
                logger.info((Object)("Inserting " + valuesCasted.size() + " double values"));
                for (int i = 0; i < valuesCasted.size(); ++i) {
                    stmt.get().clearParameters();
                    double v = valuesCasted.get(i);
                    stmt.get().setDouble(1, v);
                    SqlExecutionHelper.execute(stmt);
                }
            } else if (values instanceof NullableLongArrayList) {
                NullableLongArrayList valuesCasted = (NullableLongArrayList)((Object)values);
                logger.info((Object)("Inserting " + valuesCasted.size() + " long values"));
                for (int i = 0; i < valuesCasted.size(); ++i) {
                    stmt.get().clearParameters();
                    long v = valuesCasted.get(i);
                    stmt.get().setLong(1, v);
                    SqlExecutionHelper.execute(stmt);
                }
            } else {
                List list = (List)values;
                logger.info((Object)("Inserting " + list.size() + " string values"));
                for (String s : list) {
                    stmt.get().clearParameters();
                    stmt.get().setString(1, s);
                    SqlExecutionHelper.execute(stmt);
                }
            }
        }
    }

    private void insertAxisValuesAsSingleBulkStatement(SQLUtils.SQLTable table, String axisName, Object values) throws SQLException, InterruptedException {
        String insertQuery = "INSERT INTO " + this.dialect.getQuotedTableFullName(table) + " (" + this.dialect.quoteIdentifier(axisName) + ") VALUES ";
        try (ConnectionPool.ManagedStatement stmt = this.getConnection().getStatement();
             FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);){
            StringBuilder sbValues = new StringBuilder();
            if (values instanceof NullableDoubleArrayList) {
                NullableDoubleArrayList valuesCasted = (NullableDoubleArrayList)((Object)values);
                logger.info((Object)("Inserting " + valuesCasted.size() + " double values"));
                for (int i = 0; i < valuesCasted.size(); ++i) {
                    if (i > 0) {
                        sbValues.append(',');
                    }
                    double v = valuesCasted.get(i);
                    sbValues.append('(').append(v).append(')');
                }
            } else if (values instanceof NullableLongArrayList) {
                NullableLongArrayList valuesCasted = (NullableLongArrayList)((Object)values);
                logger.info((Object)("Inserting " + valuesCasted.size() + " long values"));
                for (int i = 0; i < valuesCasted.size(); ++i) {
                    if (i > 0) {
                        sbValues.append(',');
                    }
                    long v = valuesCasted.get(i);
                    sbValues.append('(').append(v).append(')');
                }
            } else {
                List list = (List)values;
                logger.info((Object)("Inserting " + list.size() + " string values"));
                int listSize = list.size();
                for (int i = 0; i < listSize; ++i) {
                    String s = (String)list.get(i);
                    if (i > 0) {
                        sbValues.append(',');
                    }
                    sbValues.append("(").append(this.dialect.quoteString(s)).append(")");
                }
            }
            insertQuery = insertQuery + sbValues.toString();
            logger.info((Object)("\n\n-- SQL query for populating axis table from cache:\n\n" + insertQuery + "\n"));
            SqlExecutionHelper.execute(this.connection, stmt, insertQuery, true);
        }
    }

    private List<InMemoryResultSet> executeMaterialization(AxisMaterializerToSQL.MaterializedAxesContext axes, PivotTableAggregatedRequest req) throws SQLException, InterruptedException, BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        ArrayList<InMemoryResultSet> axesData = new ArrayList<InMemoryResultSet>();
        for (AxisMaterializerToSQL.MaterializedAxis axis : axes.axes) {
            AxisCache.CachedAxis cachedAxis;
            InMemoryResultSet materializedAxisData;
            block65: {
                materializedAxisData = null;
                cachedAxis = null;
                if (axis.requireMaterialization) {
                    cachedAxis = this.ctx.cache.axisCache.get(req.filters, new AxisUtils.ExtendedAxisDef(AxisUtils.copyWithGroupingDisabled(axis.axis.def), req.aggregations), axis.axis.computedWithAggregates);
                    if (cachedAxis == null) {
                        logger.info((Object)("Cache miss for axis \"" + axis.axis.def.column + "\""));
                    } else {
                        logger.info((Object)("Fetched axis \"" + axis.axis.def.column + "\" from cache"));
                    }
                    if (axis.mayRequireJoin) {
                        if (cachedAxis != null && (this.dialect instanceof SparkSQLDialect || this.dialect instanceof PrestoSQLDialect)) {
                            logger.info((Object)("Cached Axis may require join, but " + this.dialect.getId() + " cannot efficiently insert back, ignoring cached axis"));
                            cachedAxis = null;
                        }
                        if (cachedAxis == null) {
                            pooledConnection = this.getConnection();
                            stmt = pooledConnection.getStatement();
                            try {
                                ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);
                                try {
                                    logger.info((Object)"\n\n-- SQL query for creating axis table:\n\n");
                                    for (String query : axis.createTableQuery) {
                                        logger.info((Object)(query + "\n"));
                                        try {
                                            stmt.executeCTAS(query);
                                        }
                                        catch (SQLException e) {
                                            if (e.getErrorCode() == 90105) {
                                                logger.error((Object)"Unable to create temporary table", (Throwable)e);
                                                ConnectionsUtils.ensureSnowflakeDbNotNull(pooledConnection);
                                            }
                                            throw e;
                                        }
                                    }
                                }
                                finally {
                                    if (ignored != null) {
                                        ignored.close();
                                    }
                                }
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            if (this.dialect.needsTruncateBeforeDropTemporaryTable()) {
                                this.addCleanup(axis.truncateTableQuery);
                            }
                            this.addCleanup(axis.dropTableQuery);
                            stmt = pooledConnection.getStatement();
                            try {
                                ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);
                                try {
                                    logger.info((Object)("\n\n-- SQL query for reading axis table:\n\n" + axis.selectTableQuery + "\n"));
                                    SqlExecutionHelper.execute(pooledConnection, stmt, axis.selectTableQuery, true);
                                    try (ResultSet rs2 = stmt.get().getResultSet();){
                                        materializedAxisData = InMemoryResultSet.parseResultSet(rs2, new AxisDef[]{axis.axis.def}, axis.axis.mapping, this.ctx.input, this.dialect);
                                        break block65;
                                    }
                                }
                                finally {
                                    if (ignored != null) {
                                        ignored.close();
                                    }
                                }
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        if (TensorToSQL.requireJoin(axis.axis.def, cachedAxis.imrs)) {
                            this.recreateAxisTableFromCache(cachedAxis, axis.tempTableTable, axis.axis.mapping.axisRefs.get((int)0).name);
                            this.addCleanup(axis.dropTableQuery);
                        }
                        materializedAxisData = cachedAxis.imrs;
                    } else {
                        if (cachedAxis == null) {
                            pooledConnection = this.getConnection();
                            stmt = pooledConnection.getStatement();
                            try {
                                ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);
                                try {
                                    String sql = axis.axis.query.toSQL();
                                    logger.info((Object)("\n\n-- SQL query for computing axis values:\n\n" + sql + "\n"));
                                    SqlExecutionHelper.execute(pooledConnection, stmt, sql, true);
                                    try (ResultSet rs3 = stmt.get().getResultSet();){
                                        materializedAxisData = InMemoryResultSet.parseResultSet(rs3, new AxisDef[]{axis.axis.def}, axis.axis.mapping, this.ctx.input, this.dialect);
                                        break block65;
                                    }
                                }
                                finally {
                                    if (ignored != null) {
                                        ignored.close();
                                    }
                                }
                            }
                            finally {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                        }
                        materializedAxisData = cachedAxis.imrs;
                    }
                }
            }
            if (cachedAxis == null && materializedAxisData != null) {
                this.ctx.cache.axisCache.put(req.filters, new AxisUtils.ExtendedAxisDef(AxisUtils.copyWithGroupingDisabled(axis.axis.def), req.aggregations), materializedAxisData);
                logger.info((Object)("Wrote axis \"" + axis.axis.def.column + "\" in cache"));
            }
            axesData.add(materializedAxisData);
        }
        return axesData;
    }

    private BasicStatsBuilder.BasicStats waitForGlobalStatsIfNecessary(PivotTableAggregatedRequest req) throws InterruptedException, ExecutionException {
        if (req instanceof PivotTableTensorRequest) {
            PivotTableTensorRequest treq = (PivotTableTensorRequest)req;
            for (AxisDef axisDef : treq.axes) {
                if (!BasicStatsToSQL.axisRequireMinmax(axisDef)) continue;
                return this.globalStatsFuture.get();
            }
            for (RowFilter rowFilter : treq.filters) {
                if (!BasicStatsToSQL.filterRequireMinmax(rowFilter)) continue;
                return this.globalStatsFuture.get();
            }
        }
        return null;
    }

    private BasicStatsBuilder.BasicStats waitForStatsIfNecessary(PivotTableAggregatedRequest req) throws InterruptedException, ExecutionException {
        if (req instanceof PivotTableTensorRequest) {
            PivotTableTensorRequest treq = (PivotTableTensorRequest)req;
            for (AxisDef axisDef : treq.axes) {
                if (!BasicStatsToSQL.axisRequireMinmax(axisDef)) continue;
                return this.basicStatsFuture.get();
            }
        }
        return null;
    }

    private PivotTableTensorResponse buildSimpleFromResultSet(PivotTableTensorRequest sreq, InMemoryResultSet imrs) throws InterruptedException, ExecutionException, BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        BasicStatsBuilder.BasicStats stats = this.waitForStatsIfNecessary(sreq);
        SimplePivotBuilder simpleResponseBuilder = new SimplePivotBuilder(sreq, stats);
        return simpleResponseBuilder.parseResponse(imrs);
    }

    private PivotTableTensorResponse buildNonBinnedFromResultSet(InMemoryResultSet imrs) {
        NonBinnedBuilder simpleResponseBuilder = new NonBinnedBuilder();
        return simpleResponseBuilder.parseResponse(imrs);
    }

    private PivotTableTensorResponse buildNonBinned(SimpleAggregatedRequest sreq, BasicStatsBuilder.BasicStats globalStats) throws InterruptedException, ExecutionException, SQLException, BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        try {
            PivotTableTensorResponse pivotTableTensorResponse;
            block33: {
                InMemoryResultSet data;
                FutureProgress.AutocloseableFutureProgressState state;
                block29: {
                    PivotTableTensorResponse pivotTableTensorResponse2;
                    block30: {
                        state = FutureProgress.pushAutoCloseableState((String)CREATING_CHART, (double)4.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                        try {
                            this.ctx.listener.pivotProgress(SQLPivotListener.PivotStatus.RUNNING_PIVOT);
                            AxisCache.CachedAxis ca = this.ctx.cache.axisCache.get(sreq.filters, new AxisUtils.ExtendedAxisDef(null, sreq.aggregations), true);
                            if (ca == null) break block29;
                            logger.info((Object)"Fetched Non Binned Result from cache");
                            pivotTableTensorResponse2 = this.buildNonBinnedFromResultSet(ca.imrs);
                            if (state == null) break block30;
                        }
                        catch (Throwable throwable) {
                            if (state != null) {
                                try {
                                    state.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        state.close();
                    }
                    return pivotTableTensorResponse2;
                }
                AxisMaterializerToSQL materializer = new AxisMaterializerToSQL(this.ctx.input, sreq, null, globalStats, this.colMappingFuture.get());
                AxisMaterializerToSQL.MaterializedAxesContext axes = materializer.build();
                SimpleAxisToSQL builder = new SimpleAxisToSQL(this.ctx.input, sreq, null, null, this.colMappingFuture.get());
                SimpleAxisToSQL.AxisQueryContext axisCtx = builder.buildAxis(axes.axes.get(0), null, globalStats);
                try (ConnectionPool.ManagedStatement stmt = this.getConnection().getStatement();
                     FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);){
                    String sql = axisCtx.query.toSQL();
                    logger.info((Object)("\n\n-- SQL query for computing non binned table:\n\n" + sql + "\n"));
                    SqlExecutionHelper.execute(this.connection, stmt, sql, true);
                    try (ResultSet rs2 = stmt.get().getResultSet();){
                        state.increment(1.0);
                        data = InMemoryResultSet.parseResultSet(rs2, null, axisCtx.mapping, this.ctx.input, this.dialect);
                    }
                    this.ctx.cache.axisCache.put(sreq.filters, new AxisUtils.ExtendedAxisDef(axisCtx.def, sreq.aggregations), data);
                }
                pivotTableTensorResponse = new NonBinnedBuilder().parseResponse(data);
                if (state == null) break block33;
                state.close();
            }
            return pivotTableTensorResponse;
        }
        finally {
            this.ctx.listener.pivotProgress(SQLPivotListener.PivotStatus.DONE);
        }
    }

    private PivotTableTensorResponse buildSimple(PivotTableTensorRequest sreq, BasicStatsBuilder.BasicStats stats, BasicStatsBuilder.BasicStats globalStats) throws InterruptedException, ExecutionException, SQLException, BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        try {
            PivotTableTensorResponse pivotTableTensorResponse;
            block34: {
                AxisDef axisDef;
                FutureProgress.AutocloseableFutureProgressState state;
                block30: {
                    PivotTableTensorResponse pivotTableTensorResponse2;
                    block31: {
                        state = FutureProgress.pushAutoCloseableState((String)CREATING_CHART, (double)4.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                        try {
                            this.ctx.listener.pivotProgress(SQLPivotListener.PivotStatus.RUNNING_PIVOT);
                            axisDef = sreq.axes == null ? null : sreq.axes[0];
                            AxisCache.CachedAxis ca = this.ctx.cache.axisCache.get(sreq.filters, new AxisUtils.ExtendedAxisDef(axisDef, sreq.aggregations), true);
                            if (ca == null) break block30;
                            logger.info((Object)"Fetched 1D pivot from cache");
                            pivotTableTensorResponse2 = this.buildSimpleFromResultSet(sreq, ca.imrs);
                            if (state == null) break block31;
                        }
                        catch (Throwable throwable) {
                            if (state != null) {
                                try {
                                    state.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        state.close();
                    }
                    return pivotTableTensorResponse2;
                }
                AxisMaterializerToSQL materializer = new AxisMaterializerToSQL(this.ctx.input, sreq, stats, globalStats, this.colMappingFuture.get());
                AxisMaterializerToSQL.MaterializedAxesContext axes = materializer.build();
                List<InMemoryResultSet> axesData = this.executeMaterialization(axes, sreq);
                state.increment(1.0);
                this.buildIndexesOnTempTable(axes, axesData);
                state.increment(1.0);
                InMemoryResultSet data = axesData.get(0);
                SimpleAxisToSQL builder = new SimpleAxisToSQL(this.ctx.input, sreq, axisDef, stats, this.colMappingFuture.get());
                SimpleAxisToSQL.AxisQueryContext axisCtx = builder.buildAxis(axes.axes.get(0), data, globalStats);
                if (SimpleAxisToSQL.requireJoin(axes.axes.get(0), data) || data == null) {
                    try (ConnectionPool.ManagedStatement stmt = this.getConnection().getStatement();
                         FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);){
                        String sql = axisCtx.query.toSQL();
                        logger.info((Object)("\n\n-- SQL query for computing 1D pivot table:\n\n" + sql + "\n"));
                        SqlExecutionHelper.execute(this.getConnection(), stmt, sql, true);
                        try (ResultSet rs2 = stmt.get().getResultSet();){
                            state.increment(1.0);
                            data = InMemoryResultSet.parseResultSet(rs2, sreq.axes, axisCtx.mapping, this.ctx.input, this.dialect);
                        }
                        this.ctx.cache.axisCache.put(sreq.filters, new AxisUtils.ExtendedAxisDef(axisCtx.def, sreq.aggregations), data);
                    }
                }
                pivotTableTensorResponse = new SimplePivotBuilder(sreq, stats).parseResponse(data);
                if (state == null) break block34;
                state.close();
            }
            return pivotTableTensorResponse;
        }
        finally {
            this.ctx.listener.pivotProgress(SQLPivotListener.PivotStatus.DONE);
        }
    }

    private PivotTableTensorResponse buildMatrix(PivotTableTensorRequest mreq, BasicStatsBuilder.BasicStats stats, BasicStatsBuilder.BasicStats globalStats) throws InterruptedException, ExecutionException, SQLException, BinsAndTensorsSafetyChecks.MemoryLimitExceededException {
        try {
            PivotTableTensorResponse pivotTableTensorResponse;
            block35: {
                TensorToSQL.MatrixQueryContext queryCtx;
                List<InMemoryResultSet> axesData;
                try (FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState((String)"Creating axes...", (double)3.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    this.ctx.listener.pivotProgress(SQLPivotListener.PivotStatus.RUNNING_AXES);
                    AxisMaterializerToSQL materializer = new AxisMaterializerToSQL(this.ctx.input, mreq, stats, globalStats, this.colMappingFuture.get());
                    AxisMaterializerToSQL.MaterializedAxesContext axes = materializer.build();
                    axesData = this.executeMaterialization(axes, mreq);
                    state.increment(1.0);
                    this.buildIndexesOnTempTable(axes, axesData);
                    state.increment(1.0);
                    TensorToSQL tensorToSQL = new TensorToSQL(this.ctx.input, mreq, stats, this.colMappingFuture.get());
                    queryCtx = tensorToSQL.build(axes, axesData);
                }
                state = FutureProgress.pushAutoCloseableState((String)CREATING_CHART, (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                try {
                    InMemoryResultSet imrs;
                    this.ctx.listener.pivotProgress(SQLPivotListener.PivotStatus.RUNNING_PIVOT);
                    try (ConnectionPool.ManagedStatement stmt = this.getConnection().getStatement();
                         FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);){
                        String sql = queryCtx.query.toSQL(this.dialect);
                        logger.info((Object)("\n\n-- SQL query for computing 2D pivot table:\n\n" + sql + "\n"));
                        SqlExecutionHelper.execute(this.getConnection(), stmt, sql, true);
                        try (ResultSet rs2 = stmt.get().getResultSet();){
                            state.increment(1.0);
                            imrs = InMemoryResultSet.parseResultSet(rs2, mreq.axes, queryCtx.mapping, this.ctx.input, this.dialect);
                        }
                    }
                    TensorPivotBuilder builder = new TensorPivotBuilder(mreq, stats);
                    pivotTableTensorResponse = builder.parseResponse(imrs, axesData);
                    if (state == null) break block35;
                }
                catch (Throwable throwable) {
                    if (state != null) {
                        try {
                            state.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                state.close();
            }
            return pivotTableTensorResponse;
        }
        finally {
            this.ctx.listener.pivotProgress(SQLPivotListener.PivotStatus.DONE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PivotTableResponse call() throws Exception {
        try {
            try {
                PivotTableResponse response = this.buildResponse(this.ctx.req);
                for (Map.Entry entry : this.ctx.req.sideRequests.entrySet()) {
                    logger.info((Object)("Building side request: " + String.valueOf(entry.getKey())));
                    ArrayList<PivotTableResponse> responses = new ArrayList<PivotTableResponse>();
                    for (PivotTableRequest req : (List)entry.getValue()) {
                        responses.add(this.buildResponse((SimpleAggregatedRequest)req));
                    }
                    response.sideResponses.put((SideResponseKey)((Object)entry.getKey()), responses);
                }
                PivotTableResponse pivotTableResponse = response;
                this.executeCleanupQueries();
                return pivotTableResponse;
            }
            catch (Throwable throwable) {
                try {
                    this.executeCleanupQueries();
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warn((Object)"Failure in SQL chart executor", (Throwable)e);
                    throw e;
                }
            }
        }
        finally {
            this.releaseConnection();
        }
    }

    private PivotTableResponse buildResponse(PivotTableAggregatedRequest request) throws Exception {
        PivotTableTensorResponse response;
        if (request instanceof PivotTableTensorRequest) {
            PivotTableTensorRequest tensorRequest = (PivotTableTensorRequest)request;
            BasicStatsBuilder.BasicStats stats = this.waitForStatsIfNecessary(request);
            BasicStatsBuilder.BasicStats globalStats = this.waitForGlobalStatsIfNecessary(request);
            this.replaceAutomaticAggregationLevels(tensorRequest, stats);
            response = !tensorRequest.computeSubTotals && tensorRequest.axes.length == 1 ? this.buildSimple(tensorRequest, stats, globalStats) : this.buildMatrix(tensorRequest, stats, globalStats);
            PivotPostprocessor.computeFromSQL(request, response);
        } else if (request instanceof SimpleAggregatedRequest) {
            BasicStatsBuilder.BasicStats globalStats = this.waitForGlobalStatsIfNecessary(request);
            response = this.buildNonBinned((SimpleAggregatedRequest)request, globalStats);
        } else {
            throw new RuntimeException("Unreachable");
        }
        return response;
    }

    private void addCleanup(String sql) {
        this.dropTables.add(sql);
    }

    private ConnectionPool.PooledConnection getConnection() throws SQLException, InterruptedException {
        if (this.connection == null) {
            this.connection = this.ctx.sqlPool.get();
        }
        return this.connection;
    }

    private void executeCleanupQueries() {
        while (!this.dropTables.isEmpty()) {
            String sql = this.dropTables.remove(0);
            try {
                ConnectionPool.ManagedStatement stmt = this.getConnection().getStatement();
                try {
                    logger.info((Object)("\n\n-- Cleanup up query:\n\n" + sql + "\n"));
                    SqlExecutionHelper.executeNoInterruptCheck(this.connection, stmt, sql, true);
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Cleanup error", (Throwable)e);
            }
        }
    }

    private void releaseConnection() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    private void replaceAutomaticAggregationLevels(PivotTableTensorRequest tensorRequest, BasicStatsBuilder.BasicStats stats) throws IOException {
        new SqlEngineAutomaticRequestHandler(tensorRequest, stats, this.dialect).replaceAutomaticAggregationLevels();
    }
}

