/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.dao.IStandardDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.insights.runnable.DSSRunnableInsightParams;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.projects.importexport.ProjectImporterBase;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public abstract class RunAsUserAdjuster<T extends TaggableObjectsService.TaggableObject> {
    private final AuthCtx authCtx;
    protected final ProjectImporterBase.StashedLocalConfig stashedLocalConfig;
    protected final String targetProjectKey;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.bundles.import");

    protected RunAsUserAdjuster(AuthCtx authCtx, ProjectImporterBase.StashedLocalConfig stashedLocalConfig, String targetProjectKey) {
        this.authCtx = authCtx;
        this.stashedLocalConfig = stashedLocalConfig;
        this.targetProjectKey = targetProjectKey;
    }

    protected abstract IStandardDAO<T> getDao();

    protected abstract T getStashedTaggableObject(String var1);

    protected abstract String getRunAsUser(T var1);

    protected abstract void setRunAsUser(T var1, String var2);

    protected abstract void save(T var1) throws IOException;

    protected boolean isExecutableTaggableObject(T taggableObject) {
        return true;
    }

    private boolean shouldUpdatePreviousTaggableObject(T previousTaggableObject) {
        return previousTaggableObject != null && this.isExecutableTaggableObject(previousTaggableObject);
    }

    void adjust() throws IOException {
        ArrayList<TaggableObjectsService.TaggableObject> toSave = new ArrayList<TaggableObjectsService.TaggableObject>();
        for (TaggableObjectsService.TaggableObject taggableObject : this.getDao().list(this.targetProjectKey)) {
            if (!this.isExecutableTaggableObject(taggableObject)) continue;
            T prev = this.getStashedTaggableObject(taggableObject.getId());
            String newRunAsUserToSet = null;
            if (this.shouldUpdatePreviousTaggableObject(prev)) {
                String importedRunAs;
                String prevRunAs = this.getRunAsUser(prev);
                if (!StringUtils.equals((String)prevRunAs, (String)(importedRunAs = this.getRunAsUser(taggableObject)))) {
                    newRunAsUserToSet = prevRunAs;
                    logger.infoV("Restoring run-as user for %s %s: %s (override %s)", new Object[]{taggableObject.getTaggableType(), taggableObject.getId(), newRunAsUserToSet, importedRunAs});
                }
            } else if (this.authCtx.getDSSUserForImpersonation() != null) {
                newRunAsUserToSet = this.authCtx.getDSSUserForImpersonation();
                logger.infoV("Import of new %s, initializing its runAsUser to %s", new Object[]{taggableObject.getTaggableType(), newRunAsUserToSet});
            } else if (!this.authCtx.isAdmin()) {
                newRunAsUserToSet = this.authCtx.getIdentifier();
                logger.infoV("Import of new %s, replacing runAsUser to %s as a fallback", new Object[]{taggableObject.getTaggableType(), newRunAsUserToSet});
            }
            if (!StringUtils.isNotBlank((String)newRunAsUserToSet)) continue;
            this.setRunAsUser(taggableObject, newRunAsUserToSet);
            toSave.add(taggableObject);
        }
        for (TaggableObjectsService.TaggableObject taggableObject : toSave) {
            this.save(taggableObject);
        }
    }

    static class InsightRunAsAdjuster
    extends RunAsUserAdjuster<Insight> {
        private final InsightsDAO dao;

        protected InsightRunAsAdjuster(InsightsDAO dao, AuthCtx authCtx, ProjectImporterBase.StashedLocalConfig stashedLocalConfig, String targetProjectKey) {
            super(authCtx, stashedLocalConfig, targetProjectKey);
            this.dao = dao;
        }

        protected InsightsDAO getDao() {
            return this.dao;
        }

        @Override
        protected Insight getStashedTaggableObject(String id) {
            return this.stashedLocalConfig.getInsight(id);
        }

        @Override
        protected boolean isExecutableTaggableObject(Insight taggableObject) {
            return taggableObject.params instanceof DSSRunnableInsightParams;
        }

        @Override
        protected String getRunAsUser(Insight taggableObject) {
            return ((DSSRunnableInsightParams)taggableObject.params).runAsUser;
        }

        @Override
        protected void setRunAsUser(Insight taggableObject, String newRunAsUser) {
            ((DSSRunnableInsightParams)taggableObject.params).runAsUser = newRunAsUser;
        }

        @Override
        protected void save(Insight taggableObject) throws IOException {
            this.getDao().save(taggableObject);
        }
    }

    static class WebappRunAsUserAdjuster
    extends RunAsUserAdjuster<WebApp> {
        private final WebAppsDAO dao;

        WebappRunAsUserAdjuster(WebAppsDAO dao, AuthCtx authCtx, ProjectImporterBase.StashedLocalConfig stashedLocalConfig, String targetProjectKey) {
            super(authCtx, stashedLocalConfig, targetProjectKey);
            this.dao = dao;
        }

        protected WebAppsDAO getDao() {
            return this.dao;
        }

        @Override
        protected WebApp getStashedTaggableObject(String id) {
            return this.stashedLocalConfig.getWebApp(id);
        }

        @Override
        protected String getRunAsUser(WebApp taggableObject) {
            return taggableObject.params.runAs;
        }

        @Override
        protected void setRunAsUser(WebApp taggableObject, String newRunAsUser) {
            taggableObject.params.runAs = newRunAsUser;
        }

        @Override
        protected void save(WebApp taggableObject) throws IOException {
            this.getDao().save(taggableObject);
        }
    }

    static class ScenarioRunAsAdjuster
    extends RunAsUserAdjuster<Scenario> {
        private final ScenariosDAO dao;

        protected ScenarioRunAsAdjuster(ScenariosDAO dao, AuthCtx authCtx, ProjectImporterBase.StashedLocalConfig stashedLocalConfig, String targetProjectKey) {
            super(authCtx, stashedLocalConfig, targetProjectKey);
            this.dao = dao;
        }

        protected ScenariosDAO getDao() {
            return this.dao;
        }

        @Override
        protected Scenario getStashedTaggableObject(String id) {
            return this.stashedLocalConfig.getScenario(id);
        }

        @Override
        protected String getRunAsUser(Scenario taggableObject) {
            return taggableObject.runAsUser;
        }

        @Override
        protected void setRunAsUser(Scenario taggableObject, String newRunAsUser) {
            taggableObject.runAsUser = newRunAsUser;
        }

        @Override
        protected void save(Scenario taggableObject) throws IOException {
            this.getDao().save(this.targetProjectKey, taggableObject.getId(), taggableObject);
        }
    }
}

