/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sparksql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeCreator;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeMeta;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.DatasetLocUtils;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkSQLRecipeCreator
extends SingleOutputDatasetRecipeCreator {
    @Autowired
    private DatasetsDAO datasetsDAO;

    public SparkSQLRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected RecipeParams makeInitialParams(SerializedRecipe sr, JsonObject creationData) {
        SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams ret = new SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams();
        RecipeCreationUtils.setupSparkSQLRecipeEngineParams(this.authCtx, sr.projectKey, ret);
        return ret;
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, StreamingEndpoint outputStreamingEndpoint) throws Exception {
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data, Dataset outputDataset) throws Exception {
        String prefill;
        String string = prefill = data.has("script") ? data.get("script").getAsString() : null;
        if (StringUtils.isNotBlank((String)prefill)) {
            return prefill;
        }
        String firstInputRef = recipe.getInputsForRole((String)"main").get((int)0).ref;
        String firstOutputRef = recipe.getOutputsForRole((String)"main").get((int)0).ref;
        SerializedDataset inputSD = (SerializedDataset)this.datasetsDAO.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(recipe.projectKey, firstInputRef));
        SerializedDataset outputSD = (SerializedDataset)this.datasetsDAO.getMandatory(DatasetLocUtils.DatasetLoc.resolveSmart(recipe.projectKey, firstOutputRef));
        Dataset inputDS = Dataset.fromSerialized(inputSD);
        Dataset outputDS = Dataset.fromSerialized(outputSD);
        PartitioningScheme partitioning = outputDS.getPartitioningSchema();
        SparkSQLDialect dialect = new SparkSQLDialect();
        SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams newlyCreatedRecipeParams = recipe.getParamsAs(SparkSQLQueryRecipeMeta.SparkSQLQueryRecipeParams.class);
        boolean useGlobalMetastore = newlyCreatedRecipeParams.useGlobalMetastore;
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTable(inputDS, (SQLDialect)dialect, useGlobalMetastore, true);
        SelectQueryBuilder query = new SelectQueryBuilder();
        query.from(table, null);
        SQLQueryRecipeCreator.handlePartitioningInQuery(inputSD, outputDS, partitioning, query, false);
        return query.toSQL(dialect);
    }
}

