/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.llm_evaluation;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMEvaluationRecipeCreator;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMEvaluationRecipeParams;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMEvaluationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMEvaluationRecipeRunner;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMEvaluationRecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class LLMEvaluationRecipeMeta
extends RecipeMeta
implements MetaWithSelectableCodeEnv {
    public static final LLMEvaluationRecipeMeta META = new LLMEvaluationRecipeMeta();

    @Override
    public String getType() {
        return "nlp_llm_evaluation";
    }

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return LLMEvaluationRecipeParams.class;
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new LLMEvaluationRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) throws Exception {
        return new LLMEvaluationRecipeRunner(activity);
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new LLMEvaluationRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) throws Exception {
        return RecipeMeta.defaultStatusComputer("DSS", "DSS", "MEMORY", "In-memory", "DSS");
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        RecipeDesc desc = new RecipeDesc("LLM Evaluation", null);
        desc.inputRoles.add(RecipeDesc.IORoleDef.newUnaryRequiredDataset("main", "Evaluation Dataset"));
        desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryDataset("main", "Output Dataset"));
        desc.outputRoles.add(RecipeDesc.IORoleDef.newUnaryDataset("metrics", "Metrics"));
        RecipeDesc.IORoleDef mes = RecipeDesc.IORoleDef.newUnaryModelEvaluationStore("evaluationStore", "Evaluation Store");
        desc.outputRoles.add(mes);
        return desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withNlp();
    }

    protected LLMEvaluationRecipePayloadParams loadPayload(String payload) {
        return (LLMEvaluationRecipePayloadParams)JSON.parse((String)payload, LLMEvaluationRecipePayloadParams.class);
    }

    protected void handleLLMId(Set<String> connectionNames, String llmId) {
        if (StringUtils.isNotEmpty((String)llmId) && !"None".equals(llmId)) {
            LLMStructuredRef ref = LLMStructuredRef.decodeId(llmId);
            if (ref.connection == null || ref.connection.isEmpty()) {
                return;
            }
            connectionNames.add(ref.connection);
        }
    }

    protected String remapConnectionOfLLMId(String llmId, Map<String, String> replacements) {
        if (StringUtils.isEmpty((String)llmId) || "None".equals(llmId)) {
            return llmId;
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(llmId);
        if (ref.connection == null) {
            return llmId;
        }
        String newValue = replacements.get(ref.connection);
        if (newValue != null) {
            ref.setConnection(newValue);
        }
        return ref.encodeToId();
    }

    @Override
    public Set<String> underlyingConnectionNames(SerializedRecipe serializedRecipe, String payload) {
        HashSet<String> ret = new HashSet<String>();
        LLMEvaluationRecipePayloadParams params = this.loadPayload(payload);
        this.handleLLMId(ret, params.completionLLMId);
        this.handleLLMId(ret, params.embeddingLLMId);
        return ret;
    }

    @Override
    public RecipePayloadParams remapConnections(SerializedRecipe serializedRecipe, String payload, Map<String, String> replacements) {
        LLMEvaluationRecipePayloadParams params = this.loadPayload(payload);
        params.completionLLMId = this.remapConnectionOfLLMId(params.completionLLMId, replacements);
        params.embeddingLLMId = this.remapConnectionOfLLMId(params.embeddingLLMId, replacements);
        return params;
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.PYTHON;
    }
}

