/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.utils.GraphUtils;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.shaker.sparkimpl.ShakerSparkRecipeDef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ShakerSparkRecipeDefBuilder {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO dao;
    @Autowired
    private VariablesService variablesSevice;
    @Autowired
    private JobAuthCtxService authCtxService;
    private final JobActivity activity;
    private final ResourcesGatherer gatherer;
    private static final Logger logger;

    public ShakerSparkRecipeDefBuilder(JobActivity activity, ResourcesGatherer gatherer) {
        this.activity = activity;
        this.gatherer = gatherer;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public ShakerSparkRecipeDef build() throws Exception {
        RunnableSubgraph subgraph = this.activity.getSubgraph();
        FlowRecipe recipe = ((RecipeRunnableSubgraph)subgraph).getRecipe();
        ShakerSparkRecipeDef recipeDef = new ShakerSparkRecipeDef();
        recipeDef.recipeProjectKey = recipe.getProjectKey();
        String shakerScriptData = this.dao.getPayloadOrNull(recipe.getProjectKey(), recipe.getName());
        if (shakerScriptData == null) {
            throw new Error("shaker script data not found for " + recipe.getName());
        }
        SerializedShakerScript shakerScript = (SerializedShakerScript)JSON.parse((String)shakerScriptData, SerializedShakerScript.class);
        SerializedShakerScript expandedScript = shakerScript.expandedDeepCopy(this.variablesSevice.getContext(recipe.getProjectKey()));
        recipeDef.expandedSteps = expandedScript.steps;
        ShakerRecipeParams recipeParams = RecipeRegistry.getParamsAs(this.activity, ShakerRecipeParams.class);
        recipeDef.sparkParams = (ShakerRecipeParams.SparkParams)JSON.deepCopy((Object)recipeParams.engineParams.spark);
        SparkSettings sparkSettings = new ClusterSelector().selectForProject(this.authCtxService.getAuthCtx(), recipe.getProjectKey()).getSparkSettings();
        recipeDef.sparkParams.useNativeProcessors &= sparkSettings.useNativeProcessors;
        List<SerializedRecipe.RecipeInput> mainInputs = recipe.getModel().getInputsForRole("main");
        if (mainInputs.size() != 1) {
            throw ErrorContext.iaef((String)"Preparation recipe expects one main input, got %s", (Object)mainInputs.size(), (Object[])new Object[0]);
        }
        AnyLoc mainLoc = DatasetLocUtils.DatasetLoc.resolveSmart(recipe.getProjectKey(), mainInputs.get((int)0).ref);
        FlowDataset mainFlowDataset = subgraph.getSourceDataset(mainLoc.getFullName());
        recipeDef.inputDataset = SparkRecipeUtils.getInputFlowDatasetRef(mainFlowDataset, recipeDef.sparkParams.readParams, recipeParams.engineParams.spark.useGlobalMetastore, recipe, this.activity, this.datasetsDAO);
        recipeDef.outputDatasetFullName = subgraph.getTargets().get(0).getFullId();
        if (subgraph.getSingleTargetDataset().getMandatory(this.datasetsDAO).getPartitioningSchema().isPartitioned()) {
            recipeDef.outputDatasetPartition = subgraph.getTargetPartition(subgraph.getTargets().get(0)).id();
        }
        recipeDef.useGlobalMetastore = recipeParams.engineParams.spark.useGlobalMetastore;
        if (recipeParams.engineParams.spark.useGlobalMetastore) {
            recipeDef.metastoreDatabase = SparkRecipeUtils.getHiveMetastoreDatabase(this.activity, this.datasetsDAO);
            if (recipeDef.metastoreDatabase == null) {
                logger.warn((Object)"Could not find a metastore database to use from recipe inputs/outputs, will use default");
                recipeDef.metastoreDatabase = "";
            }
        }
        FlowDataset outputFDS = GraphUtils.getSingleTarget(recipe);
        Dataset outputDataset = outputFDS.getMandatory(this.datasetsDAO);
        recipeDef.outputDatasetSchema = outputDataset.getSchema();
        this.gatherer.gatherResources(expandedScript.steps);
        this.gatherer.dumpAndGatherYarnPythonBins(expandedScript.steps, ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getRecipe().getProjectKey(), this.authCtxService.getAuthCtx());
        this.gatherer.dumpAndGatherAdditionalDatasets(this.authCtxService.getAuthCtx(), ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getRecipe().getProjectKey(), expandedScript.steps);
        this.gatherer.dumpAndGatherPythonProcessors();
        return recipeDef;
    }

    static {
        ScriptStep.loadClass();
        logger = Logger.getLogger((String)"dku.spark.shaker");
    }
}

