/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.recipes.shaker.ShakerRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.ScriptUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ShakerStandaloneResourceCollector {
    private final AuthCtx authCtx;
    private final String projectKey;
    private final String recipeName;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;
    private static Logger logger = Logger.getLogger((String)"dip.shaker.resources.collection");

    public ShakerStandaloneResourceCollector(AuthCtx authCtx, String projectKey, String recipeName) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.recipeName = recipeName;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public AutoDelete collectResources() throws Exception {
        AutoDelete tmpDir = FlowJobUtils.getTmpFolder("shaker", "resources");
        try {
            ShakerResourcesCollection collection = new ShakerResourcesCollection();
            ResourcesGatherer gatherer = new ResourcesGatherer();
            SpringUtils.getInstance().autowire((Object)gatherer);
            SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatory(this.projectKey, this.recipeName);
            if (!ShakerRecipeMeta.META.getType().equals(recipe.getType())) {
                throw new Error("Recipe " + this.recipeName + " is not a Prepare recipe");
            }
            String shakerScriptData = this.recipesDAO.getPayloadOrNull(this.projectKey, this.recipeName);
            if (shakerScriptData == null) {
                throw new Error("shaker script data not found for " + this.recipeName);
            }
            SerializedShakerScript shakerScript = (SerializedShakerScript)JSON.parse((String)shakerScriptData, SerializedShakerScript.class);
            SerializedShakerScript expandedScript = shakerScript.expandedDeepCopy(this.variablesService.getContext(this.projectKey));
            collection.steps.addAll(ScriptUtils.getProcessorsFromSteps(expandedScript.steps));
            AnyLoc outputLoc = DatasetLocUtils.DatasetLoc.resolveSmart(this.projectKey, recipe.getSingleOutput((String)"main").ref);
            SerializedDataset outputDataset = (SerializedDataset)this.datasetsDAO.getMandatory(outputLoc);
            collection.outputSchema = outputDataset.getSchema();
            gatherer.gatherResources(expandedScript.steps);
            gatherer.dumpAndGatherYarnPythonBins(expandedScript.steps, this.projectKey, this.authCtx);
            gatherer.dumpAndGatherAdditionalDatasets(this.authCtx, this.projectKey, expandedScript.steps);
            gatherer.dumpAndGatherPythonProcessors();
            gatherer.computeMapping();
            collection.resourceMapping = gatherer.getResourceMapping();
            JSON.prettyToFile((Object)collection, (File)new File((File)tmpDir, "shaker-resources-collection.json"));
            for (File f : gatherer.getResourceFiles()) {
                FileUtils.copyFile((File)f, (File)new File((File)tmpDir, f.getName()));
            }
            return tmpDir;
        }
        catch (Exception e) {
            tmpDir.close();
            throw e;
        }
    }

    public static class ShakerResourcesCollection {
        public Schema outputSchema;
        public List<ScriptStep> steps = Lists.newArrayList();
        public Map<String, String> resourceMapping;
    }
}

