/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelection;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.sanitycheck.SanityCheckDetectorBase;
import com.dataiku.dip.sanitycheck.SanityCheckInfoMessages;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectClusterConfigurationDetector
implements SanityCheckDetectorBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ClustersDAO clustersDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.projectclusterdetector");

    public List<InfoMessage.MessageCode> getCodes() {
        return Arrays.asList(Codes.values());
    }

    public SanityCheckInfoMessages runAnalysis(Set<String> exclusionList) {
        List<SerializedProject> serializedProjects;
        GeneralSettingsDAO.GeneralSettings gs;
        List<Cluster> clusters;
        SanityCheckInfoMessages messages = new SanityCheckInfoMessages();
        if (exclusionList.containsAll(Arrays.stream(Codes.values()).map(InfoMessage.MessageCode::getCode).collect(Collectors.toList()))) {
            return messages;
        }
        try (Transaction t = this.transactionService.beginRead();){
            clusters = this.clustersDAO.listUnsafe();
        }
        catch (IOException e) {
            logger.error((Object)"Unable to read cluster settings", (Throwable)e);
            messages.addMessage(this.createFatalMessage(e));
            return messages;
        }
        try (Transaction t = this.transactionService.beginRead();){
            gs = this.generalSettingsDAO.getUnsafe();
            serializedProjects = this.projectsService.listAllUnsafe();
        }
        catch (IOException e) {
            logger.error((Object)"Unable to read projects settings", (Throwable)e);
            messages.addMessage(this.createFatalMessage(e));
            return messages;
        }
        boolean hasAnyCluster = clusters.stream().anyMatch(cluster -> cluster.architecture == Cluster.ClusterArchitecture.HADOOP);
        boolean hasAnyK8sCluster = clusters.stream().anyMatch(cluster -> cluster.architecture == Cluster.ClusterArchitecture.KUBERNETES);
        boolean hasDefaultClusterId = StringUtils.isNotBlank((String)gs.defaultClusterId);
        boolean hasDefaultK8sClusterId = StringUtils.isNotBlank((String)gs.defaultK8sClusterId);
        if (hasAnyCluster && !hasDefaultClusterId && !exclusionList.contains(Codes.WARN_CLUSTERS_NONE_SELECTED_GLOBAL.getCode())) {
            messages.withWarning((InfoMessage.MessageCode)Codes.WARN_CLUSTERS_NONE_SELECTED_GLOBAL, "Hadoop clusters are available but there is no global default cluster selected. Each project needs to select one explicitly.");
        }
        if (hasAnyK8sCluster && !hasDefaultK8sClusterId && !exclusionList.contains(Codes.WARN_CLUSTERS_NONE_SELECTED_GLOBAL.getCode())) {
            messages.withWarning((InfoMessage.MessageCode)Codes.WARN_CLUSTERS_NONE_SELECTED_GLOBAL, "Kubernetes clusters are available but there is no global default cluster selected. Each project needs to select one explicitly.");
        }
        if (hasDefaultClusterId && !exclusionList.contains(Codes.ERR_CLUSTERS_INVALID_SELECTED.getCode()) && clusters.stream().noneMatch(cluster -> cluster.name.equals(gs.defaultClusterId))) {
            messages.withErrorV((InfoMessage.MessageCode)Codes.ERR_CLUSTERS_INVALID_SELECTED, "Global default Hadoop cluster '%s' does not exist.", new Object[]{gs.defaultClusterId});
        }
        if (hasDefaultK8sClusterId && !exclusionList.contains(Codes.ERR_CLUSTERS_INVALID_SELECTED.getCode()) && clusters.stream().noneMatch(cluster -> cluster.name.equals(gs.defaultK8sClusterId))) {
            messages.withErrorV((InfoMessage.MessageCode)Codes.ERR_CLUSTERS_INVALID_SELECTED, "Global default kubernetes cluster '%s' does not exist.", new Object[]{gs.defaultK8sClusterId});
        }
        serializedProjects.forEach(sp -> {
            if (sp.settings.cluster.clusterMode != ClusterSelection.ClusterMode.INHERIT) {
                if (StringUtils.isBlank((String)sp.settings.cluster.clusterId) && StringUtils.isBlank((String)sp.settings.cluster.defaultClusterId)) {
                    if (hasAnyCluster && !exclusionList.contains(Codes.WARN_CLUSTERS_NONE_SELECTED_PROJECT.getCode())) {
                        messages.withWarningV((InfoMessage.MessageCode)Codes.WARN_CLUSTERS_NONE_SELECTED_PROJECT, "Hadoop clusters are available but none is selected in project '%s'. Cluster execution will likely fail.", new Object[]{sp.name});
                    }
                } else if (!exclusionList.contains(Codes.ERR_CLUSTERS_INVALID_SELECTED.getCode())) {
                    try {
                        String clusterId = new ClusterSelector().getClusterForProject(sp.projectKey, Cluster.ClusterArchitecture.HADOOP);
                        if (StringUtils.isNotBlank((String)clusterId) && clusters.stream().noneMatch(cluster -> cluster.name.equals(clusterId))) {
                            messages.withErrorV((InfoMessage.MessageCode)Codes.ERR_CLUSTERS_INVALID_SELECTED, "Hadoop cluster '%s' set in project '%s' does not exist.", new Object[]{clusterId, sp.name});
                        }
                    }
                    catch (IOException e) {
                        logger.errorV((Throwable)e, "Unable to read project '%s' settings", new Object[]{sp.name});
                        messages.addMessage(this.createFatalMessage(e));
                    }
                }
            }
            if (sp.settings.k8sCluster.clusterMode != ClusterSelection.ClusterMode.INHERIT) {
                if (StringUtils.isBlank((String)sp.settings.k8sCluster.clusterId) && StringUtils.isBlank((String)sp.settings.k8sCluster.defaultClusterId)) {
                    if (hasAnyK8sCluster && !exclusionList.contains(Codes.WARN_CLUSTERS_NONE_SELECTED_PROJECT.getCode())) {
                        messages.withWarningV((InfoMessage.MessageCode)Codes.WARN_CLUSTERS_NONE_SELECTED_PROJECT, "Kubernetes clusters are available but none is selected in project '%s'. Cluster execution will likely fail.", new Object[]{sp.name});
                    }
                } else if (!exclusionList.contains(Codes.ERR_CLUSTERS_INVALID_SELECTED.getCode())) {
                    try {
                        String k8sClusterId = new ClusterSelector().getClusterForProject(sp.projectKey, Cluster.ClusterArchitecture.KUBERNETES);
                        if (StringUtils.isNotBlank((String)k8sClusterId) && clusters.stream().noneMatch(cluster -> cluster.name.equals(k8sClusterId))) {
                            messages.withErrorV((InfoMessage.MessageCode)Codes.ERR_CLUSTERS_INVALID_SELECTED, "Kubernetes cluster '%s' set in project '%s' does not exist.", new Object[]{k8sClusterId, sp.name});
                        }
                    }
                    catch (IOException e) {
                        logger.errorV((Throwable)e, "Unable to read project '%s' settings", new Object[]{sp.name});
                        messages.addMessage(this.createFatalMessage(e));
                    }
                }
            }
        });
        return messages;
    }

    public static enum Codes implements InfoMessage.MessageCode
    {
        WARN_CLUSTERS_NONE_SELECTED_PROJECT("Clusters - No cluster selected in project", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        WARN_CLUSTERS_NONE_SELECTED_GLOBAL("Clusters - No default cluster selected", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING),
        ERR_CLUSTERS_INVALID_SELECTED("Clusters - Selected cluster does not exist", InfoMessage.FixabilityCategory.ADMIN_TROUBLESHOOTING);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private Codes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

