/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IPBlacklistVerifier {
    private static Map<String, BlacklistedIP> blacklistCache = Maps.newHashMap();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.ipblacklist");

    public static void validateUriNotBlacklisted(String uriStr, boolean useGlobalProxy) throws CodedIOException {
        ProxySettings proxySettings = new ProxySettings();
        if (useGlobalProxy) {
            proxySettings = ApplicationConfigurator.getProxySettings();
        }
        IPBlacklistVerifier.validateUriNotBlacklisted(uriStr, proxySettings);
    }

    public static void validateUriNotBlacklisted(String uriStr, ProxySettings proxySettings) throws CodedIOException {
        if (proxySettings.hasProxy()) {
            logger.info((Object)"URI validation against IP blacklist is disabled (a proxy is used");
            return;
        }
        try {
            URI uri = new URI(uriStr);
            String host = uri.getHost();
            if (StringUtils.isNotBlank((String)host)) {
                ArrayList addresses = Lists.newArrayList((Object[])InetAddress.getAllByName(host));
                String blacklist = ApplicationConfigurator.getParams().getParam("dku.http.IP.blacklist", "");
                ArrayList blacklistedIps = Lists.newArrayList();
                for (String rawIp : blacklist.split(",")) {
                    BlacklistedIP blacklisted;
                    if (!StringUtils.isNotBlank((String)rawIp) || (blacklisted = IPBlacklistVerifier.getBlacklisted(rawIp.trim())) == null) continue;
                    blacklistedIps.add(blacklisted);
                }
                for (InetAddress address : addresses) {
                    boolean blacklisted = false;
                    for (BlacklistedIP blacklistedIp : blacklistedIps) {
                        if (!address.getClass().equals(blacklistedIp.ip.getClass())) continue;
                        if (blacklistedIp.maskLength < 0) {
                            blacklisted |= address.equals(blacklistedIp.ip);
                            continue;
                        }
                        byte[] addressBytes = IPBlacklistVerifier.maskAddress(address, blacklistedIp.maskLength);
                        blacklisted |= Arrays.equals(addressBytes, blacklistedIp.bytes);
                    }
                    if (!blacklisted) continue;
                    throw new CodedIOException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_ILLEGAL_URL, "Host of '" + uriStr + "' resolves to " + Joiner.on((String)", ").join((Iterable)addresses) + " and is blacklisted");
                }
            }
        }
        catch (URISyntaxException | UnknownHostException e) {
            throw new CodedIOException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_ILLEGAL_URL, "URI is invalid", (Throwable)e);
        }
    }

    private static synchronized BlacklistedIP getBlacklisted(String rawIp) {
        if (blacklistCache.containsKey(rawIp)) {
            return blacklistCache.get(rawIp);
        }
        try {
            String cleanIp;
            int maskLength;
            int slashPos = rawIp.lastIndexOf(47);
            if (slashPos >= 0) {
                maskLength = Integer.parseInt(rawIp.substring(slashPos + 1));
                cleanIp = rawIp.substring(0, slashPos);
            } else {
                maskLength = -1;
                cleanIp = rawIp;
            }
            BlacklistedIP blacklisted = new BlacklistedIP(InetAddress.getByName(cleanIp), maskLength);
            blacklistCache.put(rawIp, blacklisted);
            return blacklisted;
        }
        catch (Exception e) {
            logger.warn((Object)("Invalid IP in blacklist : " + rawIp), (Throwable)e);
            blacklistCache.put(rawIp, null);
            return null;
        }
    }

    private static byte[] maskAddress(InetAddress ip, int maskLength) {
        byte[] addr = ip.getAddress();
        if (maskLength < 0) {
            return addr;
        }
        int remainderBits = maskLength % 8;
        int nBytes = (maskLength + 7) / 8;
        byte[] masked = Arrays.copyOf(addr, nBytes);
        if (remainderBits != 0) {
            int finalMask = (1 << remainderBits) - 1;
            byte finalByte = (byte)finalMask;
            int n = masked.length - 1;
            masked[n] = (byte)(masked[n] & ~finalByte);
        }
        return masked;
    }

    private static class BlacklistedIP {
        private final InetAddress ip;
        private final int maskLength;
        private final byte[] bytes;

        BlacklistedIP(InetAddress ip, int maskLength) {
            this.ip = ip;
            this.maskLength = maskLength;
            this.bytes = IPBlacklistVerifier.maskAddress(ip, maskLength);
        }
    }
}

