/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.security.auth.APIAuthUtils;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PublicAPIKeyAuthService {
    @Autowired
    private PublicAPIKeysService publicApiKeyService;

    public PublicAPIKey getKey(HttpServletRequest req) throws DKUSecurityException, IOException {
        String apiKey = APIAuthUtils.getKeyStr((HttpServletRequest)req);
        assert (apiKey != null);
        PublicAPIKey key = this.publicApiKeyService.getKey(apiKey);
        if (key == null) {
            throw new NotAuthenticatedException("Unknown API Key", "unknown-api-key");
        }
        return key;
    }
}

