/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.EngineNotAvailableException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.pivot.backend.EngineSelector;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.model.ProjectScopePublicAPIKey;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendsManager;
import com.dataiku.dip.webapps.plugins.CustomWebAppsService;
import com.dataiku.dip.webapps.plugins.LoadedCustomWebApp;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class ShakerScriptsCRUDController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private DatasetSaveService saveService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private CustomWebAppsService customWebAppsService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private WebAppBackendsManager webAppBackendsManager;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    private static final Logger logger;

    @AuditedCall(value={"msgType", "dataset-explore-read-meta", "projectKey", "${projectKey}", "datasetRef", "${datasetSmartName}"})
    @RequestMapping(value={"/api/explores/get-script"})
    public void getScriptOnly(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetSmartName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.checkNotEmpty(new String[]{projectKey});
            this.checkNotEmpty(new String[]{datasetSmartName});
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ShakerScriptsCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.exploresService.get((String)projectKey, (String)datasetSmartName).script);
        }
    }

    @AuditedCall(value={"msgType", "dataset-explore-save-meta", "projectKey", "${projectKey}", "datasetRef", "${datasetSmartName}"})
    @RequestMapping(value={"/api/explores/save-script"}, method={RequestMethod.POST})
    public void saveScriptOnly(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetSmartName, @RequestParam String script) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.checkNotEmpty(new String[]{projectKey});
            this.checkNotEmpty(new String[]{datasetSmartName});
            this.checkNotEmpty(new String[]{script});
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            DatasetExploreSettings old = this.exploresService.get(projectKey, datasetSmartName);
            old.script = (SerializedShakerScript)JSON.parse((String)script, SerializedShakerScript.class);
            this.exploresService.save(projectKey, datasetSmartName, old);
            t.commit("Saved explore settings of " + datasetSmartName, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        }
    }

    @AuditedCall(value={"msgType", "dataset-explore-read-meta", "projectKey", "${projectKey}", "streamingEndpointId", "${streamingEndpointId}"})
    @RequestMapping(value={"/api/explores/get-capture-script"})
    public void getCaptureScriptOnly(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String streamingEndpointId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.checkNotEmpty(new String[]{projectKey});
            this.checkNotEmpty(new String[]{streamingEndpointId});
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ShakerScriptsCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.exploresService.getCapture((String)projectKey, (String)streamingEndpointId).script);
        }
    }

    @AuditedCall(value={"msgType", "dataset-explore-save-meta", "projectKey", "${projectKey}", "streamingEndpointId", "${streamingEndpointId}"})
    @RequestMapping(value={"/api/explores/save-capture-script"}, method={RequestMethod.POST})
    public void saveCaptureScriptOnly(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String streamingEndpointId, @RequestParam String script) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.checkNotEmpty(new String[]{projectKey});
            this.checkNotEmpty(new String[]{streamingEndpointId});
            this.checkNotEmpty(new String[]{script});
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            DatasetExploreSettings old = this.exploresService.get(projectKey, streamingEndpointId);
            old.script = (SerializedShakerScript)JSON.parse((String)script, SerializedShakerScript.class);
            this.exploresService.saveCapture(projectKey, streamingEndpointId, old);
            t.commit("Saved explore capture settings of " + streamingEndpointId, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        }
    }

    @AuditedCall(value={"msgType", "dataset-explore-read-meta", "projectKey", "${projectKey}", "datasetRef", "${datasetSmartName}"})
    @RequestMapping(value={"/api/explores/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetSmartName) throws Exception {
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.DATASET, datasetSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkNotEmpty(new String[]{projectKey});
            this.checkNotEmpty(new String[]{datasetSmartName});
            this.projectsService.failIfNoDashboardReadPermission(req, ref, projectKey);
            ShakerScriptsCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.exploresService.get(projectKey, datasetSmartName));
        }
    }

    @AuditedCall(value={"msgType", "dataset-explore-save-meta", "projectKey", "${projectKey}", "datasetRef", "${datasetSmartName}"})
    @RequestMapping(value={"/api/explores/save"}, method={RequestMethod.POST})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetSmartName, @RequestParam String data) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.checkNotEmpty(new String[]{projectKey});
            this.checkNotEmpty(new String[]{datasetSmartName});
            this.checkNotEmpty(new String[]{data});
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.exploresService.save(projectKey, datasetSmartName, (DatasetExploreSettings)JSON.parse((String)data, DatasetExploreSettings.class));
            t.commit("Saved explore settings of " + datasetSmartName, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        }
    }

    @AuditedCall(value={"msgType", "dataset-explore-get-options", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/explores/list-plugin-chart-descs"}, method={RequestMethod.GET})
    public void listPluginChartDescs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.checkNotEmpty(new String[]{projectKey});
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        ArrayList ret = Lists.newArrayList();
        for (LoadedCustomWebApp loaded : this.customWebAppsService.list()) {
            if (loaded.desc.chart == null) continue;
            ret.add(loaded);
        }
        ShakerScriptsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "dataset-explore-chart", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/explores/get-or-create-plugin-chart"}, method={RequestMethod.POST})
    public void getOrCreatePluginChart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetSmartName, @RequestParam ChartDef chartDef, @RequestParam(required=false) String webAppId) throws Exception {
        WebAppsService.WebAppCreateResponse ret;
        AuthCtx authCtx;
        WebApp wa = null;
        JsonObject webAppConfig = JSON.toJsonObject((Object)chartDef);
        webAppConfig.addProperty("$isChartDef", Boolean.valueOf(true));
        boolean keepFutureIdInResponse = false;
        try (Transaction t = this.transactionService.beginRead();){
            this.checkNotEmpty(new String[]{projectKey});
            authCtx = this.authService.getMandatoryUser(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIdInResponse = true;
            } else {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            WebApp webApp = wa = StringUtils.isNotBlank((String)webAppId) ? this.webAppsService.getOrNull(projectKey, webAppId) : null;
            if (StringUtils.isNotBlank((String)webAppId)) {
                wa = this.webAppsService.getOrNull(projectKey, webAppId);
            }
            if (wa == null) {
                wa = this.webAppsService.getReusableOrNull(authCtx, projectKey, chartDef.webAppType, webAppConfig);
            }
        }
        WebAppBackendInstance.BackendState backendState = wa != null ? this.webAppBackendsManager.getState(wa, keepFutureIdInResponse) : null;
        boolean backendDied = wa != null && wa.params.isBackendEnabled() && (backendState == null || backendState.futureInfo != null && !backendState.futureInfo.alive);
        logger.info((Object)("Get or create plugin chart chartDef.webAppType=" + chartDef.webAppType + " webAppId=" + webAppId + " webApp=" + (wa != null ? wa.type : "") + " config=" + JSON.pretty((Object)chartDef.webAppConfig) + " backendDied=" + backendDied));
        if (wa != null && StringUtils.equals((String)wa.type, (String)chartDef.webAppType) && !backendDied) {
            logger.info((Object)"Webapp is still running, use it");
            ret = new WebAppsService.WebAppCreateResponse();
            ret.resp = new WebAppsService.WebAppSaveResponse();
            ret.resp.webAppId = wa.id;
            ret.resp.webAppId = webAppId;
            if (backendState != null) {
                ret.resp.backendState = new FutureResponse();
                ret.resp.backendState.hasResult = true;
                ret.resp.backendState.result = backendState;
            }
            ret.webapp = wa;
            wa.config = webAppConfig;
        } else {
            try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
                webAppId = SecretKeyGenerator.generateSmall();
                WebAppMeta meta = WebAppRegistry.getMeta(chartDef.webAppType);
                ret = this.webAppsService.createTimeoutableVirtual(t.getUser(), webAppId, projectKey, "Plugin chart", meta.getType(), null, null, webAppConfig, null);
                if (StringUtils.isNotBlank((String)ret.webapp.apiKey)) {
                    PublicAPIKey keyObj = this.publicAPIKeysService.getKey(this.passwordEncryptionService.decryptIfEncrypted(ret.webapp.apiKey));
                    if (!(keyObj instanceof ProjectScopePublicAPIKey)) {
                        throw new IllegalArgumentException("Bad API key");
                    }
                    ProjectScopePublicAPIKey pkeyObj = (ProjectScopePublicAPIKey)keyObj;
                    pkeyObj.projectPrivileges.readProjectContent = true;
                    this.publicAPIKeysService.updateProjectAPIKey(pkeyObj);
                }
                WebAppHandler wah = WebAppHandler.buildHandler(ret.webapp);
                wah.writeCodeFiles();
                t.commit("Create webapp chart " + webAppId);
            }
            WebApp created = (WebApp)JSON.deepCopy((Object)ret.webapp);
            WebAppHandler.buildHandler(created).readCodeFiles();
            JsonObject userVariables = this.variablesService.getContext(projectKey).getAllVariablesTyped();
            ret.resp.backendState = this.webAppBackendsManager.onSave_NT(authCtx, created, userVariables, false, keepFutureIdInResponse);
        }
        ShakerScriptsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "dataset-explore-save-meta", "projectKey", "${projectKey}", "datasetRef", "${datasetName}"})
    @RequestMapping(value={"/api/explores/set-explore-on-single-partition"})
    public void setExploreOnSinglePartition(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String partitionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.checkNotEmpty(new String[]{projectKey});
            this.checkNotEmpty(new String[]{datasetName});
            this.checkNotEmpty(new String[]{partitionId});
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.exploresService.setExploreOnSinglePartition(projectKey, datasetName, partitionId);
            t.commit("Set explore sample of " + datasetName + "  to partition " + partitionId);
        }
    }

    @AuditedCall(value={"msgType", "dataset-save-schema", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/explores/set-column-meaning"})
    public void setColumnMeaning(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String columnName, @RequestParam String meaning) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
            SchemaColumn col = sd.getSchema().getColumn(columnName);
            if (col == null) {
                throw ErrorContext.iaef((String)"Dataset %s.%s: column %s not in schema", (Object)projectKey, (Object[])new Object[]{datasetName, columnName});
            }
            col.setMeaning(com.dataiku.dip.utils.StringUtils.nullIfBlank((String)meaning));
            sd.getSchema().userModified = true;
            this.saveService.save(projectKey, datasetName, sd, user);
            t.commitV("Dataset %s.%s: set meaning of '%s' to %s", new Object[]{projectKey, datasetName, columnName, meaning});
        }
    }

    @RequestMapping(value={"/api/explores/set-columns-meanings"})
    public void setColumnsMeanings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data) throws Exception {
        for (Map.Entry entry : JSON.parseToMap((String)data).entrySet()) {
            String[] parts = ((String)entry.getKey()).split("\\.", 3);
            this.setColumnMeaning(req, resp, parts[0], parts[1], parts[2], (String)entry.getValue());
            this.auditTrailService.generic("dataset-set-schema").with("projectKey", parts[0]).with("datasetName", parts[1]).emit();
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/explores/get-set-column-storage-type-impact"})
    public void getSetColumnStorageTypeImpact(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String columnName, @RequestParam String storageType) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
            Dataset dataset = Dataset.fromSerialized(sd);
            SetStorageTypeImpact ret = new SetStorageTypeImpact();
            ret.warnings.add("Changing the type on the column will require updating recipes and datasets downstream.");
            SchemaColumn col = sd.getSchema().getColumn(columnName);
            if (col != null) {
                ret.oldType = col.getType();
            }
            ret.newType = Type.forName((String)storageType);
            if (col != null) {
                if (ret.oldType == Type.ARRAY && col.arrayContent != null) {
                    ret.warnings.add("Selecting this type will discard existing complex object fields.");
                }
                if (ret.oldType == Type.OBJECT && col.objectFields != null) {
                    ret.warnings.add("Selecting this type will discard existing complex object fields.");
                }
                if (ret.oldType == Type.MAP && col.mapKeys != null && col.mapValues != null) {
                    ret.warnings.add("Selecting this type will discard existing complex object fields.");
                }
            }
            boolean partitioned = dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned();
            ret.extraActions.add(SetStorageTypeAction.REFRESH_SAMPLE);
            if (DatasetInspector.canHDFS(dataset)) {
                ret.extraActions.add(SetStorageTypeAction.SYNC_METASTORE);
            }
            if (dataset.isManaged()) {
                if (DatasetInspector.shouldDropOnStorageTypeChange(dataset)) {
                    ret.extraActions.add(SetStorageTypeAction.DROP_RECREATE);
                } else if (partitioned) {
                    ret.extraActions.add(SetStorageTypeAction.DROP_PARTITIONED_DATA);
                }
            }
            ShakerScriptsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "dataset-save-schema", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/explores/set-column-storage-type"})
    public void setColumnStorageType(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String columnName, @RequestParam String storageType, @RequestParam(value="actionIds") String actionIdsData) throws Exception {
        DatasetHandler handler;
        Dataset dataset;
        AuthCtx user;
        boolean syncHive = false;
        SetStorageTypePostActions ret = new SetStorageTypePostActions();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
            SchemaColumn col = sd.getSchema().getColumn(columnName);
            if (col == null) {
                throw ErrorContext.iaef((String)"Dataset %s.%s: column %s not in schema", (Object)projectKey, (Object[])new Object[]{datasetName, columnName});
            }
            col.setType(Type.forName((String)storageType));
            sd.getSchema().userModified = true;
            this.saveService.save(projectKey, datasetName, sd, user);
            t.commitV("Dataset %s.%s: set storage type of '%s' to %s", new Object[]{projectKey, datasetName, columnName, storageType});
            dataset = Dataset.fromSerialized(sd);
        }
        List actionIds = (List)JSON.parse((String)actionIdsData, (TypeToken)new TypeToken<List<String>>(){});
        if (actionIds.contains(SetStorageTypeAction.DROP_RECREATE.id)) {
            logger.info((Object)("Dropping data and structure for " + dataset.getFullName()));
            try {
                handler = DatasetHandlerFactory.build(user, dataset);
                try {
                    handler.clearAllDataAndStructure();
                    handler.createManaged();
                }
                finally {
                    if (handler != null) {
                        handler.close();
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to drop data and structure", (Throwable)e);
            }
            ret.reload = true;
        }
        if (actionIds.contains(SetStorageTypeAction.DROP_PARTITIONED_DATA.id)) {
            logger.info((Object)("Dropping data and structure for " + dataset.getFullName()));
            try {
                handler = DatasetHandlerFactory.build(user, dataset);
                try {
                    handler.clearAllData();
                }
                finally {
                    if (handler != null) {
                        handler.close();
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to drop data and structure", (Throwable)e);
            }
            ret.reload = true;
        }
        if (actionIds.contains(SetStorageTypeAction.SYNC_METASTORE.id)) {
            syncHive = true;
        }
        if (actionIds.contains(SetStorageTypeAction.REFRESH_SAMPLE.id)) {
            ret.refreshSample = true;
        }
        if (syncHive) {
            try (HiveMetastoreSynchronizer hms = HiveMetastoreSynchronizerFactory.getSynchronizer(user);){
                hms.synchronizeOneDataset(dataset, false, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.OTHER, null, true);
            }
        }
        ShakerScriptsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "dataset-save-schema", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/explores/update-column"})
    public void setColumnData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String column) throws Exception {
        SchemaColumn sc = (SchemaColumn)JSON.parse((String)column, SchemaColumn.class);
        Preconditions.checkArgument((sc != null ? 1 : 0) != 0, (Object)"No column provided");
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
            sd.getSchema().updateOrAddColumn(sc);
            sd.getSchema().userModified = true;
            this.saveService.save(projectKey, datasetName, sd, user);
            t.commitV("Dataset %s.%s: updated details of column '%s'", new Object[]{projectKey, datasetName, sc.getName()});
        }
    }

    @AuditedCall(value={"msgType", "dataset-get-meta", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/explores/get-chart-engines"})
    public void getChartEngines(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam String script, @RequestParam String chartDef) throws Exception {
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)script, SerializedShakerScript.class);
        ChartDef chart = (ChartDef)JSON.parse((String)chartDef, ChartDef.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
            Dataset dataset = Dataset.fromSerialized(sd);
            AbstractSQLConnection connection = DatasetInspector.isSQLAbleAndSQLTable(authCtx, dataset) ? DatasetInspector.getDSSConnectionForSQLAbleDatasetOrHive(authCtx, dataset) : null;
            ArrayList availabilities = Lists.newArrayList();
            availabilities.add(EngineAvailability.fromEngine(SerializedShakerScript.ChartsEngine.LINO, authCtx, dataset, connection, sss, chart));
            availabilities.add(EngineAvailability.fromEngine(SerializedShakerScript.ChartsEngine.SQL, authCtx, dataset, connection, sss, chart));
            if (SparkConfigurator.interactiveSparkSQLAvailable(authCtx, projectKey)) {
                availabilities.add(EngineAvailability.fromEngine(SerializedShakerScript.ChartsEngine.SPARKSQL, authCtx, dataset, connection, sss, chart));
            }
            ShakerScriptsCRUDController.writeJSON((HttpServletResponse)resp, (Object)availabilities);
        }
    }

    @AuditedCall(value={"msgType", "dataset-search-get-saved-queries", "projectKey", "${projectKey}", "datasetSmartName", "${datasetSmartName}"})
    @RequestMapping(value={"/api/explores/get-es-search-saved-queries"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DatasetExploreSettings.ElasticSearchSavedQuery> getInteractiveSearchSavedQueries(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetSmartName) throws Exception {
        List<DatasetExploreSettings.ElasticSearchSavedQuery> queries;
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx user = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(projectKey, datasetSmartName);
            SmartObjectRef objectRef = SmartObjectRef.fromResolved(ITaggingService.TaggableType.DATASET, projectKey, loc.getId(), loc.getProjectKey());
            this.projectsService.failIfNoDashboardReadPermission(user, objectRef, projectKey);
            queries = this.exploresService.listInteractiveSearchQueriesForDatasetUnsafe(projectKey, datasetSmartName);
        }
        return queries;
    }

    @AuditedCall(value={"msgType", "dataset-search-save-query", "projectKey", "${projectKey}", "datasetSmartName", "${datasetSmartName}", "savedQuery", "${savedQuery}", "oldSavedQueryName", "${oldSavedQueryName}"})
    @RequestMapping(value={"/api/explores/save-es-search-query"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void saveInteractiveSearchSavedQuery(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetSmartName, @RequestParam DatasetExploreSettings.ElasticSearchSavedQuery savedQuery, @RequestParam(required=false) String oldSavedQueryName) throws Exception {
        this.checkNotEmpty(new String[]{projectKey});
        this.checkNotEmpty(new String[]{datasetSmartName});
        this.checkNotEmpty(new String[]{savedQuery.name});
        assert (!savedQuery.query.isEmpty());
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            String prefix;
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (StringUtils.isNotBlank((String)oldSavedQueryName)) {
                this.exploresService.updateInteractiveSearchQuery(projectKey, datasetSmartName, savedQuery, oldSavedQueryName);
                prefix = "Updated";
            } else {
                this.exploresService.saveInteractiveSearchQuery(projectKey, datasetSmartName, savedQuery);
                prefix = "Saved";
            }
            t.commit(prefix + " interactive search query", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        }
    }

    @AuditedCall(value={"msgType", "dataset-search-delete-saved-query", "projectKey", "${projectKey}", "datasetSmartName", "${datasetSmartName}", "savedQuery", "${savedQuery}"})
    @RequestMapping(value={"/api/explores/delete-es-search-saved-query"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteInteractiveSearchSavedQuery(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetSmartName, @RequestParam String savedQueryName) throws Exception {
        this.checkNotEmpty(new String[]{projectKey});
        this.checkNotEmpty(new String[]{datasetSmartName});
        this.checkNotEmpty(new String[]{savedQueryName});
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.exploresService.deleteInteractiveSearchQuery(projectKey, datasetSmartName, savedQueryName);
            t.commit("Deleted interactive search query", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        }
    }

    static {
        ScriptStep.loadClass();
        logger = Logger.getLogger((String)"dku.datasets.explore.controller");
    }

    public static class SetStorageTypeImpact {
        public Type oldType;
        public Type newType;
        public List<String> warnings = Lists.newArrayList();
        public List<SetStorageTypeAction> extraActions = Lists.newArrayList();
    }

    public static class SetStorageTypeAction {
        public static final SetStorageTypeAction DROP_PARTITIONED_DATA = new SetStorageTypeAction("DROP_PARTITIONED_DATA", "Drop all data", "It is strongly recommended to clear the dataset to avoid schema inconsistencies. This will drop all partitions.");
        public static final SetStorageTypeAction DROP_RECREATE = new SetStorageTypeAction("DROP_RECREATE", "Drop and recreate", "It is strongly recommended to drop and recreate the dataset to avoid schema inconsistencies.");
        public static final SetStorageTypeAction SYNC_METASTORE = new SetStorageTypeAction("SYNC_METASTORE", "Synchronize metastore", "This is a HDFS dataset. It is strongly recommended to re-synchronize its hive table.");
        public static final SetStorageTypeAction REFRESH_SAMPLE = new SetStorageTypeAction("REFRESH_SAMPLE", "Refresh sample", "The cached sample will be out-of-sync with the schema");
        public final String id;
        public final String label;
        public final String comment;

        SetStorageTypeAction(String id, String label, String comment) {
            this.id = id;
            this.label = label;
            this.comment = comment;
        }
    }

    public static class SetStorageTypePostActions {
        public boolean refreshSample;
        public boolean reload;
    }

    public static class EngineAvailability {
        private static Map<SerializedShakerScript.ChartsEngine, String> labels = Maps.newHashMap();
        public SerializedShakerScript.ChartsEngine engine;
        public String label;
        public boolean available;
        public String reason;

        static EngineAvailability fromEngine(SerializedShakerScript.ChartsEngine engine, AuthCtx authCtx, Dataset dataset, DSSConnection connection, SerializedShakerScript sss, ChartDef chartDef) throws Exception {
            EngineAvailability availability = new EngineAvailability();
            availability.engine = engine;
            availability.label = labels.get((Object)engine);
            try {
                EngineSelector.checkEngineOK(authCtx, dataset, connection, sss.steps, chartDef, engine);
                availability.available = true;
            }
            catch (EngineNotAvailableException e) {
                availability.available = false;
                availability.reason = e.getMessage();
            }
            return availability;
        }

        static {
            labels.put(SerializedShakerScript.ChartsEngine.LINO, "DSS");
            labels.put(SerializedShakerScript.ChartsEngine.SQL, "In-database");
            labels.put(SerializedShakerScript.ChartsEngine.SPARKSQL, "SparkSQL");
        }
    }
}

