/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SessionsDAO;
import com.dataiku.dip.discussions.DiscussionsCacheService;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.notifications.FrontendMessengerNotificationsRouter;
import com.dataiku.dip.notifications.FrontendSystemNotificationsRouter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.WorkspacePermissionsService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.EventRegistry;
import com.dataiku.dip.server.notifications.Notification;
import com.dataiku.dip.server.notifications.backend.DiscussionsUnreadFullIdsChanged;
import com.dataiku.dip.server.notifications.backend.LoginEvent;
import com.dataiku.dip.server.notifications.backend.LogoutEvent;
import com.dataiku.dip.server.notifications.frontend.FrontendEvent;
import com.dataiku.dip.server.notifications.frontend.UIConnectionStateChangedEvent;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TrackingService;
import com.dataiku.dip.server.services.TrackingSessionUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.GpuMonitoringNotificationRouter;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesDAO;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServlet;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServletFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.Callback;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.Session;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.UpgradeRequest;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.OnWebSocketOpen;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.api.annotations.WebSocket;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.common.WebSocketSession;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class WebSocketController
extends JettyWebSocketServlet {
    private static final long ONE_WEEK_MS = 604800000L;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private AchievementsService achievementService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private TrackingService trackingService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DiscussionsCacheService discussionsCacheService;
    @Autowired
    private WorkspacePermissionsService workspacePermissionsService;
    @Autowired
    private SessionsDAO sessionsDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private WorkspacesDAO workspacesDAO;
    private final Set<Socket> sockets = new HashSet<Socket>();
    private final ThreadPoolExecutor sendingExecutorService;
    private static WebSocketController instance;
    protected boolean loginNotificationsEnabled;
    protected boolean jobNotificationsEnabled;
    protected boolean scenarioNotificationsEnabled;
    private static final Logger logger;

    public static WebSocketController getInstance() {
        return instance;
    }

    public WebSocketController() {
        assert (instance == null);
        instance = this;
        this.sendingExecutorService = (ThreadPoolExecutor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("websocket-sender-%d").build());
        DSSMetrics.registry().register("dku.notifications.websocket.send.activeThreads", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return WebSocketController.this.sendingExecutorService.getActiveCount();
            }
        });
        DSSMetrics.registry().register("dku.notifications.websocket.send.pooledThreads", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return WebSocketController.this.sendingExecutorService.getPoolSize();
            }
        });
        DSSMetrics.registry().register("dku.notifications.websocket.send.completedTasks", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return WebSocketController.this.sendingExecutorService.getCompletedTaskCount();
            }
        });
        DSSMetrics.registry().register("dku.notifications.websocket.send.largestPoolSize", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return WebSocketController.this.sendingExecutorService.getLargestPoolSize();
            }
        });
        DSSMetrics.registry().register("dku.notifications.websocket.send.queueSize", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return WebSocketController.this.sendingExecutorService.getQueue().size();
            }
        });
        DSSMetrics.registry().register("dku.notifications.websocket.activeSockets", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return WebSocketController.this.sockets.size();
            }
        });
        DSSMetrics.registry().register("dku.collaboration.connectedUsers", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return WebSocketController.this.getCurrentlyLoggedInUsers(true).size();
            }
        });
        this.loginNotificationsEnabled = DKUApp.getParams().getBoolParam("dku.notifications.messenger.login.enabled", true);
        this.jobNotificationsEnabled = DKUApp.getParams().getBoolParam("dku.notifications.messenger.jobs.enabled", true);
        this.scenarioNotificationsEnabled = DKUApp.getParams().getBoolParam("dku.notifications.messenger.scenarios.enabled", true);
    }

    public void init() throws ServletException {
        super.init();
        SpringUtils.getInstance().autowire((Object)this);
        ((FrontendMessengerNotificationsRouter)SpringUtils.getBean(FrontendMessengerNotificationsRouter.class)).init();
        ((FrontendSystemNotificationsRouter)SpringUtils.getBean(FrontendSystemNotificationsRouter.class)).init();
        ((GpuMonitoringNotificationRouter)SpringUtils.getBean(GpuMonitoringNotificationRouter.class)).init();
    }

    protected void configure(JettyWebSocketServletFactory factory) {
        factory.setIdleTimeout(Duration.ofMillis(604800000L));
        factory.addMapping("/websocket", (servletUpgradeRequest, servletUpgradeResponse) -> {
            List subProtocols = servletUpgradeRequest.getSubProtocols();
            if (subProtocols != null && !subProtocols.isEmpty()) {
                String dummyProtocol = (String)subProtocols.get(0);
                servletUpgradeResponse.setAcceptedSubProtocol(dummyProtocol);
            }
            return new Socket();
        });
    }

    public synchronized int getNbActiveSockets() {
        return this.sockets.size();
    }

    public synchronized Collection<AuthCtx> getCurrentlyLoggedInUsers(boolean deduplicate) {
        HashSet<String> logins = new HashSet<String>();
        ArrayList<AuthCtx> users = new ArrayList<AuthCtx>();
        for (Socket socket : this.sockets) {
            AuthCtx user = socket.getUser();
            String login = user.getAssociatedDSSUserMandNoExc();
            if (deduplicate && logins.contains(login)) continue;
            users.add(user);
            logins.add(login);
        }
        return users;
    }

    public synchronized boolean isConnected(AuthCtx liu) {
        for (Socket socket : this.sockets) {
            if (!socket.getUser().equals(liu)) continue;
            return true;
        }
        return false;
    }

    private boolean isConnected(String accessToken) {
        assert (Thread.holdsLock((Object)this));
        for (Socket socket : this.sockets) {
            String socketAccessToken;
            if (socket.getUser() == null || (socketAccessToken = socket.getUser().getAccessToken()) == null || !socketAccessToken.equals(accessToken)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCallback(Socket socket) {
        boolean isAllOnBoard;
        boolean isAlreadyConnected = false;
        WebSocketController webSocketController = this;
        synchronized (webSocketController) {
            isAlreadyConnected = this.isConnected(socket.getUser().getAccessToken());
            this.sockets.add(socket);
            isAllOnBoard = this.sockets.size() >= 3;
        }
        if (socket.getUser() != null) {
            logger.info((Object)("User " + socket.getUser().getAssociatedDSSUserMandNoExc() + " is now connected"));
            UsersService.UIUser userDescription = null;
            try (Transaction t = this.transactionService.beginRead();){
                userDescription = this.usersService.getUserOrNull_NoLeak(socket.getUser().getAssociatedDSSUserMandNoExc());
            }
            catch (IOException e) {
                userDescription = new UsersService.UIUser();
                userDescription.login = socket.getUser().getAssociatedDSSUserMandNoExc();
            }
            if (!isAlreadyConnected) {
                LoginEvent evt = LoginEvent.withUsername(userDescription.login, userDescription.displayName);
                this.pubSub.publish(evt);
            }
            try {
                Set<String> unreadFullIds = this.discussionsCacheService.getUnreadDiscussionsFullIds(userDescription.login, true);
                this.pubSub.publish(new DiscussionsUnreadFullIdsChanged(userDescription.login, unreadFullIds));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to send initial unread discussions", (Throwable)e);
            }
        }
        if (isAllOnBoard) {
            this.achievementService.win(socket.getUser(), AchievementsService.AchievementId.ALL_ON_BOARD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCallback(Socket socket) {
        if (socket.sessionId != null && socket.user != null) {
            this.pubSub.publish(new UIConnectionStateChangedEvent(socket.user.getAssociatedDSSUserMandNoExc(), socket.sessionId, false));
        }
        boolean isStillConnected = true;
        WebSocketController webSocketController = this;
        synchronized (webSocketController) {
            this.sockets.remove(socket);
            if (socket.user == null) {
                return;
            }
            isStillConnected = this.isConnected(socket.getUser().getAccessToken());
        }
        if (!isStillConnected) {
            UsersService.UIUser userDescription = null;
            try (Transaction t = this.transactionService.beginRead();){
                userDescription = this.usersService.getUserOrNull_NoLeak(socket.getUser().getAssociatedDSSUserMandNoExc());
            }
            catch (IOException e) {
                userDescription = new UsersService.UIUser();
                userDescription.login = socket.getUser().getAssociatedDSSUserMandNoExc();
            }
            LogoutEvent evt = LogoutEvent.withUsername(userDescription.login, userDescription.displayName);
            this.pubSub.publish(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastToAll(DSSEvent evt, Predicate<AuthCtx> predicate) {
        ArrayList toSend = null;
        WebSocketController webSocketController = this;
        synchronized (webSocketController) {
            toSend = Lists.newArrayList(this.sockets);
        }
        try (Transaction t = this.transactionService.beginRead();){
            ListIterator it = toSend.listIterator();
            while (it.hasNext()) {
                try {
                    Socket socket = (Socket)it.next();
                    AuthCtx authCtx = socket.getUser();
                    if (predicate.test(authCtx)) continue;
                    it.remove();
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get user authorizations before sending frontend notification", (Throwable)e);
                    it.remove();
                }
            }
        }
        String msg = JSON.json((Object)Notification.of(evt));
        this.send(evt.getName(), msg, toSend);
    }

    private SerializedProject getSerializedProject(String projectKey) throws UnauthorizedException {
        try {
            return this.projectsDAO.getOrNullUnsafe(projectKey);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read project permissions", (Throwable)e);
            throw new UnauthorizedException("Failed to read project permissions", "check-failed", (Throwable)e);
        }
    }

    private Workspace getWorkspace(String workspaceKey) throws UnauthorizedException {
        try {
            return this.workspacesDAO.getOrNullUnsafe(workspaceKey);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read workspace permissions", (Throwable)e);
            throw new UnauthorizedException("Failed to read workspace permissions", "check-failed", (Throwable)e);
        }
    }

    public void broadcastToProjectUsers(DSSEvent evt, String requiredProjectAccess) {
        this.broadcastToAll(evt, authCtx -> {
            try {
                SerializedProject sp = this.getSerializedProject(requiredProjectAccess);
                if (sp == null) {
                    logger.info((Object)("Project " + requiredProjectAccess + " deleted before notification could be sent"));
                    return false;
                }
                return this.permissionsService.hasProjectPrivilege((AuthCtx)authCtx, sp, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get user authorizations before sending frontend notification", (Throwable)e);
                return false;
            }
        });
    }

    public void broadcastToWorkspaceUsers(DSSEvent evt, String workspaceKey) {
        this.broadcastToAll(evt, authCtx -> {
            try {
                Workspace wk = this.getWorkspace(workspaceKey);
                if (wk == null) {
                    logger.info((Object)("Workspace " + workspaceKey + " deleted before notification could be sent"));
                    return false;
                }
                return this.workspacePermissionsService.hasWorkspacePrivileges((AuthCtx)authCtx, wk, Privileges.WorkspaceLevelPrivilegeType.READ);
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get user workspace authorizations before sending frontend notification", (Throwable)e);
                return false;
            }
        });
    }

    public void broadcastToProjectOrWorkspaceUsers(DSSEvent evt, String projectKey, String workspaceKey) {
        if (StringUtils.isBlank((String)workspaceKey)) {
            this.broadcastToProjectUsers(evt, projectKey);
        } else {
            this.broadcastToWorkspaceUsers(evt, workspaceKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToSession(DSSEvent evt, String sessionId) {
        ArrayList<Socket> toSend = new ArrayList<Socket>();
        WebSocketController webSocketController = this;
        synchronized (webSocketController) {
            for (Socket socket : this.sockets) {
                if (!Objects.equals(socket.sessionId, sessionId)) continue;
                toSend.add(socket);
            }
        }
        String msg = JSON.json((Object)Notification.of(evt));
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        if (generalSettings.security.sessionsMaxTotalTimeMinutes > 0 || generalSettings.security.sessionsMaxIdleTimeMinutes > 0) {
            try {
                this.sessionsDAO.getUserLoginWithSession(evt.getName());
            }
            catch (IOException e) {
                logger.error((Object)"Could not retrieve session information", (Throwable)e);
            }
        }
        this.send(evt.getName(), msg, toSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToUser(DSSEvent evt, String user) {
        ArrayList<Socket> toSend = new ArrayList<Socket>();
        WebSocketController webSocketController = this;
        synchronized (webSocketController) {
            logger.info((Object)("Broadcast to user " + user + " have a total of " + this.sockets.size() + " sockets"));
            for (Socket socket : this.sockets) {
                if (!socket.user.getAssociatedDSSUserMandNoExc().equals(user)) continue;
                toSend.add(socket);
            }
        }
        String msg = JSON.json((Object)Notification.of(evt));
        this.send(evt.getName(), msg, toSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToUsers(DSSEvent evt, Collection<String> users) {
        ArrayList<Socket> toSend = new ArrayList<Socket>();
        WebSocketController webSocketController = this;
        synchronized (webSocketController) {
            logger.info((Object)("Send event " + evt.getName() + " to " + users.size()));
            for (Socket socket : this.sockets) {
                if (!users.contains(socket.user.getAssociatedDSSUserMandNoExc())) continue;
                toSend.add(socket);
            }
            logger.info((Object)("Selected " + toSend.size() + " sockets"));
        }
        String msg = JSON.json((Object)Notification.of(evt));
        this.send(evt.getName(), msg, toSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToAllButUsers(DSSEvent evt, Set<String> excludedUsers) {
        List<Socket> toSend;
        WebSocketController webSocketController = this;
        synchronized (webSocketController) {
            toSend = this.sockets.stream().filter(socket -> !excludedUsers.contains(socket.user.getAssociatedDSSUserMandNoExc())).collect(Collectors.toList());
        }
        this.send(evt.getName(), JSON.json((Object)Notification.of(evt)), toSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToAllOnProject(DSSEvent evt, String projectKey) {
        ArrayList<Socket> toSend = new ArrayList<Socket>();
        try (Transaction t = this.transactionService.beginRead();){
            WebSocketController webSocketController = this;
            synchronized (webSocketController) {
                for (Socket socket : this.sockets) {
                    TrackingService.TrackingSession session = this.trackingService.getSession(socket.user.getAssociatedDSSUserMandNoExc(), socket.sessionId);
                    if (!TrackingSessionUtils.isOnProject(session, projectKey)) continue;
                    toSend.add(socket);
                }
            }
        }
        String msg = JSON.json((Object)Notification.of(evt));
        this.send(evt.getName(), msg, toSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToUsersOnProject(DSSEvent evt, String projectKey, Collection<String> users) {
        ArrayList<Socket> toSend = new ArrayList<Socket>();
        try (Transaction t = this.transactionService.beginRead();){
            WebSocketController webSocketController = this;
            synchronized (webSocketController) {
                for (Socket socket : this.sockets) {
                    TrackingService.TrackingSession session;
                    String login = socket.user.getAssociatedDSSUserMandNoExc();
                    if (!users.contains(login) || !TrackingSessionUtils.isOnProject(session = this.trackingService.getSession(login, socket.sessionId), projectKey)) continue;
                    toSend.add(socket);
                }
            }
        }
        String msg = JSON.json((Object)Notification.of(evt));
        this.send(evt.getName(), msg, toSend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastToSession(String evtName, String sessionId, String msg, boolean shouldLoopBack) {
        ArrayList<Socket> toSend = new ArrayList<Socket>();
        WebSocketController webSocketController = this;
        synchronized (webSocketController) {
            for (Socket socket : this.sockets) {
                if (Objects.equals(sessionId, socket.sessionId) && !shouldLoopBack) continue;
                toSend.add(socket);
            }
        }
        this.send(evtName, msg, toSend);
    }

    private void send(final String evtName, final String msg, final List<Socket> toSend) {
        this.sendingExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Iterator iterator = toSend.iterator();
                while (iterator.hasNext()) {
                    Socket socket;
                    Socket socket2 = socket = (Socket)iterator.next();
                    synchronized (socket2) {
                        try {
                            socket.session.sendText(msg, new Callback(){

                                public void succeed() {
                                    DSSMetrics.registry().meter("dku.notifications.websocket.send.sentMessages").mark();
                                    DSSMetrics.registry().meter("dku.notifications.websocket.send.sentMessages." + evtName).mark();
                                    DSSMetrics.registry().histogram("dku.notifications.websocket.send.messageSize").update(msg.length());
                                    DSSMetrics.registry().histogram("dku.notifications.websocket.send.messageSize." + evtName).update(msg.length());
                                }

                                public void fail(Throwable x) {
                                    logger.warn((Object)"Failed to transmit a notification", x);
                                    DSSMetrics.registry().meter("dku.notifications.websocket.send.failedMessages").mark();
                                    DSSMetrics.registry().histogram("dku.notifications.websocket.send.failedMessageSize").update(msg.length());
                                }
                            });
                        }
                        catch (Throwable t) {
                            logger.error((Object)"Cannot send WebSocket message", t);
                        }
                    }
                }
            }
        });
    }

    static {
        EventRegistry.loadClass();
        logger = Logger.getLogger((String)"dku.websocket");
    }

    @WebSocket
    public class Socket {
        private String sessionId;
        private AuthCtx user;
        private Session session;

        public AuthCtx getUser() {
            return this.user;
        }

        public String getUserLoginSafe() {
            return this.user == null ? "unknown" : this.user.getAssociatedDSSUserMandNoExc();
        }

        @OnWebSocketClose
        public void onWebSocketClose(int code, String reason) {
            logger.info((Object)("WS closed code=" + code + " user=" + this.getUserLoginSafe() + " reason=" + reason));
            WebSocketController.getInstance().closeCallback(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnWebSocketOpen
        public void onWebSocketOpen(Session session) {
            this.sessionId = (String)((List)((WebSocketSession)session).getCoreSession().getParameterMap().get("tfaliu")).get(0);
            AuditContextBase.setIPInfo((UpgradeRequest)session.getUpgradeRequest());
            try (Transaction t = WebSocketController.this.transactionService.beginRead();){
                this.user = WebSocketController.this.authService.getMandatoryUser(session.getUpgradeRequest());
            }
            catch (Exception e) {
                logger.error((Object)("WS connection from " + String.valueOf(session.getRemoteSocketAddress()) + " rejected (could not authenticate): " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                session.close(1008, ExceptionUtils.getMessageWithCauses((Throwable)e), Callback.NOOP);
                return;
            }
            finally {
                AuditContextBase.reset();
            }
            logger.info((Object)("WS connected src=" + String.valueOf(session.getRemoteSocketAddress()) + " user=" + this.user.getAssociatedDSSUserMandNoExc()));
            this.session = session;
            WebSocketController.getInstance().openCallback(this);
            WebSocketController.this.pubSub.publish(new UIConnectionStateChangedEvent(this.user.getAssociatedDSSUserMandNoExc(), this.sessionId, true));
        }

        @OnWebSocketError
        public void onWebSocketError(Throwable arg0) {
            logger.warn((Object)"Unhandled WS error", arg0);
        }

        @OnWebSocketMessage
        public void onWebSocketText(String payload) {
            Notification notif;
            if (this.user == null) {
                logger.warn((Object)"Rejecting message from unauthentified WS connection");
                return;
            }
            JsonObject jsonObj = (JsonObject)JSON.parse((String)payload, JsonObject.class);
            if (jsonObj.has("type") && !EventRegistry.canBeDeserialized(jsonObj.getAsJsonPrimitive("type").getAsString())) {
                logger.debug((Object)("The backend cannot deserialize event type: " + String.valueOf(jsonObj.getAsJsonPrimitive("type"))));
                return;
            }
            try {
                notif = (Notification)JSON.parse((String)payload, Notification.class);
            }
            catch (RuntimeException e) {
                logger.warn((Object)("The backend failed to deserialize the following event: " + jsonObj.toString()), (Throwable)e);
                return;
            }
            DSSEvent event = notif.event;
            if (!event.getName().equals("ping")) {
                logger.trace((Object)("Received WS event " + event.getName()));
            }
            if (event instanceof FrontendEvent) {
                FrontendEvent frontendEvent = (FrontendEvent)event;
                frontendEvent.setAuthCtx(this.user);
            }
            WebSocketController.this.pubSub.publish(event);
        }
    }
}

