/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dss.shadelib.com.google.common.net.UrlEscapers;
import org.apache.commons.lang.StringUtils;

public class HrefContext {
    private final String rootUrl;

    public HrefContext(String rootUrl) {
        this.rootUrl = rootUrl;
    }

    public String root() {
        return this.rootUrl;
    }

    public String project(String projectKey) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/";
    }

    public String codeEnvRequest(String requestId) {
        return this.rootUrl + "/inbox/requests/" + HrefContext.escapePathSegment(requestId);
    }

    public String designCodeEnv(CodeEnvModel.EnvLang envLanguage, String envName) {
        return this.codeEnv(ApplicationConfigurator.DSSNodeType.DESIGN, envLanguage, envName);
    }

    public String dataset(String projectKey, String datasetName) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/datasets/" + HrefContext.escapePathSegment(datasetName) + "/explore/";
    }

    public String recipe(String projectKey, String recipeName) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/recipes/" + HrefContext.escapePathSegment(recipeName) + "/";
    }

    public String analysis(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/analysis/" + HrefContext.escapePathSegment(id) + "/script/";
    }

    public String retrievableKnowledge(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/knowledge-bank/" + HrefContext.escapePathSegment(id) + "/settings/";
    }

    public String savedModel(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/savedmodels/" + HrefContext.escapePathSegment(id) + "/versions/";
    }

    public String modelEvaluationStore(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/modelevaluationstores/" + HrefContext.escapePathSegment(id) + "/evaluations/";
    }

    public String folder(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/managedfolder/" + HrefContext.escapePathSegment(id) + "/view/";
    }

    public String streamingEndpoint(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/streaming-endpoints/" + HrefContext.escapePathSegment(id) + "/";
    }

    public String scenario(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/scenarios/" + HrefContext.escapePathSegment(id) + "/steps";
    }

    public String scenarioRuns(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/scenarios/" + HrefContext.escapePathSegment(id) + "/runs/list/";
    }

    public String insight(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/dashboards/insights/" + HrefContext.escapePathSegment(id) + "_/view";
    }

    public String jupyterNotebook(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/notebooks/jupyter/" + HrefContext.escapePathSegment(id) + "/";
    }

    public String sqlNotebook(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/notebooks/sql/" + HrefContext.escapePathSegment(id) + "/";
    }

    public String searchNotebook(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/notebooks/search/" + HrefContext.escapePathSegment(id) + "/";
    }

    public String lambdaService(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/api-designer/" + HrefContext.escapePathSegment(id) + "/endpoints/";
    }

    public String webapp(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/webapps/" + HrefContext.escapePathSegment(id) + "_/view";
    }

    public String codeStudio(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/code_studios/" + HrefContext.escapePathSegment(id) + "_/view";
    }

    public String report(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/report/" + HrefContext.escapePathSegment(id) + "/view";
    }

    public String article(String projectKey, String id) {
        return this.article(projectKey, id, false);
    }

    public String article(String projectKey, String id, boolean fullScreen) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/wiki/" + HrefContext.escapePathSegment(id) + (fullScreen ? "?fullScreen" : "");
    }

    public String dashboard(String projectKey, String id) {
        return this.dashboard(projectKey, id, false);
    }

    public String dashboard(String projectKey, String id, boolean fullScreen) {
        String url = this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/dashboards/" + HrefContext.escapePathSegment(id) + "_/view/";
        if (fullScreen) {
            url = url + "?fullScreen=true";
        }
        return url;
    }

    public String workspace(String workspaceKey) {
        return this.rootUrl + "/workspaces/" + HrefContext.escapePathSegment(workspaceKey);
    }

    public String workspaceObject(String workspaceKey, ITaggingService.TaggableType objectType, String projectKey, String objectId) {
        return this.workspace(workspaceKey) + "/" + HrefContext.escapePathSegment(projectKey) + "/" + objectType.toString() + "/" + HrefContext.escapePathSegment(objectId);
    }

    public String flow(String projectKey) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/flow/";
    }

    public String dataLineage(String projectKey, String datasetName, String columnName) {
        return this.rootUrl + "/data-catalog/data-lineage/export/" + HrefContext.escapePathSegment(projectKey) + "/" + HrefContext.escapePathSegment(datasetName) + "/" + HrefContext.escapePathSegment(columnName);
    }

    public String user(String login) {
        return this.rootUrl + "/profile/" + HrefContext.escapePathSegment(login) + "/";
    }

    public String usersSettings() {
        return this.rootUrl + "/admin/security/users/";
    }

    public String userEditSettings(String login) {
        return this.rootUrl + "/admin/security/users/edit/" + HrefContext.escapePathSegment(login) + "/";
    }

    public String job(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/jobs/" + HrefContext.escapePathSegment(id) + "/";
    }

    public String continuousActivity(String projectKey, String id) {
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/continuous-activities/" + HrefContext.escapePathSegment(id) + "/runs";
    }

    private String mlTaskBase(String projectKey, String analysisId, MLTask.MLTaskType taskType, String id) {
        String type = taskType == MLTask.MLTaskType.CLUSTERING ? "c" : "p";
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(projectKey) + "/analysis/" + HrefContext.escapePathSegment(analysisId) + "/ml/" + type + "/" + HrefContext.escapePathSegment(id);
    }

    public String mlTaskDesign(String projectKey, String analysisId, MLTask.MLTaskType taskType, String id) {
        String base = this.mlTaskBase(projectKey, analysisId, taskType, id);
        return base + "/list/design";
    }

    public String mlTask(String projectKey, String analysisId, MLTask.MLTaskType taskType, String id) {
        String base = this.mlTaskBase(projectKey, analysisId, taskType, id);
        return base + "/list/results";
    }

    private String getModelId(String projectKey, String analysisId, String mlTaskId, String sessionId, String analysisPps, String modelId) {
        return "A-" + projectKey + "-" + analysisId + "-" + mlTaskId + "-" + sessionId + "-" + analysisPps + "-" + modelId;
    }

    private String getSavedModelId(String smProjectKey, String smId, String smVersionId) {
        return "S-" + smProjectKey + "-" + smId + "-" + smVersionId;
    }

    public String savedModelReport(String smProjectKey, String smId, String smVersionId, MLTask.MLTaskType taskType, String routeSuffix) {
        return this.savedModelReport(smProjectKey, smId, smVersionId, taskType, routeSuffix, false);
    }

    public String savedModelReport(String smProjectKey, String smId, String smVersionId, MLTask.MLTaskType taskType, String routeSuffix, boolean exportMode) {
        String type = taskType == MLTask.MLTaskType.CLUSTERING ? "c" : "p";
        return this.rootUrl + "/projects/" + HrefContext.escapePathSegment(smProjectKey) + "/savedmodels/" + HrefContext.escapePathSegment(smId) + "/" + type + "/" + HrefContext.escapePathSegment(this.getSavedModelId(smProjectKey, smId, smVersionId)) + "/report" + (String)(StringUtils.isNotBlank((String)routeSuffix) ? "/" + HrefContext.escapePathSegment(routeSuffix) : "") + (exportMode ? "?exportMode=true" : "");
    }

    public String analysisReport(String projectKey, String analysisId, MLTask.MLTaskType taskType, String mlTaskId, String sessionId, String analysisPps, String modelId, String routeSuffix) {
        return this.analysisReport(projectKey, analysisId, taskType, mlTaskId, sessionId, analysisPps, modelId, routeSuffix, false);
    }

    public String analysisReport(String projectKey, String analysisId, MLTask.MLTaskType taskType, String mlTaskId, String sessionId, String analysisPps, String modelId, String routeSuffix, boolean exportMode) {
        return this.mlTaskBase(projectKey, analysisId, taskType, mlTaskId) + "/" + HrefContext.escapePathSegment(this.getModelId(projectKey, analysisId, mlTaskId, sessionId, analysisPps, modelId)) + "/report" + (String)(StringUtils.isNotBlank((String)routeSuffix) ? "/" + HrefContext.escapePathSegment(routeSuffix) : "") + (exportMode ? "?exportMode=true" : "");
    }

    public String analysisResults(String projectKey, String analysisId, MLTask.MLTaskType taskType, String mlTaskId) {
        return this.mlTaskBase(projectKey, analysisId, taskType, mlTaskId) + "/list/results";
    }

    public String analysisDesign(String projectKey, String analysisId, MLTask.MLTaskType taskType, String mlTaskId, String routeSuffix) {
        return this.mlTaskDesign(projectKey, analysisId, taskType, mlTaskId) + "/" + HrefContext.escapePathSegment(routeSuffix);
    }

    public String logPage(String projectKey, String analysisId, String mlTaskId, String sessionId, String analysisPps, String modelId) {
        return this.rootUrl + "/dip/api/analysis/mlcommon/cat-activity-log?fullModelId=" + HrefContext.escapeQueryStringSegment(this.getModelId(projectKey, analysisId, mlTaskId, sessionId, analysisPps, modelId));
    }

    public String application(String id) {
        return this.rootUrl + "/apps/" + HrefContext.escapePathSegment(id);
    }

    public String pluginSummary(String id) {
        return this.rootUrl + "/plugins/" + HrefContext.escapePathSegment(id) + "/summary/";
    }

    public String pluginStore(String id) {
        return this.rootUrl + "/plugins-explore/store/" + HrefContext.escapePathSegment(id);
    }

    public String udm(String id) {
        return this.rootUrl + "/catalog/meanings/";
    }

    public String plugin(String id) {
        return this.rootUrl + "/plugins/development/" + HrefContext.escapePathSegment(id) + "/definition/";
    }

    public String connection(String id) {
        return this.rootUrl + "/admin/connections/" + HrefContext.escapePathSegment(id) + "/";
    }

    public String request(String id) {
        return this.rootUrl + "/inbox/requests/" + HrefContext.escapePathSegment(id);
    }

    public String dataCollection(String id) {
        return this.rootUrl + "/data-catalog/data-collections/" + HrefContext.escapePathSegment(id);
    }

    public String codeEnv(ApplicationConfigurator.DSSNodeType nodeType, CodeEnvModel.EnvLang envLanguage, String envName) {
        return this.rootUrl + "/admin/code-envs/" + (switch (nodeType) {
            case ApplicationConfigurator.DSSNodeType.DESIGN -> "design";
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> "automation";
            default -> throw new IllegalArgumentException("Node type " + String.valueOf((Object)nodeType) + " does not support code env feature");
        }) + "/" + envLanguage.getLanguageInfo().toLowerCase() + "/" + HrefContext.escapePathSegment(envName) + "/";
    }

    private static String escapePathSegment(String urlPart) {
        return UrlEscapers.urlPathSegmentEscaper().escape(urlPart);
    }

    private static String escapeQueryStringSegment(String urlPart) {
        return UrlEscapers.urlFormParameterEscaper().escape(urlPart);
    }
}

