/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.shaker.filter.DisplayFilterColumn;
import com.dataiku.dip.shaker.types.Number;
import java.util.Objects;

public class NumericalRangeFilter
extends DisplayFilterColumn {
    private Double min;
    private Double max;
    private Number dt = new Number();
    private Boolean includeEmptyValues;

    public NumericalRangeFilter(String column, Double min, Double max, Boolean includeEmptyValues) {
        this.column = column;
        this.min = min;
        this.max = max;
        this.includeEmptyValues = includeEmptyValues;
    }

    @Override
    public boolean filterRow(MemRow row, Column cd) {
        String val = row.get(cd);
        double dv = this.dt.doubleValue(val);
        if (Double.isNaN(dv)) {
            return Objects.requireNonNullElse(this.includeEmptyValues, false);
        }
        return (this.min == null || dv >= this.min) && (this.max == null || dv <= this.max);
    }
}

