/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.formats.avro.AvroDSSRowReader;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class AvroInputFormatAdapter
extends FileInputFormat<Void, RowWithFactories> {
    private final DatasetConfig inputConf;
    private final AvroFormatConfig formatParams;
    private final Schema outputSchema;
    private final WarningsContext warningsContext;
    private final RowFactory rowFactory;
    private final ColumnFactory columnFactory;

    public AvroInputFormatAdapter(ColumnFactory cf, RowFactory rf, DatasetConfig inputConf, WarningsContext warningsContext) {
        this.inputConf = inputConf;
        this.rowFactory = rf;
        this.columnFactory = cf;
        this.formatParams = (AvroFormatConfig)inputConf.dataset.getFormatParams();
        this.outputSchema = inputConf.dataset.getSchema();
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
    }

    public RecordReader<Void, RowWithFactories> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new InternalRecordReader();
    }

    private class InternalRecordReader
    extends RecordReader<Void, RowWithFactories> {
        private FileReader<Row> avroReader;
        private long start;
        private long end;
        private Row currentRow;

        private InternalRecordReader() {
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            FileSplit fileInputSplit = (FileSplit)inputSplit;
            FsInput fsInput = new FsInput(fileInputSplit.getPath(), taskAttemptContext.getConfiguration());
            AvroDSSRowReader dssDatumReader = new AvroDSSRowReader();
            this.avroReader = DataFileReader.openReader((SeekableInput)fsInput, (DatumReader)dssDatumReader);
            dssDatumReader.setSchema(this.avroReader.getSchema());
            dssDatumReader.initialize(AvroInputFormatAdapter.this.columnFactory, AvroInputFormatAdapter.this.rowFactory, AvroInputFormatAdapter.this.outputSchema, AvroInputFormatAdapter.this.formatParams);
            this.avroReader.sync(fileInputSplit.getStart());
            this.start = this.avroReader.tell();
            this.end = fileInputSplit.getStart() + fileInputSplit.getLength();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            this.currentRow = null;
            if (!this.avroReader.hasNext() || this.avroReader.pastSync(this.end)) {
                return false;
            }
            this.currentRow = (Row)this.avroReader.next(null);
            return true;
        }

        public Void getCurrentKey() throws IOException, InterruptedException {
            return null;
        }

        public RowWithFactories getCurrentValue() throws IOException, InterruptedException {
            return new RowWithFactories(AvroInputFormatAdapter.this.columnFactory, AvroInputFormatAdapter.this.rowFactory, this.currentRow);
        }

        public float getProgress() throws IOException, InterruptedException {
            if (this.end == this.start) {
                return 0.0f;
            }
            return Math.min(1.0f, (float)(this.avroReader.tell() - this.start) / (float)(this.end - this.start));
        }

        public void close() throws IOException {
            this.avroReader.close();
        }
    }
}

