/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.expr;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.ExpressionError;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.model.StepParamsWithVariablesContext;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.FilterAndFlagProcessor;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SqlFilterAndFlagOnCustomFormulaResult;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FilterAndFlagOnCustomFormulaResult
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<FilterAndFlagOnCustomFormulaResult, Parameter> META_FILTER = new ProcessorMeta<FilterAndFlagOnCustomFormulaResult, Parameter>(){

        @Override
        public String getName() {
            return "FilterOnCustomFormula";
        }

        @Override
        public String getDocPage() {
            return "filter-on-formula";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CUSTOM, ProcessorTag.MATH, ProcessorTag.STRING, ProcessorTag.FILTER});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnCustomFormulaResult.FILTER.HELP", "Filter rows from the dataset based on the result of a formula. Alternatively, clear content from matching cells rather than filter the rows.\n\nThe row/cell matches if the result of the formula is considered as \"truish\", which includes:\n\n* A true boolean\n\n* A number (integer or decimal) that is not 0\n\n* The string \"true\"\n\n# Options\n\n**Action**\n\nSelect the action to perform on matching (in range) rows or cells: \n\n* Keep matching rows only\n\n* Remove matching rows\n\n* Clear content of matching cells\n\n* Clear content of non-matching cells");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withCustomForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnCustomFormulaResult.FILTER.DESCRIPTION", 1.actionVerb("Filter") + " rows/cells with formula")).withMNESParam("expression", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnCustomFormulaResult.DESCRIPTION.EXPRESSION", "Formula")).withFilterAndFlagMode("FILTER");
        }

        @Override
        public FilterAndFlagOnCustomFormulaResult build(Parameter param) {
            return new FilterAndFlagOnCustomFormulaResult(param);
        }

        @Override
        protected Object selfReport(Parameter param) throws Exception {
            JsonObject o = new JsonObject();
            o.addProperty("formulaLength", (Number)StringUtils.defaultIfBlank((String)param.expression, (String)"").length());
            if (param.action != null) {
                o.addProperty("action", param.action.name());
            }
            return o;
        }

        @Override
        public StepParams expandParams(StepParams params, VariablesContext vc) {
            Parameter grelParams = (Parameter)params;
            grelParams.expression = vc.expand(grelParams.expression);
            grelParams.variablesContext = vc;
            return grelParams;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            Parameter grelParams = (Parameter)sp;
            if (StringUtils.isNotBlank((String)grelParams.forcedSQLTranslation)) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                ret.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
            } else {
                Expression expr = new Expression(grelParams.expression);
                expr.setVariablesContext(grelParams.variablesContext);
                GrelToQueryTranslator translator = new GrelToQueryTranslator(new GrelToQueryMapping(dialect));
                try {
                    GrelTranslator.TranslationResult<String> tr = translator.translateToString(expr, false);
                    if (tr.isFullyTranslated) {
                        ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                        ret.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
                    } else {
                        ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: the formula is not fully translatable to SQL");
                        ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Cannot use optimized engine: the formula is not fully translatable to native spark");
                    }
                }
                catch (Exception e) {
                    ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: the formula is not fully translatable to SQL: " + e.getMessage());
                    ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Cannot use optimized engine: the formula is not fully translatable to native spark: " + e.getMessage());
                }
            }
            return ret;
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.expr.FilterAndFlagOnCustomFormulaResultNS";
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter grelParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                List<String> variables = new Expression(grelParams.expression).getVariables();
                for (String variable : variables) {
                    for (String outputColumn : updatedDatasetPairLineage.getOutputColumns()) {
                        updatedDatasetPairLineage.addFactorizedColumnRelations(variable, outputColumn, true);
                    }
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    public static final ProcessorMeta<FilterAndFlagOnCustomFormulaResult, Parameter> META_FLAG = new ProcessorMeta<FilterAndFlagOnCustomFormulaResult, Parameter>(){

        @Override
        public String getName() {
            return "FlagOnCustomFormula";
        }

        @Override
        public String getDocPage() {
            return "flag-on-formula";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CUSTOM, ProcessorTag.MATH, ProcessorTag.STRING, ProcessorTag.FILTER});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnCustomFormulaResult.FLAG.HELP", "Flag rows from the dataset based on the result of a formula by creating a column containing '1' for all matching (in-range) rows. Unmatched rows are left empty. \n\n# Options\n\n**Expression**\n\nWrite a formula by which to evaluate each row for a match. The row matches if the result of the formula is considered as \"truish\", which includes:\n\n* A true boolean\n\n* A number (integer or decimal) that is not 0\n\n* The string \"true\"\n\n**Flag column**\n\nName the column that will contain the match flags 1-true, empty-false\n\n# Related resources\n\nFor more information on the formula language, please see the <a target=\"_blank\" href=\"https://doc.dataiku.com/dss/latest/formula/index.html\">formula language reference</a> in Dataiku\u2019s documentation. \n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withCustomForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnCustomFormulaResult.FLAG.DESCRIPTION", 2.actionVerb("Flag") + " rows with formula")).withMNEColParam("flagColumn", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnCustomFormulaResult.DESCRIPTION.FLAG_COLUMN", "Column containing flag")).withMNESParam("expression", this.translate(language, "SHAKER.PROCESSOR.FilterAndFlagOnCustomFormulaResult.DESCRIPTION.EXPRESSION", "Formula")).withFilterAndFlagMode("FLAG");
        }

        @Override
        public FilterAndFlagOnCustomFormulaResult build(Parameter param) {
            return new FilterAndFlagOnCustomFormulaResult(param);
        }

        @Override
        protected Object selfReport(Parameter param) throws Exception {
            JsonObject o = new JsonObject();
            o.addProperty("formulaLength", (Number)StringUtils.defaultIfBlank((String)param.expression, (String)"").length());
            return o;
        }

        @Override
        public StepParams expandParams(StepParams params, VariablesContext vc) {
            Parameter grelParams = (Parameter)params;
            grelParams.expression = vc.expand(grelParams.expression);
            grelParams.variablesContext = vc;
            return grelParams;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            Parameter grelParams = (Parameter)sp;
            if (StringUtils.isNotBlank((String)grelParams.forcedSQLTranslation)) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                ret.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
            } else {
                Expression expr = new Expression(grelParams.expression);
                GrelToQueryTranslator translator = new GrelToQueryTranslator(new GrelToQueryMapping(dialect));
                try {
                    GrelTranslator.TranslationResult<String> tr = translator.translateToString(expr, false);
                    if (tr.isFullyTranslated) {
                        ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                        ret.withCan(ProcessorCapabilities.NATIVE_SPARK_IMPL);
                    } else {
                        ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: the formula is not fully translatable to SQL");
                        ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Cannot use optimized engine: the formula is not fully translatable to native spark");
                    }
                }
                catch (Exception e) {
                    ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: the formula is not fully translatable to SQL: " + e.getMessage());
                    ret.withCould(ProcessorCapabilities.NATIVE_SPARK_IMPL, "Cannot use optimized engine: the formula is not fully translatable to native spark: " + e.getMessage());
                }
            }
            return ret;
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.expr.FilterAndFlagOnCustomFormulaResultNS";
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }
    };
    private final Parameter parameter;
    private Expression expression;
    private Column flagColumn;
    private Column clearColumn;
    protected static final Logger logger = Logger.getLogger((String)"dku.datasets.sql");

    public FilterAndFlagOnCustomFormulaResult(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() throws Exception {
        this.expression = new Expression(this.parameter.expression);
        this.expression.setColumnFactory(this.cf);
        if (this.parameter.variablesContext != null) {
            this.expression.setVariablesContext(this.parameter.variablesContext);
        }
        if (!StringUtils.isBlank((String)this.parameter.flagColumn)) {
            this.flagColumn = this.getFlagColumn();
        }
        if (!StringUtils.isBlank((String)this.parameter.clearColumn)) {
            this.clearColumn = this.cf.column(this.parameter.clearColumn, Processor.ProcessorRole.INPUT_COLUMN);
        }
    }

    protected Column getFlagColumn() {
        List<String> inputColumns = this.expression.getVariables();
        Column lastKnown = null;
        for (Column col : this.getColumnFactory().columns()) {
            if (!inputColumns.contains(col.getName())) continue;
            lastKnown = col;
        }
        if (lastKnown == null) {
            return this.getColumnFactory().column(this.parameter.flagColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
        }
        return this.getColumnFactory().columnAfter(lastKnown.getName(), this.parameter.flagColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public static boolean rowMatches(Expression expression, Row row) {
        Object out = expression.evaluate(row);
        if (out != null && !(out instanceof ExpressionError)) {
            if (out instanceof Boolean) {
                return (Boolean)out;
            }
            if (out instanceof Number) {
                return ((Number)out).doubleValue() != 0.0;
            }
            return "true".equalsIgnoreCase(out.toString());
        }
        return false;
    }

    public void processRow(Row row) throws Exception {
        boolean matches = FilterAndFlagOnCustomFormulaResult.rowMatches(this.expression, row);
        FilterAndFlagProcessor.applyActionSingle(this.parameter.action, matches, row, this.clearColumn, this.flagColumn);
    }

    public void postProcess() throws Exception {
    }

    public static class Parameter
    implements StepParams,
    StepParamsWithVariablesContext {
        private static final long serialVersionUID = -1L;
        public String expression;
        public FilterAndFlagProcessor.Action action = FilterAndFlagProcessor.Action.KEEP_ROW;
        public String flagColumn;
        public String clearColumn;
        public String forcedSQLTranslation;
        transient VariablesContext variablesContext;

        public void validate() {
        }

        @Override
        public void setVariablesContext(VariablesContext vc) {
            this.variablesContext = vc;
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter params;

        private SQLTranslator(Parameter params) {
            this.params = params;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            return new SqlFilterAndFlagOnCustomFormulaResult(chain, this.params).apply();
        }
    }
}

