/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.geo;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DatasetDependency;
import com.dataiku.dip.ProcessorWithSingleCopyAdditionalInputs;
import com.dataiku.dip.SingleCopyAdditionalInputsLoader;
import com.dataiku.dip.data.geo.GeoPointUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalayer.streamimpl.StreamRow;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.geo.GeoDistanceProcessor;
import com.dataiku.dip.shaker.server.AdditionalInputAccessor;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.types.Latitude;
import com.dataiku.dip.shaker.types.Longitude;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.index.strtree.STRtree;

public class NearestNeighbourGeoJoiner
extends SingleRowProcessor
implements ProcessorWithSingleCopyAdditionalInputs<TreeLoader>,
Processor {
    private STRtree tree;
    public static final ProcessorMeta<NearestNeighbourGeoJoiner, Parameter> META = new ProcessorMeta<NearestNeighbourGeoJoiner, Parameter>(){

        @Override
        public String getName() {
            return "NearestNeighbourGeoJoiner";
        }

        @Override
        public String getDocPage() {
            return "geo-join";
        }

        @Override
        public Category getCategory() {
            return Category.GEOGRAPHIC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet();
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.NearestNeighbourGeoJoiner.HELP", "This processor performs a geographic nearest-neighbour join between two datasets with geo coordinates.\n\n# Example use case\nYou are processing a dataset of geo-tagged events. You have another dataset containing geo-tagged points of interest, and you want, for each event, to retrieve the identifier and details of the nearest point of interest.\n\n# Limitations\n\nThe 'other' dataset must be small (a few thousand records maximum). Prefer using a Geo-join recipe\n\n# Requirements\n\nThe dataset being processed must contain two columns containing the latitude and longitude. The 'other' dataset you join with must also contain two columns with latitude and longitude.\n\nFor the dataset being processed, the columns may have been generated by a previous step (like the GeoIP resolver).\n\n# Parameters\n\nThe processor needs the following parameters:\n\n* Latitude and longitude column in current dataset (which may have been generated by a previous step)\n* Name of the dataset to join with. Note that the dataset to join with must be in the same project.\n* Latitude and longitude column in the joined dataset.\n* Columns from the joined dataset that should be copied to the local dataset, for the nearest row.\n\n# Output\n\nThe processor outputs all columns from the joined dataset. For each row of the current dataset, the columns will contain the data from the nearest row in the joined dataset.\n\nIn addition, the processor outputs a 'join_distance' column containing the distance of the found nearest neightbour, in kilometers.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withCustomForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.NearestNeighbourGeoJoiner.DESCRIPTION", 1.actionVerb("Geo-join"))).withMNEColParam("leftLatCol", this.translate(language, "SHAKER.PROCESSOR.NearestNeighbourGeoJoiner.DESCRIPTION.LEFT_LAT_COL", "Latitude column in this dataset")).withMNEColParam("leftLonCol", this.translate(language, "SHAKER.PROCESSOR.NearestNeighbourGeoJoiner.DESCRIPTION.LEFT_LON_COL", "Longitude column in this dataset")).withMNESParam("rightInput", this.translate(language, "SHAKER.PROCESSOR.NearestNeighbourGeoJoiner.DESCRIPTION.RIGHT_INPUT", "Other dataset")).withMNESParam("rightLatCol", this.translate(language, "SHAKER.PROCESSOR.NearestNeighbourGeoJoiner.DESCRIPTION.RIGHT_LAT_COL", "Latitude column in other dataset")).withMNESParam("rightLonCol", this.translate(language, "SHAKER.PROCESSOR.NearestNeighbourGeoJoiner.DESCRIPTION.RIGHT_LON_COL", "Longitude column in other dataset")).withMNESParam("copyColumns", this.translate(language, "SHAKER.PROCESSOR.NearestNeighbourGeoJoiner.DESCRIPTION.COPY_COLUMNS", "Comma-separated columns to copy")).withParam("prefix", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.NearestNeighbourGeoJoiner.DESCRIPTION.PREFIX", "Output columns prefix")).withBool("useMiles", this.translate(language, "SHAKER.PROCESSOR.NearestNeighbourGeoJoiner.DESCRIPTION.USE_MILES", "Distance in miles"), "Output the distance in miles instead of kilometers").deprecate().withReplacementDocLink("other_recipes/geojoin").withReplacementName("Geo join recipe");
        }

        @Override
        public NearestNeighbourGeoJoiner build(Parameter parameter) throws Exception {
            return new NearestNeighbourGeoJoiner(parameter);
        }
    };
    final Parameter parameter;
    Column latDesc;
    Column lonDesc;
    List<Column> copyTargets = new ArrayList<Column>();
    Column outDistCol;
    boolean useMiles;
    GeometryFactory factory = new GeometryFactory();
    Latitude latType = new Latitude();
    Longitude lonType = new Longitude();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.geojoin");

    public NearestNeighbourGeoJoiner(Parameter parameter) {
        this.parameter = parameter;
        this.useMiles = parameter.useMiles;
    }

    @Override
    public TreeLoader buildLoader() {
        return new TreeLoader();
    }

    @Override
    public void setAdditionalInputs(TreeLoader loader) {
        this.tree = loader.getSharedTree();
    }

    public void init() {
        String prefix = this.parameter.prefix == null ? "" : this.parameter.prefix;
        this.latDesc = this.getColumnFactory().column(this.parameter.leftLatCol, Processor.ProcessorRole.INPUT_COLUMN);
        this.lonDesc = this.getColumnFactory().column(this.parameter.leftLonCol, Processor.ProcessorRole.INPUT_COLUMN);
        for (String copyColumn : this.parameter.copyColumns) {
            this.copyTargets.add(this.getColumnFactory().column(prefix + copyColumn, Processor.ProcessorRole.OUTPUT_COLUMN));
        }
        this.outDistCol = this.getColumnFactory().column(prefix + "join_distance", Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        String latVal = row.get(this.latDesc);
        if (!this.latType.validates(latVal)) {
            return;
        }
        String lonVal = row.get(this.lonDesc);
        if (!this.lonType.validates(lonVal)) {
            return;
        }
        if (this.tree == null || this.tree.size() == 0) {
            return;
        }
        Point p = this.factory.createPoint(new Coordinate(this.lonType.doubleValue(lonVal), this.latType.doubleValue(latVal)));
        RowAndPoint query = new RowAndPoint(p, null, null);
        RowAndPoint answer = (RowAndPoint)this.tree.nearestNeighbour(p.getEnvelopeInternal(), (Object)query, (ItemDistance)new RowAndPointItemDistance());
        for (int i = 0; i < this.copyTargets.size(); ++i) {
            row.put(this.copyTargets.get(i), answer.data[i]);
        }
        GeoDistanceProcessor.DistanceUnit unit = this.useMiles ? GeoDistanceProcessor.DistanceUnit.MILES : GeoDistanceProcessor.DistanceUnit.KILOMETERS;
        double distance = NearestNeighbourGeoJoiner.computeDistance(query.p, answer.p, unit);
        row.put(this.outDistCol, "" + distance);
    }

    public static double computeDistance(Point p1, Point p2, GeoDistanceProcessor.DistanceUnit unit) {
        return GeoPointUtils.computeDistance(p1.getY(), p1.getX(), p2.getY(), p2.getX(), unit);
    }

    public void postProcess() {
    }

    @Override
    public List<DatasetDependency> listDependencies() {
        ArrayList<String> requiredColumns = new ArrayList<String>();
        requiredColumns.addAll(this.parameter.copyColumns);
        requiredColumns.add(this.parameter.rightLatCol);
        requiredColumns.add(this.parameter.rightLonCol);
        return Lists.newArrayList((Object[])new DatasetDependency[]{new DatasetDependency(this.parameter.rightInput, requiredColumns, "scriptDeps")});
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String leftLatCol;
        public String leftLonCol;
        public String rightInput;
        public String rightLatCol;
        public String rightLonCol;
        public List<String> copyColumns = new ArrayList<String>();
        public String prefix = null;
        public boolean useMiles;

        public void validate() throws IllegalArgumentException {
        }
    }

    public class TreeLoader
    implements SingleCopyAdditionalInputsLoader {
        private STRtree sharedTree;

        @Override
        public Callable<Void> loadAdditionalInputs(AdditionalInputAccessor accessor) throws Exception {
            AdditionalInputAccessor.AdditionalInput rightInput = accessor.getAdditionalInput(NearestNeighbourGeoJoiner.this.parameter.rightInput);
            final RowInputStream rightIS = rightInput.getInput();
            ColumnFactory rightCF = rightInput.getColumnFactory();
            final Column latDesc = rightCF.column(NearestNeighbourGeoJoiner.this.parameter.rightLatCol, Processor.ProcessorRole.INPUT_COLUMN);
            final Column lonDesc = rightCF.column(NearestNeighbourGeoJoiner.this.parameter.rightLonCol, Processor.ProcessorRole.INPUT_COLUMN);
            final ArrayList<Column> copyDesc = new ArrayList<Column>();
            for (String copyColumn : NearestNeighbourGeoJoiner.this.parameter.copyColumns) {
                copyDesc.add(rightCF.column(copyColumn, Processor.ProcessorRole.INPUT_COLUMN));
            }
            this.sharedTree = new STRtree();
            return new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Row row;
                    int rowIdx = 0;
                    long fetchedBytes = 0L;
                    int maxRows = DKUApp.getParams().getIntParam("dku.prepare.processors.geojoin.maxRowsInJoinedDataset", Integer.valueOf(100000));
                    long maxBytes = DKUApp.getParams().getLongParam("dku.prepare.processors.geojoin.maxSizeFromJoinedDatasetMB", 100L) * 1000000L;
                    logger.infoV("Starting to load geo-join data maxRows=%d maxBytes=%d", new Object[]{maxRows, maxBytes});
                    while ((row = rightIS.next()) != null) {
                        String lonVal;
                        if (row instanceof StreamRow) {
                            fetchedBytes += ((StreamRow)row).getApproximateMemoryUsage();
                        }
                        if (rowIdx % 1000 == 0) {
                            Runtime runtime = Runtime.getRuntime();
                            double p = (double)runtime.totalMemory() / (double)runtime.maxMemory() * 100.0;
                            logger.infoV("Loaded rows=%d bytes=%d mem_usage=%.1f%%", new Object[]{rowIdx, fetchedBytes, p});
                        }
                        if (rowIdx > maxRows || fetchedBytes > maxBytes) {
                            throw new Exception(String.format("Joined dataset is too large, aborting. Please use a Geo-join recipe instead (rows:%s bytes:%s)", rowIdx, fetchedBytes));
                        }
                        String latVal = row.get(latDesc);
                        if (!NearestNeighbourGeoJoiner.this.latType.validates(latVal) || !NearestNeighbourGeoJoiner.this.lonType.validates(lonVal = row.get(lonDesc))) continue;
                        Point p = NearestNeighbourGeoJoiner.this.factory.createPoint(new Coordinate(NearestNeighbourGeoJoiner.this.lonType.doubleValue(lonVal), NearestNeighbourGeoJoiner.this.latType.doubleValue(latVal)));
                        TreeLoader.this.sharedTree.insert(p.getEnvelopeInternal(), (Object)new RowAndPoint(p, row, copyDesc));
                        ++rowIdx;
                    }
                    TreeLoader.this.sharedTree.build();
                    return null;
                }
            };
        }

        public STRtree getSharedTree() {
            return this.sharedTree;
        }
    }

    static class RowAndPoint {
        Point p;
        String[] data;

        public RowAndPoint(Point p, Row r, List<Column> copyColumns) {
            this.p = p;
            if (r != null) {
                this.data = new String[copyColumns.size()];
                for (int i = 0; i < copyColumns.size(); ++i) {
                    this.data[i] = r.get(copyColumns.get(i));
                }
            }
        }
    }

    static class RowAndPointItemDistance
    implements ItemDistance {
        RowAndPointItemDistance() {
        }

        public double distance(ItemBoundable arg0, ItemBoundable arg1) {
            RowAndPoint i0 = (RowAndPoint)arg0.getItem();
            RowAndPoint i1 = (RowAndPoint)arg1.getItem();
            return i0.p.distance((Geometry)i1.p);
        }
    }
}

