/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.text.StringNormalizationMode;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SwitchCase {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "SwitchCase";
        }

        @Override
        public String getDocPage() {
            return "switch-case";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.ENRICH});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.SwitchCase.HELP", "This processor applies rules to compute a new column based on the input column values.\n\n# Rules\nRules are defined as a list of key - value pairs. When a key is found in the input column, the corresponding value is set in the output column. The value of unmatched rows is empty by default. \nYou can set a default value in the *Value for unmatched rows* field.\nIn order to add as many matching conditions as necessary, click on the ADD RULE plus icon.\n# Normalization mode\nBy setting the normalization mode, you can specify whether you want the processor to perform:\n\n* **Case-sensitive** matches (*Exact* mode)\n* **Case-insensitive** matches (*Ignore case* mode)\n* **Case and accents-insensitive** matches (*Normalize* mode)\n\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.SwitchCase.DESCRIPTION", 1.actionVerb("Switch") + " case"), null, false).withParam(ParamDesc.advancedSelect("normalization", this.translate(language, "SHAKER.PROCESSOR.SwitchCase.DESCRIPTION.NORMALIZATION", "Normalization mode"), "", StringNormalizationMode.class, language).withDefaultValue(StringNormalizationMode.EXACT)).withParam("mapping", "map", true, true, this.translate(language, "SHAKER.PROCESSOR.SwitchCase.DESCRIPTION.MAPPING", "switch mappings from highest to lowest priority")).withParam("output", "string", true, true, this.translate(language, "SHAKER.PROCESSOR.SwitchCase.DESCRIPTION.OUTPUT", "Output column")).withParam("defaultValue", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.SwitchCase.DESCRIPTION.DEFAULT_VALUE", "The value for unmatched rows"));
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject obj = (JsonObject)JSON.parse((String)JSON.json((Object)parameter), JsonObject.class);
            obj.remove("inputColumn");
            obj.remove("mapping");
            obj.remove("outputColumn");
            obj.addProperty("nbMappings", (Number)parameter.mapping.size());
            return obj;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            Parameter p = (Parameter)sp;
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (p.normalization != StringNormalizationMode.EXACT && p.normalization != StringNormalizationMode.LOWERCASE) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, String.format("Cannot use SQL engine: %s string normalization is not translatable", p.normalization));
            } else {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public StreamImpl build(Parameter parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter params = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (StringUtils.isNotBlank((String)params.inputColumn) && StringUtils.isNotBlank((String)params.outputColumn)) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(params.outputColumn);
                    updatedDatasetPairLineage.addFactorizedColumnRelations(params.inputColumn, params.outputColumn);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    private static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final Parameter param;
        private List<Substitution> mapping;
        private Column outColumn;
        private Column inColumn;

        private StreamImpl(Parameter param) {
            this.param = param;
            this.mapping = new ArrayList<Substitution>();
            HashSet<String> mappingKeys = new HashSet<String>();
            for (Substitution p : param.mapping) {
                String normalized;
                if (p.to == null) {
                    p.to = "";
                }
                if (p.from == null) {
                    p.from = "";
                }
                if (mappingKeys.contains(normalized = param.normalization.apply(p.from))) continue;
                this.mapping.add(new Substitution(normalized, p.to.replace("\\", "\\\\")));
                mappingKeys.add(normalized);
            }
        }

        public void postProcess() {
        }

        public void init() throws Exception {
            this.inColumn = this.getColumnFactory().column(this.param.inputColumn, Processor.ProcessorRole.INPUT_COLUMN);
            this.outColumn = this.getColumnFactory().columnAfter(this.param.inputColumn, this.param.outputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
        }

        public void processRow(Row row) {
            String rowValue = StringUtils.defaultIfEmpty((String)row.get(this.inColumn), (String)"");
            String outputValue = this.param.defaultValue;
            String normalized = this.param.normalization.apply(rowValue);
            for (Substitution entry : this.mapping) {
                String searchValue = entry.from;
                String replaceValue = entry.to;
                if (!searchValue.equals(normalized)) continue;
                outputValue = replaceValue;
            }
            row.put(this.outColumn, outputValue);
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
            ArrayList allNames = Lists.newArrayList((Object[])new String[]{this.parameter.inputColumn, this.parameter.outputColumn});
            if (input.isAnyCreatedOrModifiedByCurrentQuery(allNames)) {
                input = input.makeSubquery();
            }
            new ColumnSQLTranslator(input, this.parameter.inputColumn).apply();
            return input;
        }

        private class ColumnSQLTranslator {
            private final ExpressionBuilder.ExpressionBuilderFactory expressionBuilderFactory = new ExpressionBuilder.ExpressionBuilderFactory();
            private final boolean lowercase;
            private final boolean useCaseSensitive;
            private final SQLQueryWithSchema input;
            private final String inputColumnName;
            private final Type inputColumnType;
            private final String outputColumnName;
            private final SchemaColumn inputSchemaColumn;

            ColumnSQLTranslator(SQLQueryWithSchema input, String inputColumnName) {
                this.input = input;
                this.inputColumnName = inputColumnName;
                this.inputSchemaColumn = input.getMandatoryCurrentColumn(inputColumnName);
                this.lowercase = SQLTranslator.this.parameter.normalization == StringNormalizationMode.LOWERCASE && !input.getDialect().hasCaseInsensitiveComparisons();
                this.useCaseSensitive = SQLTranslator.this.parameter.normalization == StringNormalizationMode.EXACT && input.getDialect().hasCaseInsensitiveComparisons();
                this.inputColumnType = this.inputSchemaColumn.getType();
                this.outputColumnName = SQLTranslator.this.parameter.outputColumn;
            }

            void apply() {
                ExpressionBuilder col = this.getExpressionBuilderOnInputColumn();
                ExpressionBuilder cw = this.buildSubstitutionsNestedExpression(col);
                this.input.addAfterOrReplaceColumn(this.inputSchemaColumn, cw, Type.STRING, this.outputColumnName, false);
            }

            private String normalizeString(String x) {
                if (this.lowercase) {
                    return StringNormalizationMode.forName("LOWERCASE").apply(x);
                }
                return x;
            }

            ExpressionBuilder normalizeColumn(ExpressionBuilder col) {
                ExpressionBuilder normalizedCol = col;
                if (this.lowercase) {
                    normalizedCol = normalizedCol.lower();
                }
                if (this.useCaseSensitive) {
                    normalizedCol = normalizedCol.caseSensitivity(true);
                }
                return normalizedCol;
            }

            protected ExpressionBuilder getExpressionBuilderOnInputColumn() {
                ExpressionBuilder result = this.input.col(this.inputColumnName);
                if (this.inputColumnType != Type.STRING) {
                    return result.castToString(100);
                }
                return result;
            }

            protected ExpressionBuilder buildSubstitutionsNestedExpression(ExpressionBuilder col) {
                if (SQLTranslator.this.parameter.mapping.isEmpty()) {
                    return this.expressionBuilderFactory.cst(SQLTranslator.this.parameter.defaultValue);
                }
                HashSet<String> affectedValues = new HashSet<String>();
                for (Substitution substitution : SQLTranslator.this.parameter.mapping) {
                    affectedValues.add(StringUtils.defaultIfEmpty((String)substitution.from, (String)""));
                }
                ArrayList<Substitution> effectiveSubstitutions = new ArrayList<Substitution>();
                Iterator iterator = affectedValues.iterator();
                while (iterator.hasNext()) {
                    String affectedValue;
                    String effectiveOutput = affectedValue = (String)iterator.next();
                    for (Substitution subst3 : SQLTranslator.this.parameter.mapping) {
                        if (SQLTranslator.this.parameter.normalization == StringNormalizationMode.LOWERCASE) {
                            if (!StringUtils.equalsIgnoreCase((String)effectiveOutput, (String)subst3.from)) continue;
                            effectiveOutput = StringUtils.defaultIfEmpty((String)subst3.to, (String)"");
                            continue;
                        }
                        if (!StringUtils.equals((String)effectiveOutput, (String)subst3.from)) continue;
                        effectiveOutput = StringUtils.defaultIfEmpty((String)subst3.to, (String)"");
                    }
                    effectiveSubstitutions.add(new Substitution(this.normalizeString(affectedValue), effectiveOutput));
                }
                ExpressionBuilder expressionBuilder = this.normalizeColumn(col);
                ArrayList<ExpressionBuilder> caseWhenArguments = new ArrayList<ExpressionBuilder>();
                for (Substitution subst4 : effectiveSubstitutions) {
                    if (StringUtils.isEmpty((String)subst4.from)) {
                        caseWhenArguments.add(expressionBuilder.eq(subst4.from).or(expressionBuilder.isnull()));
                    } else {
                        caseWhenArguments.add(expressionBuilder.eq(subst4.from));
                    }
                    caseWhenArguments.add(this.expressionBuilderFactory.cst(subst4.to));
                }
                caseWhenArguments.add(this.expressionBuilderFactory.cst(SQLTranslator.this.parameter.defaultValue));
                return this.expressionBuilderFactory.caseWhen(caseWhenArguments.toArray(new Object[0]));
            }
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = 1L;
        public String outputColumn = "";
        public String inputColumn = "";
        public StringNormalizationMode normalization = StringNormalizationMode.EXACT;
        public String defaultValue = "";
        public List<Substitution> mapping = new ArrayList<Substitution>();

        public void validate() throws IllegalArgumentException {
        }
    }

    public static class Substitution
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String from;
        public String to;

        public Substitution(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }
}

