/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ColumnOnly;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class QueryStringSplitter
extends SingleRowProcessor
implements Processor,
ProcessorWithRecordedReport {
    public static final ProcessorMeta<QueryStringSplitter, Parameter> META = new ProcessorMeta<QueryStringSplitter, Parameter>(){

        @Override
        public String getName() {
            return "QueryStringSplitter";
        }

        @Override
        public String getDocPage() {
            return "querystring-split";
        }

        @Override
        public Category getCategory() {
            return Category.WEB;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.WEB});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.QueryStringSplitter.HELP", "This processor splits the elements of an HTTP query string.\n\nThe query string is the part coming after the `?` in the string. For example: `product_id=234&step=3`\n# Output\nThis processor outputs one column for each chunk of the query string. Columns are named with the prefix and the key of the HTTP Query string chunk.\n# Example\nFor input:\n<table><tr><th>qs</th></tr><tr><td>product_id=234&step=3</td></tr><tr><td>customer_id=FDZ&action=cart&step=2</td></tr></table>\nWith prefix : 'qs_', result would be:\n<table><tr><th>qs</th><th>qs_product_id</th><th>qs_step</th><th>qs_customer_id</th><th>qs_action</th></tr><tr><td>product_id=234&step=3</td><td>234</td><td>3</td><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td>customer_id=FDZ&action=cart&step=3</td><td>&nbsp;</td><td>2</td><td>FDZ</td><td>cart</td></tr></table>\n");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.QueryStringSplitter.DESCRIPTION", 1.actionVerb("Split") + " HTTP Query String")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column")).withParam("prefix", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.QueryStringSplitter.DESCRIPTION.PREFIX", "Output columns prefix"));
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return this.getCapabilities(sp, report, dialect, null);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                if (report != null && report.report.has("producedColumns")) {
                    ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
                } else {
                    ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine: producedColumns was not recorded");
                }
            }
            return ret;
        }

        @Override
        public QueryStringSplitter build(Parameter parameter) throws Exception {
            return new QueryStringSplitter(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) throws IOException {
            return new SnowflakeUDFSQLTranslator((Parameter)parameter, (JsonArray)report.report.get("producedColumns"));
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter queryStringSplitterParam = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (pss.designTimeReport != null && pss.designTimeReport.report != null && pss.designTimeReport.report.has("producedColumns")) {
                    JsonArray outputProducedColumns = (JsonArray)pss.designTimeReport.report.get("producedColumns");
                    for (JsonElement outputColumn : outputProducedColumns) {
                        updatedDatasetPairLineage.addFactorizedColumnRelations(queryStringSplitterParam.column, outputColumn.getAsString());
                    }
                } else {
                    updatedRecipeLineage.setUncertain(true);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private String inCol;
    Parameter param;
    Column inColCD;
    String nextColName;
    List<String> chunksBuffer = new ArrayList<String>();
    List<String> subChunksBuffer = new ArrayList<String>();
    Set<String> producedColumns = new LinkedHashSet<String>();

    public QueryStringSplitter(Parameter param) {
        this.param = param;
        this.inCol = param.column;
    }

    public void init() {
        this.inColCD = this.getColumnFactory().column(this.inCol, Processor.ProcessorRole.INPUT_COLUMN);
        Column nextColCD = this.getColumnFactory().getColumnAfter(this.inCol);
        this.nextColName = nextColCD == null ? null : nextColCD.getName();
    }

    public void processRow(Row row) throws Exception {
        Column inColDesc = this.getColumnFactory().column(this.inCol, Processor.ProcessorRole.INPUT_COLUMN);
        String v = row.get(inColDesc);
        if (v == null || v.isEmpty()) {
            return;
        }
        try {
            StringUtils.split((String)v, (char)'&', (boolean)false, this.chunksBuffer);
            for (String chunk : this.chunksBuffer) {
                String colKey;
                StringUtils.split((String)chunk, (char)'=', (boolean)false, this.subChunksBuffer);
                if (this.subChunksBuffer.size() != 2) continue;
                String key = URLDecoder.decode(this.subChunksBuffer.get(0), "utf8");
                String value = URLDecoder.decode(this.subChunksBuffer.get(1), "utf8");
                String string = colKey = this.param.prefix != null ? this.param.prefix + key : key;
                if (!this.producedColumns.contains(colKey)) {
                    this.producedColumns.add(colKey);
                }
                Column kc = this.getColumnFactory().columnBefore(this.nextColName, colKey, Processor.ProcessorRole.OUTPUT_COLUMN);
                row.put(kc, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void postProcess() {
    }

    @Override
    public ProcessorWithRecordedReport.ProcessorRecordedReport getRecordedReport() {
        ProcessorWithRecordedReport.ProcessorRecordedReport ret = new ProcessorWithRecordedReport.ProcessorRecordedReport();
        JsonArray arr = new JsonArray();
        this.producedColumns.stream().forEach(c2 -> arr.add(c2));
        ret.report.add("producedColumns", (JsonElement)arr);
        return ret;
    }

    public static class Parameter
    extends ColumnOnly {
        private static final long serialVersionUID = -1L;
        public String prefix;
    }

    private static class SnowflakeUDFSQLTranslator
    implements SnowflakeUDFProcessorTranslator {
        private final Parameter parameter;
        private final List<String> producedColumns = new ArrayList<String>();
        private final String functionName;

        private SnowflakeUDFSQLTranslator(Parameter parameter, JsonArray producedColumnsArray) {
            this.parameter = parameter;
            for (JsonElement elt : producedColumnsArray) {
                this.producedColumns.add(((JsonPrimitive)elt).getAsString());
            }
            this.functionName = "httpQueryStringSplit_" + SecretKeyGenerator.generate();
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> getUDFResources() throws IOException {
            List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> resources = SnowflakeUDFProcessorTranslator.createStandardResourceList();
            SnowflakeUDFProcessorTranslator.addStandardResources(resources, SnowflakeUDFProcessorTranslator.StandardResource.SHADELIB, SnowflakeUDFProcessorTranslator.StandardResource.LOG4J_JAR, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR);
            return resources;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> getUDFs() {
            SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef def = new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.functionName, "com.dataiku.dip.shaker.processors.typespecific.QueryStringSplitterUDF.split", "data STRING, prefix STRING", "STRING, STRING", "OBJECT");
            def.importStandardResources(SnowflakeUDFProcessorTranslator.StandardResource.SHADELIB, SnowflakeUDFProcessorTranslator.StandardResource.LOG4J_JAR, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR);
            return Lists.newArrayList((Object[])new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef[]{def});
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            SQLDialect d = chain.getDialect();
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            if (chain.isCreatedOrModifiedByCurrentQuery(this.parameter.column)) {
                chain = chain.makeSubquery();
            }
            chain.select(ebf.expr(String.format("%s(%s, %s)", this.functionName, d.quoteIdentifier(this.parameter.column), this.parameter.prefix == null ? "null" : d.quoteString(this.parameter.prefix))), "HTTPQUERYSTRING_RESULT");
            SQLQueryWithSchema outer = chain.makeSubquery();
            SchemaColumn inputSchemaColumn = outer.getCurrentColumn(this.parameter.column);
            for (String producedColumn : this.producedColumns) {
                String lookupExpr = "HTTPQUERYSTRING_RESULT:" + d.quoteIdentifier(producedColumn) + "::string";
                outer.addAfterOrReplaceColumn(inputSchemaColumn, ebf.expr(lookupExpr), Type.STRING, producedColumn, false);
            }
            outer.deleteColumn("HTTPQUERYSTRING_RESULT");
            outer.deleteSelect("HTTPQUERYSTRING_RESULT");
            return outer;
        }
    }
}

