/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProcessorWithSubProcess;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.io.BasicKernelLink;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.io.SocketBlockLinkIOException;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.ProcessorWithBuffering;
import com.dataiku.dip.shaker.processors.udf.ImpersonablePythonUDFKernel;
import com.dataiku.dip.shaker.processors.udf.JythonUDFUtils;
import com.dataiku.dip.shaker.processors.udf.MetaWithRemoteCodeEnv;
import com.dataiku.dip.shaker.processors.udf.PythonUDFModeHandler;
import com.dataiku.dip.shaker.resources.YarnPythonBinsSetup;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.PythonInterpreterFactory;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.util.PythonInterpreter;

public abstract class AbstractPythonUDF
extends SingleInputSingleOutputRowProcessor
implements Processor,
ProcessorWithSubProcess,
ProcessorWithBuffering {
    static final String PROCESS_MISSING_ERROR = "Python source code should contain a process function.";
    static final String DICT_IN_ROW_MODE_ERROR = "In Row mode, script should return a dictionary.";
    static final String LIST_OF_DICT_IN_MULTIROWS_ERROR = "In multirows mode, script should return a list or a generator of dictionary.";
    private final boolean usePythonUnicode;
    private final boolean stopOnError;
    private final boolean useKernel;
    private final boolean vectorize;
    private final int vectorSize;
    private final List<String> sourceColumnsList;
    private final String sourceColumnsPattern;
    private final String entryPointName;
    private final Map<String, String> variablesDefinition;
    private final PythonUDFModeHandler modeHandler;
    private final MetaWithRemoteCodeEnv meta;
    private final PythonInterpreter interpreter;
    private ImpersonablePythonUDFKernel kernel;
    private AutoDelete tmpDir;
    private BasicKernelLink link;
    protected String lastError;
    private PyFunction entryPoint;
    public boolean noBuffering = false;
    private final List<Row> rowBuffer = Lists.newArrayList();
    protected static Logger logger = Logger.getLogger((String)"dku.shaker.python");

    public AbstractPythonUDF(MetaWithRemoteCodeEnv meta, boolean usePythonUnicode, boolean stopOnError, boolean useKernel, String sourceColumnsPattern, List<String> sourceColumnsList, boolean vectorize, int vectorSize, Map<String, String> variablesDefinition, String entryPointName, PythonUDFModeHandler modeHandler) {
        this.meta = meta;
        this.usePythonUnicode = usePythonUnicode;
        this.stopOnError = stopOnError;
        this.useKernel = useKernel;
        this.sourceColumnsPattern = sourceColumnsPattern;
        this.sourceColumnsList = sourceColumnsList;
        this.vectorize = vectorize;
        this.vectorSize = vectorSize;
        this.variablesDefinition = variablesDefinition;
        this.entryPointName = entryPointName;
        this.modeHandler = modeHandler;
        if (useKernel) {
            this.interpreter = null;
        } else {
            logger.info((Object)"CREATING A Python Interpreter");
            this.interpreter = PythonInterpreterFactory.newInstance(true, true);
        }
    }

    public abstract String getPythonSourceCode() throws IOException;

    public abstract String getCodeEnvName(MetaWithRemoteCodeEnv var1, String var2) throws IOException;

    public String getCodeEnvName(String projectKey) throws IOException {
        return this.getCodeEnvName(this.meta, projectKey);
    }

    public abstract void initInterpreter(PythonInterpreter var1);

    public abstract void initKernel(ImpersonablePythonUDFKernel.PythonCommand var1);

    public boolean getUseKernel() {
        return this.useKernel;
    }

    @Override
    public void setNoBuffering() {
        this.noBuffering = true;
    }

    public void processRow(Row row) throws Exception {
        if (this.useKernel) {
            int bufferSize;
            this.rowBuffer.add(row);
            int n = this.noBuffering ? 1 : (bufferSize = this.vectorize ? Math.max(this.vectorSize, 1) : 32);
            if (this.rowBuffer.size() >= bufferSize) {
                this.processWithKernel(this.rowBuffer);
                this.rowBuffer.clear();
            }
        } else {
            PyObject result;
            PyDictionary rowDictionary = new PyDictionary();
            for (Column col : this.getCf().columns()) {
                PyUnicode pyColName;
                String v = row.get(col);
                Object object = pyColName = this.usePythonUnicode ? new PyUnicode(col.getName()) : new PyString(col.getName());
                if (v != null) {
                    rowDictionary.__setitem__((PyObject)pyColName, (PyObject)(this.usePythonUnicode ? new PyUnicode(v) : new PyString(v)));
                    continue;
                }
                rowDictionary.__setitem__((PyObject)pyColName, Py.None);
            }
            try {
                result = this.entryPoint.__call__((PyObject)rowDictionary);
            }
            catch (PyException e) {
                if (e.match(Py.KeyboardInterrupt)) {
                    throw new InterruptedException("Interrupted while running Python script");
                }
                if (this.stopOnError) {
                    throw new IllegalArgumentException("Python runtime error/ " + JythonUDFUtils.formatPyException(e), e);
                }
                String error = JythonUDFUtils.formatPyException(e);
                if (this.lastError == null || !this.lastError.equals(error)) {
                    logger.warn((Object)("Error on row : " + error));
                    this.lastError = error;
                }
                this.modeHandler.errorFromJython(this.getProcessorOutput(), this.getCf(), this.getRf(), row, e);
                return;
            }
            this.modeHandler.emitFromJython(this.getProcessorOutput(), this.getCf(), this.getRf(), row, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processWithKernel(List<Row> rows) throws Exception {
        void var7_11;
        int expected;
        if (rows.size() == 0) {
            return;
        }
        ArrayList columnNames = Lists.newArrayList();
        for (Column col : this.getCf().columns()) {
            columnNames.add(col.getName());
        }
        ImpersonablePythonUDFKernel.ProcessRequest req = new ImpersonablePythonUDFKernel.ProcessRequest(rows.size(), columnNames);
        HashSet sourceColumns = Sets.newHashSet();
        HashSet sourceColumnsListAsSet = Sets.newHashSet();
        for (String string : this.sourceColumnsList) {
            if (!StringUtils.isNotBlank((String)string)) continue;
            sourceColumnsListAsSet.add(string);
        }
        Pattern sourceColumnsPatternCompiled = StringUtils.isNotBlank((String)this.sourceColumnsPattern) ? Pattern.compile(this.sourceColumnsPattern) : null;
        for (Column c3 : this.getCf().columns()) {
            if (!sourceColumnsListAsSet.contains(c3.getName()) && (sourceColumnsPatternCompiled == null || !sourceColumnsPatternCompiled.matcher(c3.getName()).matches())) continue;
            sourceColumns.add(c3);
        }
        for (Column c2 : sourceColumns) {
            ArrayList values = Lists.newArrayList();
            for (Row row : rows) {
                values.add(row.get(c2));
            }
            req.sourceValues.put(c2.getName(), values);
        }
        this.link.sendRequest((Object)req);
        boolean bl = false;
        int n = expected = this.vectorize ? 1 : rows.size();
        block10: while (var7_11 < expected) {
            ImpersonablePythonUDFKernel.ProcessMessageInfo info = (ImpersonablePythonUDFKernel.ProcessMessageInfo)this.link.receiveJsonResponse(ImpersonablePythonUDFKernel.ProcessMessageInfo.class);
            switch (info.type) {
                case RESULT: {
                    ImpersonablePythonUDFKernel.ProcessResponse response = (ImpersonablePythonUDFKernel.ProcessResponse)this.link.receiveJsonResponse(ImpersonablePythonUDFKernel.ProcessResponse.class);
                    if (this.vectorize) {
                        if (response.indices == null) {
                            throw new Exception("Vectorized udf did not return a vector (no index)");
                        }
                        this.modeHandler.emitVectorFromKernel(this.getProcessorOutput(), this.getCf(), this.getRf(), rows, response.indices, response.processed);
                    } else {
                        this.modeHandler.emitFromKernel(this.getProcessorOutput(), this.getCf(), this.getRf(), rows.get(response.idx), response.processed);
                    }
                    ++var7_11;
                    continue block10;
                }
                case GET_COLUMN_DATA: {
                    ImpersonablePythonUDFKernel.ColumnDataRequest columnRequest = (ImpersonablePythonUDFKernel.ColumnDataRequest)this.link.receiveJsonResponse(ImpersonablePythonUDFKernel.ColumnDataRequest.class);
                    ArrayList values = Lists.newArrayList();
                    for (Row row : rows) {
                        values.add(row.get(this.getCf().column(columnRequest.name)));
                    }
                    this.link.sendRequest((Object)new ImpersonablePythonUDFKernel.ColumnDataResponse(values));
                    continue block10;
                }
                case ERROR: {
                    ImpersonablePythonUDFKernel.ProcessResponse error = (ImpersonablePythonUDFKernel.ProcessResponse)this.link.receiveJsonResponse(ImpersonablePythonUDFKernel.ProcessResponse.class);
                    if (this.stopOnError) {
                        throw new IllegalArgumentException("Python runtime error/ " + error.error.getSerializedThrowable().getMessage());
                    }
                    if (this.vectorize) {
                        this.modeHandler.errorVectorFromKernel(this.getProcessorOutput(), this.getCf(), this.getRf(), rows, error.error);
                    } else {
                        this.modeHandler.errorFromKernel(this.getProcessorOutput(), this.getCf(), this.getRf(), rows.get(error.idx), error.error);
                    }
                    ++var7_11;
                    continue block10;
                }
            }
            throw new Error("unreachable");
        }
    }

    public void init() throws Exception {
        try {
            if (this.interpreter != null) {
                if (this.variablesDefinition != null) {
                    PyDictionary varsDict = new PyDictionary();
                    for (Map.Entry<String, String> v : this.variablesDefinition.entrySet()) {
                        varsDict.put((Object)v.getKey(), (Object)v.getValue());
                    }
                    this.interpreter.set("dss_variables", (PyObject)varsDict);
                }
                this.initInterpreter(this.interpreter);
                this.interpreter.exec(this.getPythonSourceCode());
                PyObject entryPointObj = this.interpreter.get(this.entryPointName);
                if (!(entryPointObj instanceof PyFunction)) {
                    throw new IllegalArgumentException(PROCESS_MISSING_ERROR);
                }
                this.entryPoint = (PyFunction)entryPointObj;
            }
            this.modeHandler.initModeSpecific(this.getCf());
        }
        catch (PyException e) {
            throw new IllegalArgumentException("Python error : " + JythonUDFUtils.formatPyException(e), e);
        }
    }

    public void postProcess() throws Exception {
        if (this.useKernel) {
            this.processWithKernel(this.rowBuffer);
        }
        this.getProcessorOutput().lastRowEmitted();
        this.killSubProcess();
    }

    protected void enrichPythonLibsForLocalExecution(Map<String, String> pythonLibs) {
    }

    @Override
    public void spawn(AuthCtx authCtx, String projectKey, boolean impersonated, Map<String, String> pythonlibs) throws Exception {
        boolean kernelUsesProjectLibs;
        if (!this.useKernel) {
            return;
        }
        logger.info((Object)("CREATING A Python kernel, with pythonlibs=" + JSON.json(pythonlibs)));
        String secret = SecretKeyGenerator.generate((int)16);
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        this.link = new BasicKernelLink(secret, dssPortRange);
        if (YarnPythonBinsSetup.isRemote) {
            kernelUsesProjectLibs = false;
            File tmpDirLocation = new File(".", "__dku_python_udf-" + SecretKeyGenerator.generate((int)12));
            DKUFileUtils.mkdirs((File)tmpDirLocation);
            this.tmpDir = new AutoDelete(tmpDirLocation);
        } else {
            kernelUsesProjectLibs = true;
            if (pythonlibs == null) {
                pythonlibs = new HashMap<String, String>();
            }
            this.enrichPythonLibsForLocalExecution(pythonlibs);
            this.tmpDir = FlowJobUtils.getTmpFolder("python-udf", "run");
        }
        String code = this.getPythonSourceCode();
        String envName = this.getCodeEnvName(this.meta, projectKey);
        logger.info((Object)("Use code env " + envName));
        this.kernel = new ImpersonablePythonUDFKernel(this.link, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_MACRO, kernelUsesProjectLibs, pythonlibs, (File)this.tmpDir, impersonated, projectKey, authCtx, envName);
        this.kernel.start();
        SecretProtectedKernelLink.AcknowledgeResponse started = null;
        try {
            ImpersonablePythonUDFKernel.PythonCommand command = new ImpersonablePythonUDFKernel.PythonCommand(projectKey, code, this.variablesDefinition, this.vectorize);
            this.initKernel(command);
            this.link.sendRequest((Object)command);
            started = (SecretProtectedKernelLink.AcknowledgeResponse)this.link.receiveJsonResponse(SecretProtectedKernelLink.AcknowledgeResponse.class);
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        catch (IOException e) {
            throw new SocketBlockLinkIOException("Failed to initialize udf", (Throwable)e).withLogTail((IDSSKernelBase)this.kernel);
        }
        if (!started.ok) {
            logger.warn((Object)"Failed to start worker");
            try {
                this.link.close();
                this.kernel.killWithoutMercy();
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to cleanup setup kernel", (Throwable)ex);
            }
            this.link = null;
            this.kernel = null;
            throw new SocketBlockLinkKernelException("Failed to start worker", started.error);
        }
    }

    public void cancel() throws Exception {
        this.killSubProcess();
        super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killSubProcess() throws Exception {
        if (this.interpreter != null) {
            this.interpreter.close();
        }
        if (this.kernel != null) {
            try {
                this.kernel.killWithoutMercy();
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to kill kernel", e);
            }
            finally {
                this.kernel = null;
            }
        }
        if (this.link != null) {
            try {
                this.link.close();
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to close link", e);
            }
            finally {
                this.link = null;
            }
        }
        if (this.tmpDir != null) {
            try {
                this.tmpDir.close();
            }
            finally {
                this.tmpDir = null;
            }
        }
    }

    protected static class RowDelta {
        public List<String> __dku_deleted_columns;
        public JsonObject __dku_added_columns;

        protected RowDelta() {
        }
    }
}

