/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.ProcessorWithResolvedParams;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.ProcessorWithSubProcess;
import com.dataiku.dip.SingleCopyAdditionalInputsLoader;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.ProcessorWithFactories;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SRPAdapter;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.SingleOutputRowProcessor;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.AdditionalInputsHelper;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.server.StreamedAdditionalInputAccessor;
import com.dataiku.dip.shaker.streamimpl.StreamPipelineFactory;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShakerStreamService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private DatasetsDAO datasetsDAO;

    public ProcessorOutputToSIP getProcessorOutput(AuthCtx authCtx, String inputDatasetProjectKey, SerializedShakerScript script, ProcessorOutput out, ColumnFactory cf, RowFactory rf) throws Exception {
        List<ScriptStep> steps;
        if (script != null) {
            SerializedShakerScript expandedScript = script.expandedDeepCopy(this.variablesService.getContext(script.contextProjectKey == null ? inputDatasetProjectKey : script.contextProjectKey));
            steps = expandedScript.steps;
        } else {
            steps = new ArrayList<ScriptStep>();
        }
        StreamPipelineFactory.StreamPipeline streamPipeline = StreamPipelineFactory.build(steps, BaseProcessorsFactory.PipelineContext.sharedPipelineContext(), true);
        Object last = Iterables.getLast(streamPipeline.allProcessors);
        if (!(last instanceof SingleOutputRowProcessor)) {
            throw ErrorContext.iae((String)"Could not plug output, no end of pipe");
        }
        ((SingleOutputRowProcessor)last).setProcessorOutput(out);
        Object first = streamPipeline.allProcessors.get(0);
        if (!(first instanceof SingleInputRowProcessor)) {
            throw ErrorContext.iae((String)"Could not plug input");
        }
        ProcessorOutputToSIP connector = new ProcessorOutputToSIP((SingleInputRowProcessor)first);
        for (Object o : streamPipeline.allProcessors) {
            Object rproc;
            if (o instanceof ProcessorWithResourceFiles) {
                rproc = (ProcessorWithResourceFiles)o;
                rproc.setRequiredFiles(rproc.gatherRequirements());
            }
            if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithResourceFiles) {
                rproc = (ProcessorWithResourceFiles)((SRPAdapter)o).getProcessor();
                rproc.setRequiredFiles(rproc.gatherRequirements());
            }
            if (o instanceof ProcessorWithResolvedParams) {
                rproc = (ProcessorWithResolvedParams)o;
                rproc.resolve(authCtx, inputDatasetProjectKey);
            }
            if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithResolvedParams) {
                rproc = (ProcessorWithResolvedParams)((SRPAdapter)o).getProcessor();
                rproc.resolve(authCtx, inputDatasetProjectKey);
            }
            if (o instanceof ProcessorWithSubProcess) {
                rproc = (ProcessorWithSubProcess)o;
                rproc.spawn(authCtx, inputDatasetProjectKey, true, null);
            }
            if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithSubProcess) {
                rproc = (ProcessorWithSubProcess)((SRPAdapter)o).getProcessor();
                rproc.spawn(authCtx, inputDatasetProjectKey, true, null);
            }
            if (o instanceof SingleInputSingleOutputRowProcessor) {
                ((SingleInputSingleOutputRowProcessor)o).setFactories(cf, rf);
                ((SingleInputSingleOutputRowProcessor)o).init();
                continue;
            }
            if (!(o instanceof ProcessorWithFactories)) continue;
            ((ProcessorWithFactories)o).setFactories(cf, rf);
        }
        if (TransactionContext.hasAttachedTransaction()) {
            StreamedAdditionalInputAccessor additionalInputsAccessor = new StreamedAdditionalInputAccessor(authCtx, inputDatasetProjectKey, this.datasetsDAO);
            List<SingleCopyAdditionalInputsLoader> additionalInputLoaders = AdditionalInputsHelper.getLoadersForAllProcessors(additionalInputsAccessor, steps, null);
            AdditionalInputsHelper.setAdditionalInputsOnProcessors(additionalInputsAccessor, additionalInputLoaders, streamPipeline.allProcessors);
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                StreamedAdditionalInputAccessor additionalInputsAccessor = new StreamedAdditionalInputAccessor(authCtx, inputDatasetProjectKey, this.datasetsDAO);
                List<SingleCopyAdditionalInputsLoader> additionalInputLoaders = AdditionalInputsHelper.getLoadersForAllProcessors(additionalInputsAccessor, steps, null);
                AdditionalInputsHelper.setAdditionalInputsOnProcessors(additionalInputsAccessor, additionalInputLoaders, streamPipeline.allProcessors);
            }
        }
        return connector;
    }
}

