/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.streamimpl;

import com.dataiku.dip.ProcessorWithResolvedParams;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.ProcessorWithSubProcess;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.ProcessorWithFactories;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SRPAdapter;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.SingleOutputRowProcessor;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalayer.utils.Forwarder;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.GroupScriptStep;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.MemTableProcessor;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;

public class StreamPipelineFactory {
    private static SingleOutputRowProcessor buildOneStep(StreamPipeline pipe, SingleOutputRowProcessor prevProc, ScriptStep step, BaseProcessorsFactory.PipelineContext pipelineContext) throws Exception {
        if (step.disabled) {
            return prevProc;
        }
        switch (step.metaType) {
            case GROUP: {
                for (ScriptStep scriptStep : ((GroupScriptStep)step).steps) {
                    prevProc = StreamPipelineFactory.buildOneStep(pipe, prevProc, scriptStep, pipelineContext);
                }
                break;
            }
            case PROCESSOR: {
                ProcessorScriptStep pss = (ProcessorScriptStep)step;
                Processor processor = BaseProcessorsFactory.build(pss, pipelineContext);
                if (prevProc != null) {
                    if (processor instanceof SingleInputSingleOutputRowProcessor) {
                        StreamPipelineFactory.connectForwardProcessors(prevProc, (SingleInputRowProcessor)((SingleInputSingleOutputRowProcessor)processor));
                        prevProc = (SingleInputSingleOutputRowProcessor)processor;
                        pipe.allProcessors.add(processor);
                        break;
                    }
                    if (processor instanceof SingleRowProcessor) {
                        SRPAdapter a = new SRPAdapter((SingleRowProcessor)processor);
                        StreamPipelineFactory.connectForwardProcessors(prevProc, (SingleInputRowProcessor)a);
                        prevProc = a;
                        pipe.allProcessors.add(a);
                        break;
                    }
                    if (processor instanceof SingleOutputRowProcessor) {
                        throw new Exception("Invalid processor " + processor.getClass().getCanonicalName());
                    }
                    if (!(processor instanceof MemTableProcessor)) break;
                    pipe.hasNonStreamableProcessors = true;
                    break;
                }
                if (processor instanceof SingleOutputRowProcessor) {
                    prevProc = (SingleOutputRowProcessor)processor;
                    pipe.allProcessors.add(processor);
                    break;
                }
                if (processor instanceof SingleRowProcessor) {
                    SRPAdapter a = new SRPAdapter((SingleRowProcessor)processor);
                    prevProc = a;
                    pipe.allProcessors.add(a);
                    break;
                }
                if (!(processor instanceof MemTableProcessor)) break;
                pipe.hasNonStreamableProcessors = true;
            }
        }
        return prevProc;
    }

    public static StreamPipeline build(List<ScriptStep> steps, BaseProcessorsFactory.PipelineContext pipelineContext, boolean addForwarderIfEmpty) throws Exception {
        StreamPipeline pipe = new StreamPipeline();
        SingleOutputRowProcessor prevProc = null;
        for (ScriptStep step : steps) {
            prevProc = StreamPipelineFactory.buildOneStep(pipe, prevProc, step, pipelineContext);
        }
        if (pipe.allProcessors.isEmpty() && addForwarderIfEmpty) {
            pipe.allProcessors.add((Object)new Forwarder());
        }
        return pipe;
    }

    private static void connectForwardProcessors(SingleOutputRowProcessor up, SingleInputRowProcessor down) {
        ProcessorOutputToSIP connector = new ProcessorOutputToSIP(down);
        up.setProcessorOutput((ProcessorOutput)connector);
    }

    public static class StreamPipeline {
        public List<Object> allProcessors = new ArrayList<Object>();
        public boolean hasNonStreamableProcessors = false;

        public void setPipelineOutput(ProcessorOutput output) {
            Object last = this.allProcessors.get(this.allProcessors.size() - 1);
            if (!(last instanceof SingleOutputRowProcessor)) {
                throw ErrorContext.iae((String)"Could not plug output, no end of pipe");
            }
            ((SingleOutputRowProcessor)last).setProcessorOutput(output);
        }

        public void init(AuthCtx authCtx, String projectKey, ColumnFactory cf, RowFactory rf) throws Exception {
            for (Object o : this.allProcessors) {
                Object rproc;
                if (o instanceof ProcessorWithResourceFiles) {
                    rproc = (ProcessorWithResourceFiles)o;
                    rproc.setRequiredFiles(rproc.gatherRequirements());
                }
                if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithResourceFiles) {
                    rproc = (ProcessorWithResourceFiles)((SRPAdapter)o).getProcessor();
                    rproc.setRequiredFiles(rproc.gatherRequirements());
                }
                if (o instanceof ProcessorWithResolvedParams) {
                    rproc = (ProcessorWithResolvedParams)o;
                    rproc.resolve(authCtx, projectKey);
                }
                if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithResolvedParams) {
                    rproc = (ProcessorWithResolvedParams)((SRPAdapter)o).getProcessor();
                    rproc.resolve(authCtx, projectKey);
                }
                if (o instanceof ProcessorWithSubProcess) {
                    rproc = (ProcessorWithSubProcess)o;
                    rproc.spawn(authCtx, projectKey, true, null);
                }
                if (o instanceof SRPAdapter && ((SRPAdapter)o).getProcessor() instanceof ProcessorWithSubProcess) {
                    rproc = (ProcessorWithSubProcess)((SRPAdapter)o).getProcessor();
                    rproc.spawn(authCtx, projectKey, true, null);
                }
                if (o instanceof SingleInputSingleOutputRowProcessor) {
                    ((SingleInputSingleOutputRowProcessor)o).setFactories(cf, rf);
                    ((SingleInputSingleOutputRowProcessor)o).init();
                    continue;
                }
                if (!(o instanceof ProcessorWithFactories)) continue;
                ((ProcessorWithFactories)o).setFactories(cf, rf);
            }
        }

        public void postProcess() throws Exception {
            for (Object o : this.allProcessors) {
                if (o instanceof SingleRowProcessor) {
                    ((SingleRowProcessor)o).postProcess();
                    continue;
                }
                if (!(o instanceof SingleInputRowProcessor)) continue;
                ((SingleInputRowProcessor)o).postProcess();
            }
        }
    }
}

