/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.SchemaMismatchException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.pivot.backend.sql.utils.QueryUtils;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.SQLAggregateAbility;
import com.dataiku.dip.sql.SQLAggregateType;
import com.dataiku.dip.sql.SQLCapability;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SchemaOptions;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QuerySQLWriter;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.sql.regex.RegexDatabaseSupport;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public abstract class GenericSQLDialect
implements SQLDialect {
    protected final List<String> booleanTrueValues = Lists.newArrayList((Object[])new String[]{"true", "t", "yes", "y", "o", "1"});
    protected final String booleanTrueValuesRegex = "(" + Joiner.on((String)"|").join(this.booleanTrueValues) + ")";
    private static final Pattern validIdentifierPattern = Pattern.compile("^[\\p{L}_][\\p{L}\\p{M}_0-9$]*$");
    protected final DateTimeFormatter datetimenotzFormatter = DKUtils.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS").withZoneUTC();
    protected final ThreadLocal<Calendar> utcCalendar = new ThreadLocal();
    protected final ThreadLocal<Calendar> localCalendar = new ThreadLocal();
    protected final ThreadLocal<DateTimeZone> localTz = new ThreadLocal();
    protected Date typeDate = new Date();
    protected DateOnly typeDateOnly = new DateOnly();
    protected DatetimeNoTz typeDatetimeNoTz = new DatetimeNoTz();
    protected Boolean booleanMeaning = new Boolean();
    protected Map<QueryUtils.OperatorType, QueryUtils.AbstractOperator> operators = new EnumMap<QueryUtils.OperatorType, QueryUtils.AbstractOperator>(QueryUtils.OperatorType.class);
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.generic");

    protected void ensureThreadLocalsAreHere() {
        if (this.utcCalendar.get() == null) {
            this.utcCalendar.set(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        }
        if (this.localCalendar.get() == null) {
            this.localCalendar.set(Calendar.getInstance(TimeZone.getDefault()));
        }
        if (this.localTz.get() == null) {
            this.localTz.set(DateTimeZone.getDefault());
        }
    }

    public GenericSQLDialect() {
        this.initOperators();
        this.addDerivedOperators();
    }

    protected DSSTypeSQLMapping getSQLType(Type type, int stringMaxLength, String expressionToCast) {
        SchemaColumn sc = new SchemaColumn(expressionToCast, type);
        sc.maxLength = stringMaxLength;
        return this.getSQLType(sc, null);
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, -6, "tinyint", new Integer[0]);
            }
            case SMALLINT: {
                return new DSSTypeSQLMapping(Type.SMALLINT, 5, "smallint", new Integer[0]);
            }
            case INT: {
                return new DSSTypeSQLMapping(Type.INT, 4, "integer", new Integer[0]);
            }
            case BIGINT: {
                return new DSSTypeSQLMapping(Type.BIGINT, -5, "bigint", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 6, "float", new Integer[]{7, 2});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "double", new Integer[]{7, 2, 3});
            }
            case STRING: {
                if (schemaColumn.getMaxLength() == -1) {
                    this.throwUnsupportedUnlimitedStringLength(schemaColumn.getName(), dataset);
                }
                return new DSSTypeSQLMapping(Type.STRING, 12, "varchar(" + schemaColumn.getMaxLength() + ")", new Integer[]{2003, 1, 1111, -16, -1, -9, 92});
            }
            case BOOLEAN: {
                return new DSSTypeSQLMapping(Type.BOOLEAN, 16, "boolean", new Integer[]{-7});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 93, "timestamp", new Integer[]{91});
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 91, "date", new Integer[]{93});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "timestamp", new Integer[]{91});
            }
            case GEOMETRY: 
            case GEOPOINT: 
            case MAP: 
            case ARRAY: 
            case OBJECT: {
                this.throwUnhandledColumnType(schemaColumn, dataset);
            }
        }
        throw new Error("unreachable");
    }

    protected void throwUnsupportedUnlimitedStringLength(String columnName, Dataset dataset) {
        this.throwErrorWithColumnInfo(String.format("'%s' database does not support unlimited string length columns", this.getId()), columnName, dataset);
    }

    protected void throwUnhandledColumnType(SchemaColumn schemaColumn, Dataset dataset) {
        this.throwErrorWithColumnInfo(String.format("Can't handle column type '%s' in '%s'", schemaColumn.getType(), this.getId()), schemaColumn.getName(), dataset);
    }

    private void throwErrorWithColumnInfo(String errorMessage, String columnName, @Nullable Dataset dataset) {
        StringBuilder result = new StringBuilder(errorMessage).append(": see column '").append(columnName).append("'");
        if (dataset != null) {
            result.append(" from dataset '").append(dataset.getFullName()).append("'.");
        }
        throw ErrorContext.iae((String)result.toString());
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        switch (sqlType) {
            case -5: {
                return new SchemaColumn(name, Type.BIGINT);
            }
            case -7: 
            case 16: {
                return new SchemaColumn(name, Type.BOOLEAN);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                SchemaColumn ret = new SchemaColumn(name, Type.STRING);
                if (sqlPrecision > 0 && sqlPrecision < Integer.MAX_VALUE) {
                    ret.maxLength = sqlPrecision;
                }
                return ret;
            }
            case 0: {
                return new SchemaColumn(name, Type.STRING);
            }
            case 8: {
                return new SchemaColumn(name, Type.DOUBLE);
            }
            case 6: 
            case 7: {
                return new SchemaColumn(name, Type.FLOAT);
            }
            case 4: {
                return new SchemaColumn(name, Type.INT);
            }
            case 5: {
                return new SchemaColumn(name, Type.SMALLINT);
            }
            case -6: {
                return new SchemaColumn(name, Type.TINYINT);
            }
            case 91: {
                if (dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                    return new SchemaColumn(name, Type.DATE).withTimestampNoTzAsDate(true);
                }
                if (dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                    return new SchemaColumn(name, Type.STRING);
                }
                return new SchemaColumn(name, Type.DATEONLY);
            }
            case 93: {
                if (this.lacksTimezoneInfo(sqlTypeName, sqlPrecision)) {
                    if (datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                        return new SchemaColumn(name, Type.DATE).withTimestampNoTzAsDate(true);
                    }
                    if (datetimenotzReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                        return new SchemaColumn(name, Type.STRING);
                    }
                    return new SchemaColumn(name, Type.DATETIMENOTZ);
                }
                return new SchemaColumn(name, Type.DATE);
            }
            case 2014: {
                return new SchemaColumn(name, Type.DATE);
            }
            case 2: 
            case 3: {
                return new SchemaColumn(name, Type.DOUBLE);
            }
            case 92: {
                return new SchemaColumn(name, Type.STRING);
            }
            case 100: {
                return new SchemaColumn(name, Type.FLOAT);
            }
            case 101: {
                return new SchemaColumn(name, Type.DOUBLE);
            }
            case -102: 
            case -101: {
                return new SchemaColumn(name, Type.DATE);
            }
            case -155: {
                return new SchemaColumn(name, Type.DATE);
            }
        }
        return new SchemaColumn(name, Type.STRING);
    }

    @Override
    public boolean supportsCommitAndRollback() {
        return true;
    }

    @Override
    public boolean supportsTransactionalDdl() {
        return false;
    }

    @Override
    public String getQuotedTableFullName(String catalog, String schema, String table) {
        return this.getTableFullName(Optional.ofNullable(catalog).filter(StringUtils::isNotBlank).map(this::quoteIdentifier).orElse(null), Optional.ofNullable(schema).filter(StringUtils::isNotBlank).map(this::quoteIdentifier).orElse(null), Optional.ofNullable(table).filter(StringUtils::isNotBlank).map(this::quoteIdentifier).orElse(null));
    }

    @Override
    public String getQuotedColumnFullName(String catalog, String schema, String table, String columnName) {
        return this.getQuotedTableFullName(catalog, schema, table) + "." + this.quoteIdentifier(columnName);
    }

    protected String getTableFullName(String catalog, String schema, String table) {
        if (StringUtils.isBlank((String)catalog)) {
            if (StringUtils.isBlank((String)schema)) {
                return table;
            }
            return schema + "." + table;
        }
        if (StringUtils.isBlank((String)schema)) {
            throw new IllegalArgumentException("schema cannot be empty when catalog is present");
        }
        return catalog + "." + schema + "." + table;
    }

    @Override
    public String getQuotedTableFullName(SQLUtils.SQLTable table) {
        return this.getQuotedTableFullName(table.getCatalog(), table.getSchemaNullIfBlank(), table.getTable());
    }

    @Override
    public String getInsertIntoInstruction(String catalog, String schema, String tableName, Schema tableSchema) {
        return "INSERT INTO  " + this.getQuotedTableFullName(catalog, schema, tableName);
    }

    @Override
    public String getCreateViewInstruction(String catalog, String schema, String tableName) {
        return "CREATE VIEW " + this.getQuotedTableFullName(catalog, schema, tableName) + " AS ";
    }

    @Override
    public String getDropViewInstruction(String catalog, String schema, String tableName) {
        return "DROP VIEW " + this.getQuotedTableFullName(catalog, schema, tableName);
    }

    @Override
    public boolean supportsDirectSchemaRetrieval() {
        return false;
    }

    @Override
    public boolean requireDirectSchemaRetrieval(ResultSetMetaData resultSetMetaData) throws SQLException {
        return false;
    }

    @Override
    public Schema directRetrieveSchema(ResultSetMetaData resultSetMetaData, SchemaOptions options) throws IOException {
        return null;
    }

    @Override
    public Schema directRetrieveSchema(AuthCtx authCtx, AbstractSQLConnection conn, String catalog, String schema, String table, SchemaOptions options) throws IOException, DKUSecurityException, SQLException {
        throw new UnsupportedOperationException("Direct schema retrieval is not available for this database");
    }

    @Override
    public Schema directRetrieveSchema(AuthCtx authCtx, AbstractSQLConnection conn, String query, SchemaOptions options) throws IOException, DKUSecurityException, SQLException {
        throw new UnsupportedOperationException("Direct schema retrieval is not available for this database");
    }

    String getSchemaConditionForListingViews(String schema, String schemaColumn, String nullCondition) {
        return StringUtils.isBlank((String)schema) ? nullCondition : String.format(" AND %s = '%s'", schemaColumn, schema);
    }

    @Override
    public String getLeftoverPipelineViewsQuery(String schema) {
        throw new UnsupportedOperationException("SQL pipelines are not implemented for this dialect");
    }

    @Override
    public boolean tableExists(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table) throws Exception {
        return SQLUtils.checkTableExistenceWithMetadata(connData, conn, this, catalog, schema, table);
    }

    @Override
    public final List<String> getTableTypes(SQLConnectionProvider.SQLConnectionData connData, SQLDialect.GetTableTypesReason reason) {
        Params p;
        String overriden;
        if (connData != null && (overriden = (p = connData.getConnection().getDkuPropertiesAsParams()).getParam("dku.connection.tableTypes." + reason.toString(), p.getParam("dku.connection.tableTypes", null))) != null) {
            JsonArray arr = (JsonArray)JSON.parse((String)overriden, JsonArray.class);
            ArrayList<String> ret = new ArrayList<String>();
            for (int i = 0; i < arr.size(); ++i) {
                ret.add(arr.get(i).getAsString());
            }
            return ret;
        }
        return this.getTableTypesWithoutOverrides(reason);
    }

    protected List<String> getTableTypesWithoutOverrides(SQLDialect.GetTableTypesReason reason) {
        return Lists.newArrayList((Object[])new String[]{"TABLE", "VIEW", "CALC VIEW"});
    }

    protected boolean canWriteInfinityOrNaN() {
        return true;
    }

    @Override
    public void fill(PreparedStatement ps2, Type dssType, int colIdx, String dssStrVal) throws SQLException {
        switch (dssType) {
            case BIGINT: {
                ps2.setLong(colIdx, Long.parseLong(dssStrVal));
                break;
            }
            case BOOLEAN: {
                ps2.setBoolean(colIdx, this.booleanMeaning.parse(dssStrVal));
                break;
            }
            case DOUBLE: {
                Double d = Double.parseDouble(dssStrVal);
                if (d == null || (d.isInfinite() || d.isNaN()) && !this.canWriteInfinityOrNaN()) {
                    this.fillWithEmpty(ps2, null, dssType, colIdx);
                    break;
                }
                ps2.setDouble(colIdx, d);
                break;
            }
            case FLOAT: {
                Float f = Float.valueOf(Float.parseFloat(dssStrVal));
                if (f == null || (f.isInfinite() || f.isNaN()) && !this.canWriteInfinityOrNaN()) {
                    this.fillWithEmpty(ps2, null, dssType, colIdx);
                    break;
                }
                ps2.setFloat(colIdx, f.floatValue());
                break;
            }
            case INT: {
                ps2.setInt(colIdx, Integer.parseInt(dssStrVal));
                break;
            }
            case SMALLINT: {
                ps2.setShort(colIdx, Short.parseShort(dssStrVal));
                break;
            }
            case STRING: {
                ps2.setString(colIdx, dssStrVal);
                break;
            }
            case TINYINT: {
                ps2.setByte(colIdx, Byte.parseByte(dssStrVal));
                break;
            }
            case DATE: {
                long timestamp = this.dateToTimeStamp(dssStrVal);
                this.ensureThreadLocalsAreHere();
                ps2.setTimestamp(colIdx, new Timestamp(timestamp), this.utcCalendar.get());
                break;
            }
            case DATETIMENOTZ: {
                long timestamp = this.typeDatetimeNoTz.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                this.ensureThreadLocalsAreHere();
                ps2.setTimestamp(colIdx, new Timestamp(timestamp), this.utcCalendar.get());
                break;
            }
            case DATEONLY: {
                long timestamp = this.typeDateOnly.msSinceEpoch(dssStrVal);
                if (timestamp == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid date: " + dssStrVal);
                }
                this.ensureThreadLocalsAreHere();
                ps2.setDate(colIdx, new java.sql.Date(timestamp), this.utcCalendar.get());
                break;
            }
            case GEOMETRY: 
            case GEOPOINT: 
            case MAP: 
            case ARRAY: 
            case OBJECT: {
                throw new IllegalArgumentException("Cannot handle this type in SQL: " + String.valueOf(dssType));
            }
        }
    }

    @Override
    public void fillWithEmpty(PreparedStatement ps2, Dataset dataset, Type dssType, int colIdx) throws SQLException {
        SchemaColumn sc = new SchemaColumn("", dssType);
        sc.maxLength = 0;
        ps2.setNull(colIdx, this.getSQLType((SchemaColumn)sc, (Dataset)dataset).mainSQLType);
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        Type dssType = schemaColumn.getType();
        switch (sqlType) {
            case -7: 
            case 16: {
                boolean b = rs2.getBoolean(colIdx);
                if (rs2.wasNull()) {
                    return null;
                }
                return b ? "true" : "false";
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                String v = rs2.getString(colIdx);
                if (StringUtils.isNotEmpty((String)v) && normalizeDoubles && this.needsDoubleNormalization() && (dssType == Type.DOUBLE || dssType == Type.FLOAT)) {
                    return Double.valueOf(v).toString();
                }
                return v;
            }
            case 91: {
                if (dssType == Type.DATE) {
                    this.ensureThreadLocalsAreHere();
                    java.sql.Date dt = rs2.getDate(colIdx, assumedTz != null ? Calendar.getInstance(assumedTz.toTimeZone()) : this.utcCalendar.get());
                    if (dt == null) {
                        return null;
                    }
                    return DKUtils.isoFormatReadableByDateFormat((long)dt.getTime());
                }
                return rs2.getString(colIdx);
            }
            case 93: 
            case 2014: {
                if (dssType == Type.DATE) {
                    this.ensureThreadLocalsAreHere();
                    if (timestampNoTzAsDate) {
                        Timestamp ts = rs2.getTimestamp(colIdx, assumedTz != null ? Calendar.getInstance(assumedTz.toTimeZone()) : this.localCalendar.get());
                        if (ts == null) {
                            return null;
                        }
                        return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
                    }
                    Timestamp ts = rs2.getTimestamp(colIdx, this.utcCalendar.get());
                    if (ts == null) {
                        return null;
                    }
                    return DKUtils.isoFormatReadableByDateFormat((long)ts.getTime());
                }
                if (dssType == Type.DATETIMENOTZ) {
                    this.ensureThreadLocalsAreHere();
                    Timestamp ts = rs2.getTimestamp(colIdx, this.utcCalendar.get());
                    if (ts == null) {
                        return null;
                    }
                    return this.datetimenotzFormatter.print(ts.getTime());
                }
                if (dssType == Type.DATEONLY) {
                    String dt = rs2.getString(colIdx);
                    return StringUtils.isNotBlank((String)dt) && dt.length() >= 10 ? dt.substring(0, 10) : null;
                }
                return rs2.getString(colIdx);
            }
            case 2004: 
            case 2005: 
            case 2011: {
                return null;
            }
        }
        return rs2.getString(colIdx);
    }

    @Override
    public String getValueAsSQLString(Type type, String value) {
        if (type.equals((Object)Type.BOOLEAN)) {
            String string = value = java.lang.Boolean.parseBoolean(value) ? "true" : "false";
        }
        if (type.equals((Object)Type.DATE)) {
            value = DKUtils.isoFormatReadableByDateFormat((long)this.dateToTimeStamp(value));
        }
        return value;
    }

    @Override
    public long dateToTimeStamp(String date) {
        long timestamp = this.typeDate.msSinceEpoch(date);
        if (timestamp == Long.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid date: " + date);
        }
        return timestamp;
    }

    @Override
    public SQLDialect.InsertIntoCaster getInsertIntoCaster(Dataset dataset) {
        return new SQLDialect.InsertIntoCaster(){

            @Override
            public ExpressionBuilder castIfNeeded(ExpressionBuilder value, SchemaColumn output) {
                return value;
            }
        };
    }

    @Override
    public boolean lacksTimezoneInfo(String sqlTypeName, int sqlPrecision) {
        return false;
    }

    @Override
    public boolean needsDoubleNormalization() {
        return true;
    }

    @Override
    public boolean considerTypeTimestampAsDate() {
        return false;
    }

    @Override
    public String getInsertStatementSQL(String catalog, String schema, String table, List<SchemaColumn> columns) throws SQLException {
        int i = 0;
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (SchemaColumn sc : columns) {
            if (i++ != 0) {
                sb1.append(',');
                sb2.append(',');
            }
            sb1.append(this.quoteIdentifier(sc.getName()));
            sb2.append('?');
        }
        StringBuilder generatedSqlStatement = new StringBuilder();
        generatedSqlStatement.append("INSERT INTO ").append(this.getQuotedTableFullName(catalog, schema, table)).append("(").append(sb1.toString()).append(") VALUES (").append(sb2.toString()).append(")");
        return generatedSqlStatement.toString();
    }

    protected String getCreateTableFieldsSQL(Dataset dataset, InfoMessage.InfoMessages messages) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (SchemaColumn col : dataset.getSchema().getColumns()) {
            sb.append("\t").append(this.quoteIdentifier(col.getName())).append(" ").append(this.getSQLType((SchemaColumn)col, (Dataset)dataset).sqlDecl);
            if (config.writeDescriptionsAsSQLComment && this.supportsCommentsInCreateTableStatement() && StringUtils.isNotBlank((String)col.comment)) {
                sb.append(" COMMENT ").append(this.quoteDescriptionOrEmpty(this.truncateDescription(col.comment, col.getName(), false, messages)));
            }
            if (i < dataset.getSchema().getColumns().size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getCreateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        if ("custom".equals(config.tableCreationMode)) {
            String statement = config.customCreateStatement;
            return statement.replace("$DKU_CREATE_TABLE_FIELDS", this.getCreateTableFieldsSQL(dataset, messages));
        }
        return this.generateTableStatementSQL(connection, dataset, messages, ifNotExist);
    }

    @Override
    public String generateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
        StringBuilder sb = new StringBuilder();
        logger.info((Object)("Generate Table statement SQL" + this.getQuotedTableFullName(config.catalog, config.schema, config.table)));
        sb.append("CREATE TABLE " + (ifNotExist ? "IF NOT EXISTS " : "") + this.getQuotedTableFullName(config.catalog, config.schema, config.table) + " (\n");
        sb.append(this.getCreateTableFieldsSQL(dataset, messages));
        sb.append(")");
        return sb.toString();
    }

    public void tryDeleteTable(SQLConnectionProvider.SQLConnectionWrapper conn, String catalog, String schema, String table) throws SQLException {
        block2: {
            try {
                SQLUtils.safeExec(conn, "DROP TABLE " + this.getQuotedTableFullName(catalog, schema, table));
            }
            catch (SQLException e) {
                logger.info((Object)("Drop table failed, table probably did not exist: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                if (!this.supportsCommitAndRollback()) break block2;
                conn.rollback();
            }
        }
    }

    @Override
    public void tryAddCommentToTable(SQLConnectionProvider.SQLConnectionWrapper conn, AbstractSQLDatasetHandler.AbstractSQLConfig config, String description, InfoMessage.InfoMessages messages) {
        if (!this.supportsWriteSQLComment()) {
            logger.warn((Object)("The " + String.valueOf((Object)conn.getConnectionData().getType()) + "connection does not support the synchronization of the dataset description into the database."));
            return;
        }
        try {
            SQLUtils.safeExec(conn, this.generateTableCommentStatementQuery(config, description, messages), true);
            logger.infoV("Successfully added COMMENT SQL to table %s: ", new Object[]{config.table});
            if (this.supportsCommitAndRollback()) {
                conn.commit();
            }
        }
        catch (UnsupportedOperationException e) {
            logger.warn((Object)"Adding comments to table not supported for this database", (Throwable)e);
        }
        catch (SQLException e) {
            logger.info((Object)"Add COMMENT SQL statement failed", (Throwable)e);
            if (this.supportsCommitAndRollback()) {
                try {
                    conn.rollback();
                }
                catch (Exception e2) {
                    logger.warn((Object)"Error during rollback", (Throwable)e2);
                }
            }
            messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)SQLCodes.ERR_SQL_CANNOT_SYNC_TABLE_DESC, (String)("Cannot synchronize dataset description to SQL database. " + ExceptionUtils.getMessageWithCauses((Throwable)e))));
        }
    }

    @Override
    public void tryWriteColumnComments(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionWrapper conn, AbstractSQLDatasetHandler.AbstractSQLConfig config, List<SchemaColumn> columns, String projectKey, InfoMessage.InfoMessages messages) {
        if (!this.supportsWriteSQLComment()) {
            logger.warnV("%s does not support the synchronization of column descriptions into the database.", new Object[]{this.getClass().getSimpleName()});
            messages.withWarning((InfoMessage.MessageCode)InfoMessage.GenericCodes.ERR_UNKNOWN, "This connection type does not support the synchronization of column descriptions into the database.");
            return;
        }
        if (columns.isEmpty()) {
            return;
        }
        boolean supportsBatchUpdates = false;
        try {
            supportsBatchUpdates = conn.getMetaData().supportsBatchUpdates();
        }
        catch (SQLException e) {
            logger.warnV("tryWriteColumnComments: Error while retrieving batch update support: %s" + ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
        }
        if (supportsBatchUpdates) {
            logger.info((Object)"tryWriteColumnComments: Executing queries in a batch");
            this.executeAddCommentsToColumnsQueryInBatch(conn, config, columns, messages);
        } else {
            int queryCount = 0;
            logger.info((Object)"tryWriteColumnComments: Executing queries one by one");
            for (SchemaColumn column : columns) {
                this.executeAddCommentsToColumnsQuery(conn, this.generateColumnCommentStatementQuery(config, column, messages), messages);
                ++queryCount;
            }
            logger.infoV("tryWriteColumnComments: Updated %d columns", new Object[]{queryCount});
        }
    }

    protected void executeAddCommentsToColumnsQuery(SQLConnectionProvider.SQLConnectionWrapper conn, String query, InfoMessage.InfoMessages messages) {
        try {
            SQLUtils.safeExec(conn, query, true);
            if (this.supportsCommitAndRollback()) {
                conn.commit();
            }
        }
        catch (UnsupportedOperationException e) {
            logger.warn((Object)"Adding comments to column not supported for this database", (Throwable)e);
        }
        catch (SQLException e) {
            logger.warn((Object)"Add SQL comment statement failed", (Throwable)e);
            if (this.supportsCommitAndRollback()) {
                try {
                    conn.rollback();
                }
                catch (Exception rollbackException) {
                    logger.warn((Object)"Error during rollback", (Throwable)rollbackException);
                }
            }
            messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)SQLCodes.ERR_SQL_CANNOT_SYNC_COLUMN_DESC, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    private void executeAddCommentsToColumnsQueryInBatch(SQLConnectionProvider.SQLConnectionWrapper conn, AbstractSQLDatasetHandler.AbstractSQLConfig config, List<SchemaColumn> columns, InfoMessage.InfoMessages messages) {
        try {
            Statement statement = conn.createStatement();
            int queryCount = 0;
            for (SchemaColumn column : columns) {
                String sql = this.generateColumnCommentStatementQuery(config, column, messages);
                logger.infoV("Batching query: %s", new Object[]{sql});
                statement.addBatch(sql);
                ++queryCount;
            }
            statement.executeBatch();
            if (this.supportsCommitAndRollback()) {
                conn.commit();
            }
            logger.infoV("tryWriteColumnComments: batch executed with success, columns updated: %d", new Object[]{queryCount});
        }
        catch (BatchUpdateException be) {
            int successCount = 0;
            for (SQLException batchUpdateException = be; batchUpdateException != null; batchUpdateException = batchUpdateException.getNextException()) {
                messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)SQLCodes.ERR_SQL_CANNOT_SYNC_COLUMN_DESC, (String)batchUpdateException.getMessage()));
            }
            for (int count : be.getUpdateCounts()) {
                if (count == -3) continue;
                ++successCount;
            }
            logger.errorV("tryWriteColumnComments: batch failed, columns updated: %d", new Object[]{successCount});
        }
        catch (SQLException e) {
            logger.warn((Object)"Add SQL comment statement failed", (Throwable)e);
            if (this.supportsCommitAndRollback()) {
                try {
                    conn.rollback();
                }
                catch (Exception rollbackException) {
                    logger.warn((Object)"Error during rollback", (Throwable)rollbackException);
                }
            }
            messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)SQLCodes.ERR_SQL_CANNOT_SYNC_COLUMN_DESC, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    protected boolean supportsCreateOrReplace() {
        return false;
    }

    protected boolean canReplaceTable(AbstractSQLDatasetHandler.AbstractSQLConfig config) {
        return this.supportsCreateOrReplace() && !"custom".equals(config.tableCreationMode);
    }

    public String getCreateOrReplaceTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages) {
        throw new IllegalStateException("You should override this method if your dialect supports CREATE OR REPLACE");
    }

    protected void updateTableStructure(SQLConnectionProvider.SQLConnectionWrapper conn, SQLConnectionProvider.SQLConnectionData connData, AbstractSQLDatasetHandler.AbstractSQLConfig config, Dataset dataset, InfoMessage.InfoMessages messages) throws SQLException {
        if (this.canReplaceTable(config)) {
            logger.info((Object)"Replacing table...");
            SQLUtils.safeSplitAndExec((SQLDialect)this, conn, this.getCreateOrReplaceTableStatementSQL(connData.getConnection(), dataset, messages), messages);
        } else {
            logger.info((Object)"Dropping table...");
            this.tryDeleteTable(conn, config.catalog, config.schema, config.table);
            logger.info((Object)"Creating table...");
            SQLUtils.safeSplitAndExec((SQLDialect)this, conn, this.getCreateTableStatementSQL(connData.getConnection(), dataset, messages, false), messages);
        }
        if (config.writeDescriptionsAsSQLComment && !this.supportsCommentsInCreateTableStatement()) {
            if (StringUtils.isNotEmpty((String)dataset.getModel().description)) {
                this.tryAddCommentToTable(conn, config, dataset.getModel().description, messages);
            }
            this.tryWriteColumnComments(null, conn, config, dataset.getSchema().getColumns(), dataset.getProjectKey(), messages);
        }
    }

    protected void dropOnMismatch(SQLConnectionProvider.SQLConnectionWrapper conn, SQLConnectionProvider.SQLConnectionData connData, AbstractSQLDatasetHandler.AbstractSQLConfig config, Dataset dataset, Exception e, InfoMessage.InfoMessages messages) throws SQLException {
        logger.info((Object)("Table already exists but with an incompatible schema: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        if (config.noDropOnSchemaMismatch) {
            throw new SQLException("Cannot write to table, table already exists but with an incompatible schema: " + e.getMessage(), e);
        }
        this.updateTableStructure(conn, connData, config, dataset, messages);
    }

    protected boolean shouldUseTruncate(SQLConnectionProvider.SQLConnectionData connData) {
        return connData.getConnection().shouldPreferTruncateTable();
    }

    protected boolean reallyNeedsDeleteBeforePartitionedWrite(SQLConnectionProvider.SQLConnectionWrapper conn, String tableFullName, Dataset dataset, Partition partition) throws SQLException {
        return true;
    }

    @Override
    public void dropIfNeededAndCreateTableOrPartition(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, Output.WriteMode mode, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        if (mode == Output.WriteMode.OVERWRITE) {
            this.dropAndRecreateTableOrPartition(authCtx, connData, conn, dataset, partition, dropPartitionedTableOnSchemaMismatch, messages);
        } else {
            this.createTableIfNeeded(authCtx, connData, conn, dataset, dropPartitionedTableOnSchemaMismatch, messages);
        }
    }

    private void createTable(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, AbstractSQLDatasetHandler.AbstractSQLConfig config, InfoMessage.InfoMessages messages) throws SQLException {
        logger.info((Object)"Creating table");
        SQLUtils.safeSplitAndExec((SQLDialect)this, conn, this.getCreateTableStatementSQL(connData.getConnection(), dataset, messages, false), messages);
        if (config.writeDescriptionsAsSQLComment && !this.supportsCommentsInCreateTableStatement()) {
            if (StringUtils.isNotEmpty((String)dataset.getModel().description)) {
                this.tryAddCommentToTable(conn, config, dataset.getModel().description, messages);
            }
            this.tryWriteColumnComments(authCtx, conn, config, dataset.getSchema().getColumns(), dataset.getProjectKey(), messages);
        }
    }

    private void clearPartitionRecords(String partitionId, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, AbstractSQLDatasetHandler.AbstractSQLConfig config, InfoMessage.InfoMessages messages) throws SQLException {
        logger.info((Object)("Deleting records for " + partitionId + " of " + dataset.getName()));
        String tableFullName = this.getQuotedTableFullName(config.catalog, config.schema, config.table);
        if (this.reallyNeedsDeleteBeforePartitionedWrite(conn, tableFullName, dataset, partition)) {
            ExpressionBuilder clause = ExpressionUtils.getPartitionFilterClause(dataset.getPartitioningSchema(), dataset, partition, (SQLDialect)this);
            String deleteSQL = "DELETE FROM " + tableFullName + " WHERE " + clause.toSQL(this);
            SQLUtils.safeExec(conn, deleteSQL, true, messages);
        }
    }

    private void clearPartitionsOrTruncate(boolean partitioned, String partitionId, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, AbstractSQLDatasetHandler.AbstractSQLConfig config, InfoMessage.InfoMessages messages) throws SQLException {
        logger.info((Object)("Table exists with compatible schema, clearing data of " + dataset.getName()));
        if (partitioned) {
            this.clearPartitionRecords(partitionId, conn, dataset, partition, config, messages);
        } else {
            String truncateSQL = "TRUNCATE TABLE " + this.getQuotedTableFullName(config.catalog, config.schema, config.table);
            SQLUtils.safeExec(conn, truncateSQL, true, messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dropAndRecreateTableOrPartition(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, Partition partition, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        if (this.shouldDelegatePrepareSqlWriteToJEK(dataset)) {
            this.delegatePrepareSqlWriteToJEK(dataset, Output.WriteMode.OVERWRITE, partition, messages);
        }
        Class<GenericSQLDialect> clazz = GenericSQLDialect.class;
        synchronized (GenericSQLDialect.class) {
            block10: {
                AbstractSQLDatasetHandler.AbstractSQLConfig config;
                block11: {
                    boolean checkSchemaCompatibility;
                    String partitionId = partition != null ? partition.id() : null;
                    config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
                    boolean useTruncate = this.shouldUseTruncate(connData);
                    boolean partitioned = dataset.getPartitioningSchema().isPartitioned() && partition != null && !partition.isAll() && !partition.isNP();
                    boolean bl = checkSchemaCompatibility = partitioned || useTruncate;
                    if (!checkSchemaCompatibility) break block11;
                    logger.info((Object)("Checking schema compatibility of " + dataset.getName()));
                    if (this.tableExists(authCtx, connData, conn, config.catalog, config.schema, config.table)) {
                        try {
                            SchemaReader.isManagedSchemaCompatible(dataset.getSchema(), dataset, conn, config.catalog, config.schema, config.table, connData);
                            this.clearPartitionsOrTruncate(partitioned, partitionId, conn, dataset, partition, config, messages);
                            if (config.writeDescriptionsAsSQLComment && !partitioned) {
                                this.tryAddCommentToTable(conn, config, dataset.getModel().description, messages);
                            }
                            break block10;
                        }
                        catch (SchemaMismatchException e) {
                            if (partitioned && dropPartitionedTableOnSchemaMismatch && config.noDropOnSchemaMismatch) {
                                throw new SQLException("Cannot write to partition " + partitionId + ". Table already exists with an incompatible schema, but the dataset forbids dropping and recreating the table: " + e.getMessage(), e);
                            }
                            if (partitioned) {
                                if (!dropPartitionedTableOnSchemaMismatch) throw new SQLException("Cannot write to partition " + partitionId + ", table already exists but with an incompatible schema: " + e.getMessage(), e);
                            }
                            this.updateTableStructure(conn, connData, config, dataset, messages);
                        }
                        break block10;
                    } else {
                        this.createTable(authCtx, connData, conn, dataset, config, messages);
                    }
                    break block10;
                }
                this.updateTableStructure(conn, connData, config, dataset, messages);
            }
            if (!this.supportsCommitAndRollback()) return;
            conn.commit();
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    protected void delegatePrepareSqlWriteToJEK(Dataset dataset, Output.WriteMode writeMode, Partition partition, InfoMessage.InfoMessages messages) throws IOException {
        logger.info((Object)"Calling JEK to prepare sql table for write");
        try (TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();){
            InfoMessage.InfoMessages jekMessages = (InfoMessage.InfoMessages)apiClient.postFormToJSON("/tintercom/datasets/prepare-sql-table-for-write", InfoMessage.InfoMessages.class, new Object[]{"projectKey", dataset.getProjectKey(), "writeMode", writeMode, "partition", partition != null ? partition.id() : null, "datasetName", dataset.getName()});
            messages.mergeFrom(jekMessages);
        }
    }

    protected boolean shouldDelegatePrepareSqlWriteToJEK(Dataset dataset) {
        boolean partitioned = dataset.getPartitioningSchema().isPartitioned();
        return DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.CDE && partitioned;
    }

    @Override
    public void dropTable(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, SQLUtils.SQLTable table) throws Exception {
        try {
            SQLUtils.safeExec(conn, "DROP TABLE " + this.getQuotedTableFullName(table));
            if (this.supportsCommitAndRollback()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            if (this.supportsCommitAndRollback()) {
                try {
                    conn.rollback();
                }
                catch (Exception e2) {
                    logger.warn((Object)"Error during rollback", (Throwable)e2);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTableIfNeeded(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, Dataset dataset, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        if (this.shouldDelegatePrepareSqlWriteToJEK(dataset)) {
            this.delegatePrepareSqlWriteToJEK(dataset, Output.WriteMode.APPEND, null, messages);
        }
        boolean partitioned = dataset.getPartitioningSchema().isPartitioned();
        Class<GenericSQLDialect> clazz = GenericSQLDialect.class;
        synchronized (GenericSQLDialect.class) {
            AbstractSQLDatasetHandler.AbstractSQLConfig config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
            if (this.tableExists(authCtx, connData, conn, config.catalog, config.schema, config.table)) {
                try {
                    SchemaReader.isManagedSchemaCompatible(dataset.getSchema(), dataset, conn, config.catalog, config.schema, config.table, connData);
                }
                catch (SchemaMismatchException e) {
                    if (dropPartitionedTableOnSchemaMismatch && partitioned) {
                        this.dropOnMismatch(conn, connData, config, dataset, e, messages);
                    }
                    if (partitioned) {
                        throw new SQLException("Cannot write table" + config.table + ", table already exists but with an incompatible schema: " + e.getMessage(), e);
                    }
                    this.dropOnMismatch(conn, connData, config, dataset, e, messages);
                }
                if (config.writeDescriptionsAsSQLComment && !partitioned) {
                    this.tryAddCommentToTable(conn, config, dataset.getModel().description, messages);
                    this.tryWriteColumnComments(authCtx, conn, config, dataset.getSchema().getColumns(), dataset.getProjectKey(), messages);
                }
            } else {
                this.createTable(authCtx, connData, conn, dataset, config, messages);
            }
            if (this.supportsCommitAndRollback()) {
                conn.commit();
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void prepareTableForWriting(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connectionData, SQLConnectionProvider.SQLConnectionWrapper connection, Output.WriteMode writeMode, Dataset dataset, Partition partition, boolean dropPartitionedTableOnSchemaMismatch, InfoMessage.InfoMessages messages) throws Exception {
        if (writeMode == Output.WriteMode.OVERWRITE) {
            this.dropAndRecreateTableOrPartition(authCtx, connectionData, connection, dataset, partition, dropPartitionedTableOnSchemaMismatch, messages);
        } else {
            this.createTableIfNeeded(authCtx, connectionData, connection, dataset, dropPartitionedTableOnSchemaMismatch, messages);
        }
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return query;
    }

    @Override
    public String getLimitedQuery(String query, long size, long offset) {
        return query;
    }

    protected String getLimitedQueryUsingLimit(String query, long size) {
        return this.getLimitedQueryUsingLimitFromLimitString(query, String.valueOf(size));
    }

    protected String getLimitedQueryUsingLimit(String query, long size, long offset) {
        return this.getLimitedQueryUsingLimitFromLimitString(query, offset + "," + size);
    }

    protected String getLimitedQueryUsingLimitFromLimitString(String query, String limitString) {
        String trimmedQuery = query.trim();
        if (Pattern.compile("limit [0-9]").matcher(trimmedQuery.toLowerCase(Locale.ROOT).replaceAll("[^A-z0-9-_.]", " ")).find()) {
            return trimmedQuery;
        }
        if (GenericSQLDialect.sqlWithoutComment(trimmedQuery.toLowerCase(Locale.ROOT)).startsWith("select")) {
            if (trimmedQuery.endsWith(";")) {
                return trimmedQuery.substring(0, trimmedQuery.length() - 1) + "\nLIMIT " + limitString;
            }
            return trimmedQuery + "\nLIMIT " + limitString;
        }
        return trimmedQuery;
    }

    @Override
    public SQLDialect.LimitMethod getLimitMethod() {
        return SQLDialect.LimitMethod.LIMIT;
    }

    @Override
    public String limitQueryUsingWhere(long size) {
        throw new IllegalArgumentException("SQL dialect doe not support limit in WHERE clause");
    }

    @Override
    public String getRandomSampleClause(QueryAst.SampleClause sample) {
        throw new UnsupportedOperationException("Table sampling is not available for this database");
    }

    @Override
    public boolean supportsResultSetMetadataOnPreparedStatement(String sql) {
        return true;
    }

    @Override
    public String alterQueryForResultSetMetadataOnPreparedStatement(String sql) {
        return sql;
    }

    @Override
    public ResultSetMetaData getResultSetMetadataOnPreparedStatement(PreparedStatement pstmt) throws Exception {
        return pstmt.getMetaData();
    }

    @Override
    public String extractStatistics(ResultSet resultSet) {
        return null;
    }

    @Override
    public boolean supportsCTEs() {
        return true;
    }

    @Override
    public boolean requiresColumnNamesInCTEs() {
        return true;
    }

    @Override
    public boolean requiresStrictTypeComparison() {
        return false;
    }

    @Override
    public boolean supportsWindowUnboundedFrame() {
        return true;
    }

    @Override
    public boolean supportsWindowCurrentRowFrame() {
        return true;
    }

    @Override
    public boolean supportsWindowTimeRangeFrame() {
        return true;
    }

    @Override
    public boolean supportsWindowNormalRangeFrame() {
        return true;
    }

    @Override
    public boolean supportsNullsOrdering() {
        return true;
    }

    @Override
    public void checkWindowForAnalyticFunction(QueryUtils.OperatorType opType, QueryAst.Window window) {
    }

    @Override
    public String datePartExpression(String inputDateExpression, DatePart part) {
        throw new NotImplementedException();
    }

    @Override
    public String dateonlyPartExpression(String inputDateExpression, DatePart part) {
        throw new NotImplementedException();
    }

    @Override
    public String datetimenotzPartExpression(String inputDateExpression, DatePart part) {
        throw new NotImplementedException();
    }

    @Override
    public String booleanRepr(java.lang.Boolean b) {
        return b != null ? b.toString() : "NULL";
    }

    @Override
    public String timeRange(String value, String unit) {
        throw new NotImplementedException("Time interval not implemented for this database");
    }

    @Override
    public String dateTrunc(String inputDateExpression, DateRounding rounding) {
        throw new NotImplementedException();
    }

    @Override
    public String dateonlyTrunc(String inputDateExpression, DateRounding rounding) {
        throw new NotImplementedException();
    }

    @Override
    public String datetimenotzTrunc(String inputDateExpression, DateRounding rounding) {
        throw new NotImplementedException();
    }

    @Override
    public boolean canExtractMilliseconds() {
        return true;
    }

    @Override
    @Deprecated
    public String convertToVarchar(String inputExpr, int len) {
        return "CAST((" + inputExpr + ") AS VARCHAR(" + len + "))";
    }

    @Override
    @Deprecated
    public String convertStringToNumber(String inputExpr) {
        return "CAST((" + inputExpr + ") AS FLOAT)";
    }

    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        Object ret = expr;
        String sqlType = this.getSQLType((Type)requestedType, (int)maxLength, (String)ret).sqlDecl.toUpperCase();
        ret = "CAST(" + (String)ret + " AS " + sqlType + ")";
        return ret;
    }

    @Override
    public String getIdentifierQuoteChar() {
        return "\"";
    }

    @Override
    public String getStringQuoteChar() {
        return "'";
    }

    @Override
    public String quoteString(String str) {
        String sep = this.getStringQuoteChar();
        str = StringEscapeUtils.escapeSql((String)str);
        if (this.needsBackslashDoubling()) {
            str = str.replace("\\", "\\\\");
        }
        return sep + str + sep;
    }

    @Override
    public String quoteDate(String str) {
        return this.quoteString(str);
    }

    @Override
    public String quoteDateOnly(String str) {
        return this.quoteString(str);
    }

    @Override
    public String quoteDatetimeNoTz(String str) {
        return this.quoteString(str);
    }

    @Override
    public boolean needsBackslashDoubling() {
        return false;
    }

    @Override
    public String captureGroup(int group) {
        return "$" + group;
    }

    @Override
    public String quoteIdentifier(String str) {
        String sep = this.getIdentifierQuoteChar();
        return sep + StringUtils.replace((String)str, (String)sep, (String)(sep + sep)) + sep;
    }

    @Override
    public String getSafeRandomTemporaryTableName(String prefix) {
        return QueryUtils.safeRandomIdentifier(prefix);
    }

    @Override
    public String createTemporaryTable(SQLUtils.SQLTable table, String columnListExpr) {
        return "CREATE TEMPORARY TABLE " + this.getQuotedTableFullName(table) + "(" + columnListExpr + ")";
    }

    @Override
    public String[] createTemporaryTableAs(SQLUtils.SQLTable table, String selectExpr) {
        return new String[]{"CREATE TEMPORARY TABLE " + this.getQuotedTableFullName(table) + " AS " + selectExpr};
    }

    @Override
    public String dropTemporaryTable(SQLUtils.SQLTable table) {
        return "DROP TABLE " + this.getQuotedTableFullName(table);
    }

    @Override
    public boolean needsTruncateBeforeDropTemporaryTable() {
        return false;
    }

    @Override
    public boolean supportsIndexing() {
        return true;
    }

    @Override
    public boolean supportsIndexingOnTemporaryTables() {
        return this.supportsIndexing();
    }

    @Override
    public String useUTCTimezone() {
        return "";
    }

    @Override
    public boolean hasCaseInsensitiveComparisons() {
        return false;
    }

    @Override
    public String cleanupColumnName(String columnName) {
        return SchemaUtils.cleanupColumnName(columnName);
    }

    @Override
    public boolean hasCaseInsensitiveColumns() {
        return false;
    }

    @Override
    public void failIfInvalidColumnIdentifier(String identifier) {
        if (StringUtils.isBlank((String)identifier)) {
            throw new IllegalArgumentException("Column name cannot be empty");
        }
    }

    @Override
    public boolean isCatalogAware() {
        return false;
    }

    @Override
    public boolean isSchemaAware() {
        return true;
    }

    @Override
    public void executePostConnectTasks(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException {
    }

    @Override
    public SQLDialect.DefaultUnquotedCase getDefaultUnquotedCaseForTables() {
        return SQLDialect.DefaultUnquotedCase.LOWER;
    }

    @Override
    public void setDefaultLengthForSchemaColumn(Schema schema, List<SchemaColumn> keyColumns, InfoMessage.InfoMessages messages) {
        for (SchemaColumn column : schema.getColumns()) {
            if (column.getType() != Type.STRING || column.maxLength != -1) continue;
            column.maxLength = this.getDefaultVarcharLen();
        }
    }

    @Override
    public int getDefaultVarcharLen() {
        return this.getMaxPossibleVarcharLen();
    }

    @Override
    public boolean canSQL99() {
        return true;
    }

    @Override
    public boolean canStddevAsAnalyticalFunctions() {
        return true;
    }

    @Override
    public boolean supportsNamedWindows() {
        return false;
    }

    @Override
    public boolean supportsGreatest() {
        return true;
    }

    @Override
    public SQLDialect.NaturalJoinSupport getNaturalJoinSupport() {
        return SQLDialect.NaturalJoinSupport.ALL;
    }

    @Override
    public boolean isNaturalJoinImplicitlyInner() {
        return false;
    }

    protected void addOperator(QueryUtils.AbstractOperator op) {
        this.operators.put(op.type, op);
    }

    protected void removeOperator(QueryUtils.OperatorType opType) {
        this.operators.remove((Object)opType);
    }

    protected void removeOperator(QueryUtils.AbstractOperator op) {
        this.removeOperator(op.type);
    }

    @Override
    public QueryUtils.AbstractOperator getOperator(QueryUtils.OperatorType opType) {
        return this.operators.get((Object)opType);
    }

    protected void addGenericOperator(QueryUtils.OperatorType type, String name, QueryUtils.Arity arity, int priority) {
        QueryUtils.Operator op = new QueryUtils.Operator(this, type, name, arity, priority);
        this.addOperator(op);
    }

    protected void addGenericOperator(QueryUtils.OperatorType type, String name, QueryUtils.Arity arity, int priority, boolean associative) {
        QueryUtils.Operator op = new QueryUtils.Operator((SQLDialect)this, type, name, arity, priority, associative);
        this.addOperator(op);
    }

    protected void addGenericOperator(QueryUtils.OperatorType type, String name, QueryUtils.Arity arity, int priority, QueryUtils.OperatorPosition position) {
        QueryUtils.Operator op = new QueryUtils.Operator((SQLDialect)this, type, name, arity, priority, position);
        this.addOperator(op);
    }

    protected void addQueryOperator(QueryUtils.OperatorType type, String name, QueryUtils.Arity arity, int priority) {
        QueryUtils.QueryOperator op = new QueryUtils.QueryOperator(this, type, name, arity, priority);
        this.addOperator(op);
    }

    protected void addGenericFunction(QueryUtils.OperatorType type, String name, QueryUtils.Arity arity) {
        QueryUtils.Function f = new QueryUtils.Function(this, type, name, arity);
        this.addOperator(f);
    }

    @Override
    public String getDivisionClause(String numerator, String denominator) {
        Double denominatorN = DKUDoubles.tryParse((String)denominator);
        if (denominatorN != null && denominatorN != 0.0) {
            return numerator + " / " + denominator;
        }
        return numerator + " / NULLIF(" + denominator + ", 0)";
    }

    @Override
    public String getLogClause(double base, String argument) {
        return "LOG(" + base + ", " + argument + ")";
    }

    protected String getLogClauseForSingleArgumentLog(double base, String argument) {
        return this.getDivisionClause("LOG(" + argument + ")", "LOG(" + base + ")");
    }

    protected void addDerivedOperators() {
        if (this.getOperator(QueryUtils.OperatorType.REGEX_LIKE) == null && this.getOperator(QueryUtils.OperatorType.REGEXP_REPLACE) != null) {
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEX_LIKE, QueryUtils.Arity.BINARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    this.validateNumberOfParameters(args);
                    ExpressionBuilder col = new ExpressionBuilder.ExpressionBuilderFactory().expr(args[0]);
                    ExpressionBuilder colReplaced = col.regexpReplace(args[1], "");
                    return this.toSQLNoBrackets(colReplaced.length().lt((Object)col.length()).expr);
                }
            });
        }
        if (this.getOperator(QueryUtils.OperatorType.TRY_PARSE) == null && this.getOperator(QueryUtils.OperatorType.PARSE) != null && this.getOperator(QueryUtils.OperatorType.REGEX_LIKE) != null) {
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TRY_PARSE, QueryUtils.Arity.NARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    this.validateMinNumberOfParameters(args, 2);
                    Type requestedType = this.getParamAs(args[1], Type.class);
                    if (requestedType.isTemporal()) {
                        this.validateMinNumberOfParameters(args, 3);
                        String jodaFormat = this.getParamAs(args[2], String.class);
                        Locale locale = args.length > 3 ? this.getParamAs(args[3], Locale.class) : Locale.US;
                        String regex = DKUDateUtils.parsePattern((String)jodaFormat, (boolean)true).toApproximateRegex(locale);
                        ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                        return this.toSQLNoBrackets(ebf.caseWhen((Object[])new Object[]{ebf.expr((QueryAst.Expr)args[0]).castToString((int)100).lower().rlike((Object)ebf.cst((Object)regex)), ebf.expr().parse((Object[])((Object[])args)), ebf.nullValue((Type)requestedType, (int)-1)}).expr);
                    }
                    throw new NotImplementedException("try_parse as not date");
                }
            });
        }
        if (this.getOperator(QueryUtils.OperatorType.LAST_INDEX_OF) == null && this.getOperator(QueryUtils.OperatorType.INDEX_OF) != null && this.getOperator(QueryUtils.OperatorType.REVERSE_STR) != null) {
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LAST_INDEX_OF, QueryUtils.Arity.BINARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    this.validateNumberOfParameters(args);
                    ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                    ExpressionBuilder str = ebf.expr(args[0]);
                    ExpressionBuilder sub = ebf.expr(args[1]);
                    return this.toSQLNoBrackets(ebf.caseWhen((Object[])new Object[]{str.indexOf((Object[])new Object[]{sub}).lt((Object)ebf.cst((Object)Integer.valueOf((int)0))), ebf.cst((Object)Integer.valueOf((int)-1)), str.length().minus((Object[])new Object[]{str.reverse().indexOf((Object[])new Object[]{sub.reverse()})}).minus((Object[])new Object[]{sub.length().coalesce((Object)ebf.cst((Object)Integer.valueOf((int)0)))})}).expr);
                }
            });
        }
        if (this.getOperator(QueryUtils.OperatorType.COMBIN) == null && this.getOperator(QueryUtils.OperatorType.FACT) != null) {
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.COMBIN, QueryUtils.Arity.BINARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    this.validateNumberOfParameters(args);
                    ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                    ExpressionBuilder n = ebf.expr(args[0]);
                    ExpressionBuilder p = ebf.expr(args[1]);
                    ExpressionBuilder combin = n.fact().div(p.fact().time(n.minus(p).fact()));
                    return this.toSQLNoBrackets(combin.castToBigint().expr);
                }
            });
        }
        if (this.getOperator(QueryUtils.OperatorType.IS_BLANK) == null) {
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.IS_BLANK, QueryUtils.Arity.UNARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    this.validateNumberOfParameters(args);
                    ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                    ExpressionBuilder col = ebf.expr(args[0]);
                    if (args[0].outputType.dssType == Type.STRING) {
                        return this.toSQLWithBrackets(col.isnull().or((ExpressionBuilder[])new ExpressionBuilder[]{col.length().nullUnsafeEq((Object)ebf.cst((Object)Integer.valueOf((int)0)))}).expr);
                    }
                    return this.toSQLWithBrackets(col.isnull().or((ExpressionBuilder[])new ExpressionBuilder[]{col.castToString((int)100).length().nullUnsafeEq((Object)ebf.cst((Object)Integer.valueOf((int)0)))}).expr);
                }
            });
        }
        if (this.getOperator(QueryUtils.OperatorType.IS_NON_BLANK) == null && this.getOperator(QueryUtils.OperatorType.IS_BLANK) != null) {
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.IS_NON_BLANK, QueryUtils.Arity.UNARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    this.validateNumberOfParameters(args);
                    ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                    ExpressionBuilder col = ebf.expr(args[0]);
                    return "(NOT " + this.toSQLNoBrackets(col.isBlank().expr) + ")";
                }
            });
        }
        if (this.getOperator(QueryUtils.OperatorType.DEGREES) == null) {
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DEGREES, QueryUtils.Arity.UNARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    this.validateNumberOfParameters(args);
                    ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                    ExpressionBuilder col = ebf.expr(args[0]);
                    return this.toSQLWithBrackets(col.time((Object[])new Object[]{ebf.cst((Object)Double.valueOf((double)57.29577951308232))}).expr);
                }
            });
        }
        if (this.getOperator(QueryUtils.OperatorType.RADIANS) == null) {
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.RADIANS, QueryUtils.Arity.UNARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    this.validateNumberOfParameters(args);
                    ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                    ExpressionBuilder col = ebf.expr(args[0]);
                    return this.toSQLWithBrackets(col.time((Object[])new Object[]{ebf.cst((Object)Double.valueOf((double)(Math.PI / 180)))}).expr);
                }
            });
        }
    }

    protected void initOperators() {
        this.addGenericOperator(QueryUtils.OperatorType.TIMES, "*", QueryUtils.Arity.NARY, SQLPriority.TIMES.priority, true);
        this.addGenericOperator(QueryUtils.OperatorType.MOD, "%", QueryUtils.Arity.BINARY, SQLPriority.MOD.priority);
        this.addGenericOperator(QueryUtils.OperatorType.PLUS, "+", QueryUtils.Arity.NARY, SQLPriority.PLUS.priority, true);
        this.addGenericOperator(QueryUtils.OperatorType.MINUS, "-", QueryUtils.Arity.NARY, SQLPriority.PLUS.priority);
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NE, null, QueryUtils.Arity.BINARY, SQLPriority.OR.priority, false){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String a1 = this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.EQ.priority);
                String b1 = this.toSQLWithBracketsIfNeeded(args[1], SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], SQLPriority.ISNULL.priority);
                return a1 + " != " + b1 + " OR " + a2 + " IS NULL AND " + b2 + " IS NOT NULL OR " + a2 + " IS NOT NULL AND " + b2 + " IS NULL";
            }
        });
        this.addGenericOperator(QueryUtils.OperatorType.GT, ">", QueryUtils.Arity.BINARY, SQLPriority.EQ.priority);
        this.addGenericOperator(QueryUtils.OperatorType.LT, "<", QueryUtils.Arity.BINARY, SQLPriority.EQ.priority);
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.EQ, "=", QueryUtils.Arity.BINARY, SQLPriority.OR.priority, false){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String a = this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.EQ.priority);
                String b = this.toSQLWithBracketsIfNeeded(args[1], SQLPriority.EQ.priority);
                String a2 = this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.ISNULL.priority);
                String b2 = this.toSQLWithBracketsIfNeeded(args[1], SQLPriority.ISNULL.priority);
                if (args[0] instanceof QueryAst.ConstExpr || args[1] instanceof QueryAst.ConstExpr) {
                    return a + " = " + b;
                }
                return a + " = " + b + " OR " + a2 + " IS NULL AND " + b2 + " IS NULL";
            }
        });
        this.addGenericOperator(QueryUtils.OperatorType.GE, ">=", QueryUtils.Arity.BINARY, SQLPriority.EQ.priority);
        this.addGenericOperator(QueryUtils.OperatorType.LE, "<=", QueryUtils.Arity.BINARY, SQLPriority.EQ.priority);
        this.addGenericOperator(QueryUtils.OperatorType.NULL_UNSAFE_EQ, "=", QueryUtils.Arity.BINARY, SQLPriority.EQ.priority);
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.NOT, "NOT", QueryUtils.Arity.UNARY, SQLPriority.OR.priority, false){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String arg1 = this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.NOT.priority);
                String arg2 = this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.ISNULL.priority);
                return "NOT " + arg1 + " OR (" + arg2 + " IS NULL)";
            }
        });
        this.addGenericOperator(QueryUtils.OperatorType.AND, "AND", QueryUtils.Arity.NARY, SQLPriority.AND.priority, true);
        this.addGenericOperator(QueryUtils.OperatorType.ALL, "ALL", QueryUtils.Arity.BINARY, SQLPriority.OR.priority);
        this.addGenericOperator(QueryUtils.OperatorType.LIKE, "LIKE", QueryUtils.Arity.BINARY, SQLPriority.OR.priority);
        this.addGenericOperator(QueryUtils.OperatorType.OR, "OR", QueryUtils.Arity.NARY, SQLPriority.OR.priority, true);
        this.addGenericOperator(QueryUtils.OperatorType.IN, "IN", QueryUtils.Arity.BINARY, SQLPriority.OR.priority);
        this.addGenericOperator(QueryUtils.OperatorType.ANY, "ANY", QueryUtils.Arity.BINARY, SQLPriority.OR.priority);
        this.addGenericOperator(QueryUtils.OperatorType.DISTINCT, "DISTINCT", QueryUtils.Arity.UNARY, SQLPriority.DISTINCT.priority, QueryUtils.OperatorPosition.BEFORE);
        this.addGenericOperator(QueryUtils.OperatorType.ISNULL, "IS NULL", QueryUtils.Arity.UNARY, SQLPriority.ISNULL.priority, QueryUtils.OperatorPosition.AFTER);
        this.addGenericOperator(QueryUtils.OperatorType.ISNOTNULL, "IS NOT NULL", QueryUtils.Arity.UNARY, SQLPriority.ISNULL.priority, QueryUtils.OperatorPosition.AFTER);
        this.addGenericOperator(QueryUtils.OperatorType.EXISTS, "EXISTS", QueryUtils.Arity.UNARY, SQLPriority.EXISTS.priority, QueryUtils.OperatorPosition.BEFORE);
        this.addQueryOperator(QueryUtils.OperatorType.UNION, "UNION", QueryUtils.Arity.NARY, SQLPriority.UNION.priority);
        this.addQueryOperator(QueryUtils.OperatorType.UNION_ALL, "UNION ALL", QueryUtils.Arity.NARY, SQLPriority.UNION.priority);
        this.addQueryOperator(QueryUtils.OperatorType.INTER, "INTER", QueryUtils.Arity.NARY, SQLPriority.UNION.priority);
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.DIV, "/", QueryUtils.Arity.BINARY, SQLPriority.TIMES.priority, false){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return GenericSQLDialect.this.getDivisionClause(this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.TIMES.priority), this.toSQLNoBrackets(args[1]));
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.FLOAT_DIV, "/", QueryUtils.Arity.BINARY, SQLPriority.TIMES.priority, false){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                QueryAst.Expr castedArg = new ExpressionBuilder.ExpressionBuilderFactory().expr((QueryAst.Expr)args[0]).cast((Object[])new Object[]{Type.DOUBLE}).expr;
                return GenericSQLDialect.this.getDivisionClause(this.toSQLWithBracketsIfNeeded(castedArg, SQLPriority.TIMES.priority), this.toSQLNoBrackets(args[1]));
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.ABS, "ABS", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.SIGN, "SIGN", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.FLOOR, "FLOOR", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.CEIL, "CEIL", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TRUNC, "TRUNC", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.SQRT, "SQRT", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.MD5, "MD5", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.EXP, "EXP", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.LN, "LN", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.POW, "POWER", QueryUtils.Arity.BINARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ROUND, "ROUND", QueryUtils.Arity.NARY){

            @Override
            protected boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 1 || nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                QueryAst.Expr[] args2 = args;
                if (args.length == 1) {
                    args2 = new QueryAst.Expr[]{args[0], new QueryAst.ConstExpr(0)};
                }
                return super.apply(args2);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LOG, QueryUtils.Arity.NARY){

            @Override
            protected boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 1 || nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                double base = 10.0;
                String arg = this.toSQLNoBrackets(args[0]);
                if (args.length > 1) {
                    base = this.getParamAs(args[1], Double.class);
                }
                return GenericSQLDialect.this.getLogClause(base, arg);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.NULL, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs >= 0 && nArgs < 3;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                return "NULL";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.NULL_WHEN, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 4;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder col = ebf.expr(args[0]);
                ExpressionBuilder cond = ebf.expr(args[1]);
                Type outputType = this.getParamAs(args[2], Type.class);
                Integer outputMaxLength = this.getParamAs(args[3], Integer.class);
                return ebf.caseWhen(cond, ebf.nullValue(outputType, outputMaxLength), col).toSQL(this.dialect);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.COUNT, "COUNT", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.AVG, "AVG", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.MIN, "MIN", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.MAX, "MAX", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.SUM, "SUM", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_SAMP, "STDDEV", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.STDDEV_POP, "STDDEV_POP", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.VARIANCE_SAMP, "VAR_SAMP", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.VARIANCE_POP, "VAR_POP", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.COS, "COS", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.SIN, "SIN", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TAN, "TAN", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.ACOS, "ACOS", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.ASIN, "ASIN", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.ATAN, "ATAN", QueryUtils.Arity.UNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.COSH, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                QueryAst.OperatorExpr expMinuxX = new QueryAst.OperatorExpr(QueryUtils.OperatorType.EXP, new QueryAst.OperatorExpr(QueryUtils.OperatorType.TIMES, new QueryAst.ConstExpr(-1), args[0]));
                QueryAst.OperatorExpr expMinux2X = new QueryAst.OperatorExpr(QueryUtils.OperatorType.EXP, new QueryAst.OperatorExpr(QueryUtils.OperatorType.TIMES, new QueryAst.ConstExpr(-2), args[0]));
                QueryAst.OperatorExpr cosh = new QueryAst.OperatorExpr(QueryUtils.OperatorType.DIV, new QueryAst.OperatorExpr(QueryUtils.OperatorType.PLUS, new QueryAst.ConstExpr(1), expMinux2X), new QueryAst.OperatorExpr(QueryUtils.OperatorType.TIMES, new QueryAst.ConstExpr(2), expMinuxX));
                return this.toSQLWithBrackets(cosh);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SINH, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                QueryAst.OperatorExpr expMinuxX = new QueryAst.OperatorExpr(QueryUtils.OperatorType.EXP, new QueryAst.OperatorExpr(QueryUtils.OperatorType.TIMES, new QueryAst.ConstExpr(-1), args[0]));
                QueryAst.OperatorExpr expMinux2X = new QueryAst.OperatorExpr(QueryUtils.OperatorType.EXP, new QueryAst.OperatorExpr(QueryUtils.OperatorType.TIMES, new QueryAst.ConstExpr(-2), args[0]));
                QueryAst.OperatorExpr sinh = new QueryAst.OperatorExpr(QueryUtils.OperatorType.DIV, new QueryAst.OperatorExpr(QueryUtils.OperatorType.MINUS, new QueryAst.ConstExpr(1), expMinux2X), new QueryAst.OperatorExpr(QueryUtils.OperatorType.TIMES, new QueryAst.ConstExpr(2), expMinuxX));
                return this.toSQLWithBrackets(sinh);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.TANH, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                QueryAst.OperatorExpr expX = new QueryAst.OperatorExpr(QueryUtils.OperatorType.EXP, args[0]);
                QueryAst.OperatorExpr expMinuxX = new QueryAst.OperatorExpr(QueryUtils.OperatorType.EXP, new QueryAst.OperatorExpr(QueryUtils.OperatorType.TIMES, new QueryAst.ConstExpr(-1), args[0]));
                QueryAst.OperatorExpr tanh = new QueryAst.OperatorExpr(QueryUtils.OperatorType.DIV, new QueryAst.OperatorExpr(QueryUtils.OperatorType.MINUS, expX, expMinuxX), new QueryAst.OperatorExpr(QueryUtils.OperatorType.PLUS, expX, expMinuxX));
                return this.toSQLWithBrackets(tanh);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.LENGTH, "LENGTH", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.UPPER, "UPPER", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.LOWER, "LOWER", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.TRIM, "TRIM", QueryUtils.Arity.NARY);
        this.addGenericFunction(QueryUtils.OperatorType.CONCAT, "CONCAT", QueryUtils.Arity.NARY);
        this.addGenericFunction(QueryUtils.OperatorType.COALESCE, "COALESCE", QueryUtils.Arity.NARY);
        this.addGenericFunction(QueryUtils.OperatorType.GREATEST, "GREATEST", QueryUtils.Arity.NARY);
        this.addGenericFunction(QueryUtils.OperatorType.LEAST, "LEAST", QueryUtils.Arity.NARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REPLACE, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                if (args[1] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[1]).value instanceof Pattern) {
                    String pattern = ((Pattern)((QueryAst.ConstExpr)args[1]).value).pattern();
                    QueryAst.Expr replacement = args[2];
                    if (replacement instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)replacement).value instanceof String && "\\0".equals(GenericSQLDialect.this.captureGroup(0))) {
                        replacement = ebf.cst((Object)((String)((QueryAst.ConstExpr)replacement).value).replaceAll((String)"\\$(\\d+)", (String)"\\\\\\\\$1")).expr;
                    }
                    return this.toSQLNoBrackets(ebf.expr((QueryAst.Expr)args[0]).regexpReplace((Object)ebf.cst((Object)pattern), (Object)replacement).expr);
                }
                if (args[1] instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)args[1]).value instanceof String) {
                    String value = (String)((QueryAst.ConstExpr)args[1]).value;
                    if (StringUtils.isEmpty((String)value)) {
                        if (GenericSQLDialect.this.regexSupport() == SQLDialect.RegexSupport.NONE) {
                            return GenericSQLDialect.this.makeSimpleReplace(this, args);
                        }
                        return GenericSQLDialect.this.makeReplaceWhereEmpty(this, ebf, args);
                    }
                    return GenericSQLDialect.this.makeSimpleReplace(this, args);
                }
                return GenericSQLDialect.this.makeSimpleReplace(this, args);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.REGEXP_REPLACE, "REGEXP_REPLACE", QueryUtils.Arity.NARY);
        this.addGenericFunction(QueryUtils.OperatorType.REGEXP_SUBSTR, "REGEXP_SUBSTR", QueryUtils.Arity.NARY);
        this.addGenericFunction(QueryUtils.OperatorType.TRANSLATE, "TRANSLATE", QueryUtils.Arity.TERNARY);
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SUBSTR, "SUBSTR", QueryUtils.Arity.NARY){

            @Override
            protected boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 2 || nArgs == 3;
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.ORD, "ASCII", QueryUtils.Arity.UNARY);
        if (this.canSQL99()) {
            this.addGenericFunction(QueryUtils.OperatorType.RANK, "RANK", QueryUtils.Arity.NO_ARG);
            this.addGenericFunction(QueryUtils.OperatorType.DENSE_RANK, "DENSE_RANK", QueryUtils.Arity.NO_ARG);
            this.addGenericFunction(QueryUtils.OperatorType.ROW_NUMBER, "ROW_NUMBER", QueryUtils.Arity.NO_ARG);
            this.addGenericFunction(QueryUtils.OperatorType.CUME_DIST, "CUME_DIST", QueryUtils.Arity.NO_ARG);
            this.addGenericFunction(QueryUtils.OperatorType.NTILE, "NTILE", QueryUtils.Arity.UNARY);
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.UNIQUE_ID, "UNIQUE_ID", QueryUtils.Arity.NO_ARG){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    return "ROW_NUMBER() OVER (ORDER BY 1)";
                }
            });
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LAG, "LAG", QueryUtils.Arity.NARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    if (args.length > 1) {
                        long round = this.getParamAs(args[1], Number.class).longValue();
                        args[1] = new QueryAst.ConstExpr(round);
                    }
                    return super.apply(args);
                }
            });
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LEAD, "LEAD", QueryUtils.Arity.NARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    if (args.length > 1) {
                        long round = this.getParamAs(args[1], Number.class).longValue();
                        args[1] = new QueryAst.ConstExpr(round);
                    }
                    return super.apply(args);
                }
            });
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FIRST_VALUE, "FIRST_VALUE", QueryUtils.Arity.BINARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    boolean ignoreNulls;
                    this.validateNumberOfParameters(args);
                    String column = this.toSQLNoBrackets(args[0]);
                    QueryAst.ConstExpr ignoreNullsExpr = (QueryAst.ConstExpr)args[1];
                    boolean bl = ignoreNulls = ignoreNullsExpr.value == null ? false : (java.lang.Boolean)ignoreNullsExpr.value;
                    if (ignoreNulls) {
                        return "FIRST_VALUE(" + column + " IGNORE NULLS)";
                    }
                    return "FIRST_VALUE(" + column + ")";
                }
            });
            this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.LAST_VALUE, "LAST_VALUE", QueryUtils.Arity.BINARY){

                @Override
                public String apply(QueryAst.Expr[] args) {
                    boolean ignoreNulls;
                    this.validateNumberOfParameters(args);
                    String column = this.toSQLNoBrackets(args[0]);
                    QueryAst.ConstExpr ignoreNullsExpr = (QueryAst.ConstExpr)args[1];
                    boolean bl = ignoreNulls = ignoreNullsExpr.value == null ? false : (java.lang.Boolean)ignoreNullsExpr.value;
                    if (ignoreNulls) {
                        return "LAST_VALUE(" + column + " IGNORE NULLS)";
                    }
                    return "LAST_VALUE(" + column + ")";
                }
            });
        }
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CAST, "CAST", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                String requestedType;
                Type currentType;
                this.validateNumberOfParameters(args);
                Type type = currentType = args[0].outputType != null ? args[0].outputType.dssType : null;
                if (currentType == null && args[0] instanceof QueryAst.ConstExpr) {
                    Object cst = ((QueryAst.ConstExpr)args[0]).value;
                    if (cst instanceof String) {
                        if (!QuerySQLWriter.isoFormatScreener.matcher((String)cst).matches() && !QuerySQLWriter.sqlFormatScreener.matcher((String)cst).matches()) {
                            currentType = Type.STRING;
                        }
                    } else if (cst instanceof Double) {
                        currentType = Type.DOUBLE;
                    } else if (cst instanceof Float) {
                        currentType = Type.FLOAT;
                    } else if (cst instanceof Integer) {
                        currentType = Type.INT;
                    } else if (cst instanceof Long) {
                        currentType = Type.BIGINT;
                    }
                }
                if (args.length > 3 && args[3] != null) {
                    requestedType = this.getParamAs(args[3], String.class);
                    return String.format("CAST( %s AS %s)", this.toSQLNoBrackets(args[0]), requestedType);
                }
                if (args.length == 1 || args[1] == null) {
                    throw new QueryUtils.SQLGenerationException("No type specified for cast.");
                }
                requestedType = this.getCastTargetType(args[1]);
                String ret = this.toSQLNoBrackets(args[0]);
                if (currentType == null || currentType != requestedType) {
                    int maxLength = -1;
                    if (args.length > 2) {
                        maxLength = this.getParamAs(args[2], Integer.class);
                    }
                    ret = GenericSQLDialect.this.cast(ret, currentType, (Type)requestedType, maxLength);
                }
                return ret;
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CAST_BOOL_TO_COLUMN, "CAST", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new LikeEscapeOperator(QueryUtils.OperatorType.CONTAINS, false, false));
        this.addOperator(new LikeEscapeOperator(QueryUtils.OperatorType.STARTS_WITH, false, false));
        this.addOperator(new LikeEscapeOperator(QueryUtils.OperatorType.ENDS_WITH, false, false));
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.FROM_TIMEZONE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.DATEDIFF, null, QueryUtils.Arity.NARY, SQLPriority.PLUS.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                String end = this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.PLUS.priority);
                String start = this.toSQLWithBracketsIfNeeded(args[1], SQLPriority.PLUS.priority);
                return "(" + end + " - " + start + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATETRUNC, "DATETRUNC", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String dt = this.toSQLNoBrackets(args[0]);
                String unit = this.getParamAs(args[1], String.class).toUpperCase();
                Type dtType = args[0].outputType.dssType;
                if (dtType == Type.DATEONLY) {
                    return GenericSQLDialect.this.dateonlyTrunc(dt, GenericSQLDialect.this.dateRoundingFromString(unit));
                }
                if (dtType == Type.DATETIMENOTZ) {
                    return GenericSQLDialect.this.datetimenotzTrunc(dt, GenericSQLDialect.this.dateRoundingFromString(unit));
                }
                return GenericSQLDialect.this.dateTrunc(dt, GenericSQLDialect.this.dateRoundingFromString(unit));
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEONLYTRUNC, "DATEONLYTRUNC", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String dt = this.toSQLNoBrackets(args[0]);
                String unit = this.getParamAs(args[1], String.class).toUpperCase();
                return GenericSQLDialect.this.dateonlyTrunc(dt, GenericSQLDialect.this.dateRoundingFromString(unit));
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATETIMENOTZTRUNC, "DATETIMENOTZTRUNC", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String dt = this.toSQLNoBrackets(args[0]);
                String unit = this.getParamAs(args[1], String.class).toUpperCase();
                return GenericSQLDialect.this.datetimenotzTrunc(dt, GenericSQLDialect.this.dateRoundingFromString(unit));
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEPART, "DATEPART", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                DatePart part;
                this.validateNumberOfParameters(args);
                String dt = this.toSQLNoBrackets(args[0]);
                String unit = this.getParamAs(args[1], String.class).toUpperCase();
                try {
                    part = DatePart.valueOf((String)unit);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid date part: " + unit, e);
                }
                return GenericSQLDialect.this.datePartExpression(dt, part);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATEONLYPART, "DATEPART", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                DatePart part;
                this.validateNumberOfParameters(args);
                String dt = this.toSQLNoBrackets(args[0]);
                String unit = this.getParamAs(args[1], String.class).toUpperCase();
                try {
                    part = DatePart.valueOf((String)unit);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid date part: " + unit, e);
                }
                return GenericSQLDialect.this.dateonlyPartExpression(dt, part);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATETIMENOTZPART, "DATEPART", QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                DatePart part;
                this.validateNumberOfParameters(args);
                String dt = this.toSQLNoBrackets(args[0]);
                String unit = this.getParamAs(args[1], String.class).toUpperCase();
                try {
                    part = DatePart.valueOf((String)unit);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid date part: " + unit, e);
                }
                return GenericSQLDialect.this.datetimenotzPartExpression(dt, part);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.MSS_TO_EPOCH, "MSS_TO_EPOCH", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return "((" + GenericSQLDialect.this.datePartExpression(this.toSQLNoBrackets(args[0]), DatePart.SECOND_FROM_EPOCH) + ") * 1000)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.MSS_TO_DATEONLY_EPOCH, "MSS_TO_EPOCH", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return "((" + GenericSQLDialect.this.dateonlyPartExpression(this.toSQLNoBrackets(args[0]), DatePart.SECOND_FROM_EPOCH) + ") * 1000)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.MSS_TO_DATETIMENOTZ_EPOCH, "MSS_TO_EPOCH", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return "((" + GenericSQLDialect.this.datetimenotzPartExpression(this.toSQLNoBrackets(args[0]), DatePart.SECOND_FROM_EPOCH) + ") * 1000)";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, "STRING_TO_TIMESTAMPTZ", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String ret = this.toSQLNoBrackets(args[0]);
                return GenericSQLDialect.this.cast(ret, Type.STRING, Type.DATE, -1);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ISTRUE, "isTrue", QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Operator(this, QueryUtils.OperatorType.ISFALSE, "isFalse", QueryUtils.Arity.UNARY, SQLPriority.NOT.priority){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String x = this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.NOT.priority);
                return "(NOT " + x + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SET_CASE_SENSITIVITY, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 1);
                return this.toSQLWithBrackets(args[0]);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.CASE_WHEN, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 2);
                ArrayList whenThens = Lists.newArrayList();
                int i = 0;
                while (i + 1 < args.length) {
                    whenThens.add("WHEN " + this.toSQLNoBrackets(args[i]) + " THEN " + this.toSQLNoBrackets(args[i + 1]));
                    i += 2;
                }
                String whenThensPart = "CASE " + Joiner.on((String)" ").join((Iterable)whenThens);
                if (args.length % 2 == 1) {
                    return whenThensPart + " ELSE " + this.toSQLNoBrackets(args[args.length - 1]) + " END";
                }
                return whenThensPart + " END";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.SWITCH_WHEN, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateMinNumberOfParameters(args, 3);
                int numberOfParameters = args.length;
                String expressionToMatch = this.toSQLNoBrackets(args[0]);
                String parameterFormat = "%s";
                if (expressionToMatch.toString().equalsIgnoreCase("'true'") || expressionToMatch.toString().equalsIgnoreCase("'false'")) {
                    parameterFormat = "CAST(%s AS BOOLEAN)";
                }
                StringBuilder caseWhenThen = new StringBuilder();
                caseWhenThen.append("CASE ").append(String.format(parameterFormat, expressionToMatch));
                for (int parameterIndex = 1; parameterIndex < numberOfParameters - 1; parameterIndex += 2) {
                    caseWhenThen.append(" WHEN ").append(String.format(parameterFormat, this.toSQLNoBrackets(args[parameterIndex]))).append(" THEN ").append(this.toSQLNoBrackets(args[parameterIndex + 1]));
                }
                if (numberOfParameters % 2 == 0) {
                    caseWhenThen.append(" ELSE ").append(this.toSQLNoBrackets(args[numberOfParameters - 1]));
                }
                return caseWhenThen.append(" END").toString();
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ISNULLOREMPTY, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder eb = ebf.or(ebf.op(QueryUtils.OperatorType.ISNULL, args[0]), ebf.op(QueryUtils.OperatorType.EQ, args[0], ebf.cst("")));
                return "(" + eb.toSQL(this.dialect) + ")";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DEFAULT_IF_NULL_OR_EMPTY, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder eb = ebf.caseWhen(ebf.op(QueryUtils.OperatorType.ISNULLOREMPTY, args[0]), args[1], args[0]);
                return eb.toSQL(this.dialect);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.EVEN, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder even = ebf.expr(args[0]).div(ebf.cst(2.0)).ceil().time(ebf.cst(2));
                if (args[0].outputType.dssType != null && args[0].outputType.dssType.isInteger()) {
                    even = even.castToBigint();
                }
                return this.toSQLWithBrackets(even.expr);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ODD, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder col = ebf.expr(args[0]);
                ExpressionBuilder even = col.div(ebf.cst(2.0)).ceil().time(ebf.cst(2));
                ExpressionBuilder delta = ebf.caseWhen(col.ceil().castToBigint().mod(ebf.cst(2)).eq(ebf.cst(0)), ebf.cst(1), ebf.cst(-1));
                ExpressionBuilder odd = even.plus(delta);
                if (args[0].outputType.dssType != null && args[0].outputType.dssType.isInteger()) {
                    return this.toSQLNoBrackets(odd.castToBigint().expr);
                }
                return this.toSQLWithBrackets(odd.expr);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.QUOTIENT, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
                ExpressionBuilder num = ebf.expr(args[0]);
                ExpressionBuilder den = ebf.expr(args[1]);
                return this.toSQLNoBrackets(num.div((Object)den).floor().castToBigint().expr);
            }
        });
    }

    protected String generateRegExpReplace(QueryUtils.Function f, QueryAst.Expr[] args) {
        f.validateNumberOfParameters(args);
        String column = f.toSQLNoBrackets(args[0]);
        String pattern = f.toSQLNoBrackets(args[1]);
        String replacement = f.toSQLNoBrackets(args[2]);
        char caseSensitive = 'c';
        if (args.length > 3) {
            caseSensitive = f.getParamAs(args[3], java.lang.Boolean.class) != false ? (char)'i' : 'c';
        }
        return String.format("REGEXP_REPLACE(%s, %s, %s, 1, 0, '%c')", column, pattern, replacement, Character.valueOf(caseSensitive));
    }

    protected String generateRegExpSubstr(QueryUtils.Function f, QueryAst.Expr[] args) {
        return this.generateRegExpSubstr(f, args, "REGEXP_SUBSTR");
    }

    protected String generateRegExpSubstr(QueryUtils.Function f, QueryAst.Expr[] args, String opName) {
        f.validateNumberOfParameters(args);
        String column = f.toSQLNoBrackets(args[0]);
        String pattern = f.toSQLNoBrackets(args[1]);
        char caseSensitive = 'c';
        if (args.length > 2) {
            caseSensitive = f.getParamAs(args[2], java.lang.Boolean.class) != false ? (char)'i' : 'c';
        }
        return String.format("%s(%s, %s, 1, 1, '%c')", StringUtils.defaultIfBlank((String)opName, (String)"REGEXP_SUBSTR"), column, pattern, Character.valueOf(caseSensitive));
    }

    private DateRounding dateRoundingFromString(String unit) {
        switch (unit) {
            case "YEAR": {
                return DateRounding.YEAR;
            }
            case "QUARTER": {
                return DateRounding.QUARTER;
            }
            case "MONTH": {
                return DateRounding.MONTH;
            }
            case "WEEK": {
                return DateRounding.WEEK;
            }
            case "DAY": {
                return DateRounding.DAY;
            }
            case "HOUR": {
                return DateRounding.HOUR;
            }
            case "MINUTE": {
                return DateRounding.MINUTE;
            }
            case "SECOND": {
                return DateRounding.SECOND;
            }
        }
        throw new NotImplementedException("Unit " + unit + " is not handled by the conversion to sql");
    }

    protected String makeSimpleReplace(QueryUtils.AbstractOperator op, QueryAst.Expr[] args) {
        return String.format("REPLACE(%1$s, %2$s, %3$s)", op.toSQLNoBrackets(args[0]), op.toSQLNoBrackets(args[1]), op.toSQLNoBrackets(args[2]));
    }

    protected String makeReplaceWhereEmpty(QueryUtils.AbstractOperator op, ExpressionBuilder.ExpressionBuilderFactory ebf, QueryAst.Expr[] args) {
        return op.toSQLNoBrackets(ebf.expr((QueryAst.Expr)args[0]).regexpReplace((Object)ebf.cst((Object)".{0}"), (Object)args[2]).expr);
    }

    @Override
    public String applyOperator(QueryUtils.OperatorType opType, QueryAst.Expr ... vargs) {
        QueryUtils.AbstractOperator operator = this.operators.get((Object)opType);
        if (operator == null) {
            throw new QueryUtils.SQLGenerationException("SQL database does not support \"" + String.valueOf((Object)opType) + "\".");
        }
        return operator.apply(vargs);
    }

    @Override
    public boolean supportsFromTimezoneNtzOperator() {
        return false;
    }

    @Override
    public Splitter getSplitter() {
        return new Splitter(this.getSemicolonExclusionPortionFinders());
    }

    @Override
    public String getColumnExpressionForBoolean(String booleanExpression) {
        return booleanExpression;
    }

    @Override
    public boolean needsToHaveTrailingSemicolonsRemoved() {
        return true;
    }

    @Override
    public String getCreateIndexStatement(String indexName, SQLUtils.SQLTable table, String quotedFieldsList) {
        return "CREATE INDEX " + this.quoteIdentifier(indexName) + " ON " + this.getQuotedTableFullName(table) + " (" + quotedFieldsList + ")";
    }

    @Override
    public String getPartitionFilterClause(Dataset dataset, Partition partition) {
        ExpressionBuilder clause = ExpressionUtils.getPartitionFilterClause(dataset.getPartitioningSchema(), dataset, partition, (SQLDialect)this);
        return clause.toSQL(this);
    }

    @Override
    public String emptyFromClause() {
        return "";
    }

    @Override
    public Map<SQLAggregateType, SQLAggregateAbility> getAggregationAbilities() {
        HashMap abilities = Maps.newHashMap();
        abilities.put(SQLAggregateType.MIN, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.MAX, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.COUNT, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.DISTINCT, new SQLAggregateAbility(true, true, true, true));
        abilities.put(SQLAggregateType.SUM, new SQLAggregateAbility(false, false, true, true));
        abilities.put(SQLAggregateType.AVG, new SQLAggregateAbility(false, false, true, true));
        abilities.put(SQLAggregateType.STDDEV, new SQLAggregateAbility(false, false, true, true).canWindow(this.canStddevAsAnalyticalFunctions()));
        if (this.canSQL99()) {
            abilities.put(SQLAggregateType.RETRIEVE, new SQLAggregateAbility(true, true, true, true));
            abilities.put(SQLAggregateType.FIRST, new SQLAggregateAbility(true, true, true, true));
            abilities.put(SQLAggregateType.LAST, new SQLAggregateAbility(true, true, true, true));
            abilities.put(SQLAggregateType.LAG, new SQLAggregateAbility(true, true, true, true));
            abilities.put(SQLAggregateType.LEAD, new SQLAggregateAbility(true, true, true, true));
            abilities.put(SQLAggregateType.LAG_DIFF, new SQLAggregateAbility(false, true, true, true));
            abilities.put(SQLAggregateType.LEAD_DIFF, new SQLAggregateAbility(false, true, true, true));
        }
        return abilities;
    }

    public String toDateFormatPart(DKUDateUtils.FormatPatternPart part, boolean forParsing, boolean hasIsoDatePart) {
        switch (part.type) {
            case YEAR: 
            case YEAROFERA: {
                return part.shortened ? "YY" : "YYYY";
            }
            case WEEKYEAR: {
                return part.shortened ? "IY" : "IYYY";
            }
            case MONTH: {
                if (part.numeric) {
                    return "MM";
                }
                if (part.shortened) {
                    return "Mon";
                }
                return "Month";
            }
            case DAY: {
                return "DD";
            }
            case DAYOFYEAR: {
                return "DDD";
            }
            case DAYOFWEEK: {
                if (part.numeric) {
                    return hasIsoDatePart ? "ID" : "D";
                }
                if (part.shortened) {
                    return "Dy";
                }
                return "Day";
            }
            case WEEK: {
                return "IW";
            }
            case HOUR: {
                return "HH24";
            }
            case HALFDAY: {
                return "AM";
            }
            case HOUROFHALFDAY: {
                return "HH12";
            }
            case MINUTE: {
                return "MI";
            }
            case SECOND: {
                return "SS";
            }
            case MILLISECOND: {
                return "MS";
            }
            case TIMEZONE: {
                return "TZ";
            }
            case TEXT: {
                return "\"" + part.text.replace("\"", "\\\\\"") + "\"";
            }
        }
        return part.text;
    }

    public String toDateFormat(String jodaFormat, boolean forParsing) {
        DKUDateUtils.FormatPattern jodaPattern = DKUDateUtils.parsePattern((String)jodaFormat, (boolean)forParsing);
        StringBuilder sb = new StringBuilder();
        boolean hasIsoDatePart = false;
        for (DKUDateUtils.FormatPatternPart part : jodaPattern) {
            hasIsoDatePart |= part.type == DKUDateUtils.FormatPatternPartType.WEEK;
            hasIsoDatePart |= part.type == DKUDateUtils.FormatPatternPartType.WEEKYEAR;
        }
        for (DKUDateUtils.FormatPatternPart part : jodaPattern) {
            sb.append(this.toDateFormatPart(part, forParsing, hasIsoDatePart));
        }
        return sb.toString();
    }

    @Override
    public SQLCapability canFormatDate(String jodaFormat, boolean forParsing) {
        DKUDateUtils.FormatPattern jodaPattern = DKUDateUtils.parsePattern((String)jodaFormat, (boolean)forParsing);
        for (DKUDateUtils.FormatPatternPart part : jodaPattern) {
            SQLCapability capability = this.canFormatDatePart(part, forParsing);
            if (capability.capable) continue;
            return capability;
        }
        return SQLCapability.ok();
    }

    public SQLCapability canFormatDatePart(DKUDateUtils.FormatPatternPart part, boolean forParsing) {
        return SQLCapability.ok();
    }

    @Override
    public SQLDialect.RegexSupport regexSupport() {
        return SQLDialect.RegexSupport.POSIX;
    }

    @Override
    public RegexDatabaseSupport.RegexSupportStatus supportsRegExpReplaceExpressions(String pattern, String replacement) {
        return new RegexDatabaseSupport().isSupported(pattern, this.getId().toLowerCase());
    }

    @Override
    public boolean supportsNonCapturingGroups() {
        return true;
    }

    @Override
    public boolean supportsLookAroundExpressions() {
        return true;
    }

    protected Pattern getValidIdentifierPattern() {
        return validIdentifierPattern;
    }

    @Override
    public boolean isValidIdentifier(String name) {
        return this.getValidIdentifierPattern().matcher(name).matches();
    }

    protected boolean isStringType(QueryAst.Expr expression) {
        if (this.getExpressionTypeIfFixed(expression) == Type.STRING) {
            return true;
        }
        return expression instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)expression).value instanceof String;
    }

    protected Type getExpressionTypeIfFixed(QueryAst.Expr expression) {
        QueryAst.Expr type;
        if (expression.outputType.dssType != null) {
            return expression.outputType.dssType;
        }
        if (expression instanceof QueryAst.OperatorExpr && ((QueryAst.OperatorExpr)expression).op == QueryUtils.OperatorType.CAST && (type = ((QueryAst.OperatorExpr)expression).args.get(1)) instanceof QueryAst.ConstExpr && ((QueryAst.ConstExpr)type).value instanceof Type) {
            Type castedType = (Type)((QueryAst.ConstExpr)type).value;
            return castedType;
        }
        return null;
    }

    private static String sqlWithoutComment(String sql) {
        return Arrays.stream(sql.split("\n")).filter(line -> !line.trim().startsWith("--")).collect(Collectors.joining("\n"));
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return null;
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return null;
    }

    @Override
    public SQLDialect.UniqueConstraintWriter getUniqueConstraintWriter() {
        return null;
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableFromSchemaMaterializedTemporaryTableWriter(this);
    }

    @Override
    public boolean canInsertAndSelectConcurrently() {
        return true;
    }

    @Override
    public String generateTableCommentStatementQuery(AbstractSQLDatasetHandler.AbstractSQLConfig config, String description, InfoMessage.InfoMessages messages) {
        throw new UnsupportedOperationException("Adding comments to table not supported for this database");
    }

    @Override
    public String generateColumnCommentStatementQuery(AbstractSQLDatasetHandler.AbstractSQLConfig config, SchemaColumn column, InfoMessage.InfoMessages messages) {
        throw new UnsupportedOperationException("Adding comments to column not supported for this database");
    }

    protected String quoteDescriptionOrEmpty(String description) {
        return this.quoteString(StringUtils.isBlank((String)description) ? "" : description);
    }

    @Override
    public int getMaxTableCommentLengthInChars() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnCommentLengthInChars() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String truncateDescription(String description, String tableOrColumnName, boolean isTable, InfoMessage.InfoMessages messages) {
        int maxLength;
        int n = maxLength = isTable ? this.getMaxTableCommentLengthInChars() : this.getMaxColumnCommentLengthInChars();
        if (StringUtils.isBlank((String)description)) {
            return "";
        }
        if (description.length() <= maxLength) {
            return description;
        }
        messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)SQLCodes.WARN_SQL_DESC_TRUNCATED, (String)("description of " + (isTable ? "table " : "column ") + tableOrColumnName + " has been truncated from " + description.length() + " to " + maxLength + " characters")));
        return description.substring(0, maxLength - 3) + "...";
    }

    @Override
    public boolean supportsWriteSQLComment() {
        return false;
    }

    @Override
    public boolean supportsCommentsInCreateTableStatement() {
        return false;
    }

    protected static enum SQLPriority {
        PARENTHESES(1),
        TIMES(2),
        MOD(2),
        PLUS(3),
        CONCAT(3),
        EQ(4),
        LIKE(4),
        ISNULL(4),
        NOT(5),
        AND(6),
        OR(7),
        DISTINCT(7),
        EXISTS(7),
        UNION(7);

        int priority;

        private SQLPriority(int priority) {
            this.priority = priority;
        }
    }

    protected class LikeEscapeOperator
    extends QueryUtils.Operator {
        final ExpressionBuilder.ExpressionBuilderFactory ebf;
        final boolean forceBoolean;
        final boolean specifyEscape;
        final String escapeChar;

        LikeEscapeOperator(QueryUtils.OperatorType type, boolean forceBoolean, boolean specifyEscape) {
            this(type, forceBoolean, specifyEscape, "\\");
        }

        LikeEscapeOperator(QueryUtils.OperatorType type, boolean forceBoolean, boolean specifyEscape, String escapeChar) {
            super((SQLDialect)GenericSQLDialect.this, type, type.name(), QueryUtils.Arity.BINARY, forceBoolean ? SQLPriority.AND.priority : SQLPriority.LIKE.priority, false);
            this.ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            this.forceBoolean = forceBoolean;
            this.specifyEscape = specifyEscape;
            this.escapeChar = escapeChar;
        }

        QueryAst.Expr escapeLikeExpr(QueryAst.Expr expr) {
            return this.ebf.expr((QueryAst.Expr)expr).replace((Object)this.escapeChar, (Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)this.escapeChar, (String)this.escapeChar)).replace((Object)"%", (Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001%"}, (String)this.escapeChar)).replace((Object)"_", (Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_"}, (String)this.escapeChar)).expr;
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            this.validateNumberOfParameters(args);
            String sql = this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.LIKE.priority) + " LIKE " + GenericSQLDialect.this.getOperator(QueryUtils.OperatorType.CONCAT).apply(switch (this.type) {
                case QueryUtils.OperatorType.STARTS_WITH -> new QueryAst.Expr[]{this.escapeLikeExpr(args[1]), new QueryAst.ConstExpr("%")};
                case QueryUtils.OperatorType.ENDS_WITH -> new QueryAst.Expr[]{new QueryAst.ConstExpr("%"), this.escapeLikeExpr(args[1])};
                case QueryUtils.OperatorType.CONTAINS -> new QueryAst.Expr[]{new QueryAst.ConstExpr("%"), this.escapeLikeExpr(args[1]), new QueryAst.ConstExpr("%")};
                default -> throw new UnsupportedOperationException("Unsupported operator implementation: " + String.valueOf((Object)this.type));
            });
            if (this.specifyEscape) {
                sql = sql + " ESCAPE " + GenericSQLDialect.this.quoteString(this.escapeChar);
            }
            if (this.forceBoolean) {
                sql = sql + " AND " + this.toSQLWithBracketsIfNeeded(args[0], SQLPriority.ISNULL.priority) + " IS NOT NULL AND (" + this.toSQLNoBrackets(args[1]) + ") IS NOT NULL";
            }
            return sql;
        }
    }

    public class ParameterSwitchedFunction
    extends QueryUtils.Function {
        private final List<ParametrizedFunctionSwitch> variants;
        private QueryUtils.Function defaultFunction;

        public ParameterSwitchedFunction(QueryUtils.OperatorType operatorType) {
            super(GenericSQLDialect.this, operatorType, QueryUtils.Arity.NARY);
            this.variants = Lists.newArrayList();
        }

        public ParameterSwitchedFunction whenArgCount(int count, QueryUtils.Function function) {
            ParametrizedFunctionSwitch variant = new ParametrizedFunctionSwitch();
            variant.paramIdx = count - 1;
            variant.function = function;
            this.variants.add(variant);
            this.keepVariantsSorted();
            return this;
        }

        public ParameterSwitchedFunction whenValueAt(int paramIdx, Object value, Class<?> valueClazz, QueryUtils.Function function) {
            ParametrizedFunctionSwitch variant = new ParametrizedFunctionSwitch();
            variant.paramIdx = paramIdx;
            variant.value = value;
            variant.valueClazz = valueClazz;
            variant.function = function;
            this.variants.add(variant);
            this.keepVariantsSorted();
            return this;
        }

        public ParameterSwitchedFunction whenOtherValueAt(int paramIdx, QueryUtils.Function function) {
            ParametrizedFunctionSwitch variant = new ParametrizedFunctionSwitch();
            variant.paramIdx = paramIdx;
            variant.otherValue = true;
            variant.function = function;
            this.variants.add(variant);
            this.keepVariantsSorted();
            return this;
        }

        public ParameterSwitchedFunction whenValueAtCloseTo(int paramIdx, double value, double precision, QueryUtils.Function function) {
            ParametrizedFunctionSwitch variant = new ParametrizedFunctionSwitch();
            variant.paramIdx = paramIdx;
            variant.value = value;
            variant.valueClazz = Double.class;
            variant.precision = precision;
            variant.function = function;
            this.variants.add(variant);
            this.keepVariantsSorted();
            return this;
        }

        public ParameterSwitchedFunction otherwise(QueryUtils.Function function) {
            this.defaultFunction = function;
            return this;
        }

        private void keepVariantsSorted() {
            Collections.sort(this.variants, new Comparator<ParametrizedFunctionSwitch>(){

                @Override
                public int compare(ParametrizedFunctionSwitch a, ParametrizedFunctionSwitch b) {
                    int paramIdxCmp = a.paramIdx - b.paramIdx;
                    if (paramIdxCmp != 0) {
                        return -paramIdxCmp;
                    }
                    if (a.valueClazz != null && b.valueClazz == null) {
                        return -1;
                    }
                    if (a.valueClazz == null && b.valueClazz != null) {
                        return 1;
                    }
                    return 0;
                }
            });
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            for (ParametrizedFunctionSwitch variant : this.variants) {
                if (!variant.applies(args)) continue;
                return this.applySubFunction(variant.function, args);
            }
            return this.applySubFunction(this.defaultFunction, args);
        }

        private String applySubFunction(QueryUtils.Function function, QueryAst.Expr[] args) {
            if (function != null) {
                return function.apply(args);
            }
            throw new IllegalArgumentException("No variant for " + args.length + " arguments");
        }
    }

    private static class ParametrizedFunctionSwitch {
        public int paramIdx;
        public Object value;
        public Class<?> valueClazz;
        public Double precision;
        public java.lang.Boolean otherValue;
        public QueryUtils.Function function;

        private ParametrizedFunctionSwitch() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean applies(QueryAst.Expr[] args) {
            Object value;
            if (args.length <= this.paramIdx) return false;
            if (this.valueClazz == null) return true;
            QueryAst.Expr arg = args[this.paramIdx];
            if (!(arg instanceof QueryAst.ConstExpr)) return false;
            QueryAst.ConstExpr ce = (QueryAst.ConstExpr)arg;
            if (ce.value == null) {
                value = null;
            } else {
                if (!this.valueClazz.isAssignableFrom(ce.value.getClass())) return false;
                value = ce.value;
            }
            if (value == null && this.value == null) {
                return true;
            }
            if (value != null && value.equals(this.value)) {
                return true;
            }
            if (value == null || this.value == null || this.precision == null || !(Math.abs(((Number)value).doubleValue() - ((Number)this.value).doubleValue()) < this.precision)) return value != null && this.otherValue != null && this.otherValue != false;
            return true;
        }
    }

    public class SimpleTernaryFunction
    extends QueryUtils.Function {
        private final String expressionStart;
        private final String expressionEnd;
        private final boolean reverseOrder;

        public SimpleTernaryFunction(QueryUtils.OperatorType operatorType, String expressionStart, String expressionEnd, boolean reverseOrder) {
            super(GenericSQLDialect.this, operatorType, QueryUtils.Arity.NARY);
            this.expressionStart = expressionStart;
            this.expressionEnd = expressionEnd;
            this.reverseOrder = reverseOrder;
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            this.validateMinNumberOfParameters(args, 3);
            String param0 = this.toSQLNoBrackets(args[0]);
            String param1 = this.toSQLNoBrackets(args[1]);
            String param2 = this.toSQLNoBrackets(args[2]);
            String params = this.reverseOrder ? param2 + ", " + param1 + ", " + param0 : param0 + ", " + param1 + ", " + param2;
            return this.expressionStart + params + this.expressionEnd;
        }
    }

    public class SimpleBinaryFunction
    extends QueryUtils.Function {
        private final String expressionStart;
        private final String expressionEnd;
        private final String expressionMiddle;
        private final boolean reverseOrder;

        public SimpleBinaryFunction(QueryUtils.OperatorType operatorType, String expressionStart, boolean reverseOrder) {
            this(operatorType, expressionStart + "(", ", ", ")", reverseOrder);
        }

        public SimpleBinaryFunction(QueryUtils.OperatorType operatorType, String expressionStart, String expressionEnd, boolean reverseOrder) {
            this(operatorType, expressionStart, ", ", expressionEnd, reverseOrder);
        }

        public SimpleBinaryFunction(QueryUtils.OperatorType operatorType, String expressionStart, String expressionMiddle, String expressionEnd, boolean reverseOrder) {
            super(GenericSQLDialect.this, operatorType, QueryUtils.Arity.NARY);
            this.expressionStart = expressionStart;
            this.expressionMiddle = expressionMiddle;
            this.expressionEnd = expressionEnd;
            this.reverseOrder = reverseOrder;
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            this.validateMinNumberOfParameters(args, 2);
            String param0 = this.toSQLNoBrackets(args[0]);
            String param1 = this.toSQLNoBrackets(args[1]);
            String params = this.reverseOrder ? param1 + this.expressionMiddle + param0 : param0 + this.expressionMiddle + param1;
            return this.expressionStart + params + this.expressionEnd;
        }
    }

    public class SimpleUnaryFunction
    extends QueryUtils.Function {
        private final String expressionStart;
        private final String expressionEnd;

        public SimpleUnaryFunction(QueryUtils.OperatorType operatorType, String expressionStart) {
            this(operatorType, expressionStart + "(", ")");
        }

        public SimpleUnaryFunction(QueryUtils.OperatorType operatorType, String expressionStart, String expressionEnd) {
            super(GenericSQLDialect.this, operatorType, QueryUtils.Arity.NARY);
            this.expressionStart = expressionStart;
            this.expressionEnd = expressionEnd;
        }

        @Override
        public String apply(QueryAst.Expr[] args) {
            this.validateMinNumberOfParameters(args, 1);
            String column = this.toSQLNoBrackets(args[0]);
            return this.expressionStart + column + this.expressionEnd;
        }
    }
}

