/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.httpsse;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointMeta;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleWriter;
import com.dataiku.dip.streaming.endpoints.httpsse.HTTPSSESimplePuller;
import com.dataiku.dip.streaming.endpoints.httpsse.HTTPSSEStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;

public class HTTPSSEStreamingEndpointMeta
extends StreamingEndpointMeta {
    public static final String TYPE = "httpsse";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Class<? extends StreamingEndpoint.StreamingEndpointParams> paramsClass() {
        return HTTPSSEStreamingEndpointParams.class;
    }

    @Override
    public StreamingEndpointSimpleWriter getSimpleWriter(AuthCtx authCtx, StreamingEndpoint targetSE, ColumnFactory cf, WarningsContext warningsContext) {
        throw new Error("HTTP-SSE does not support write");
    }

    @Override
    public StreamingEndpointSimplePuller getSimplePuller(AuthCtx authCtx, StreamingEndpoint sourceSE, boolean nonConsuming) {
        return new HTTPSSESimplePuller(this.getExpandedParams(sourceSE.projectKey, sourceSE, HTTPSSEStreamingEndpointParams.class));
    }

    @Override
    public StreamingEndpoint create(StreamingEndpointService.StreamingEndpointProto proto) throws InstantiationException, IllegalAccessException {
        StreamingEndpoint se = super.create(proto);
        se.schema = new Schema();
        se.schema.addColumn("type", Type.STRING);
        se.schema.addColumn("data", Type.STRING);
        return se;
    }

    @Override
    public void fillManagedParams(StreamingEndpoint se, DSSConnection connection, String formatOptionId) {
        throw new UnsupportedOperationException("Cannot write to HTTP SSE endpoints");
    }

    @Override
    public void fillCopyParams(StreamingEndpoint se) {
    }

    @Override
    public void checkUsability(AuthCtx authCtx, StreamingEndpoint se) throws DKUSecurityException {
    }

    @Override
    public <T extends StreamingEndpoint.StreamingEndpointParams> T getExpandedParams(String projectKey, StreamingEndpoint se, Class<T> clazz) {
        HTTPSSEStreamingEndpointParams params = (HTTPSSEStreamingEndpointParams)JSON.deepCopy((Object)se.getParamsAs(HTTPSSEStreamingEndpointParams.class));
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getContext(projectKey);
        vc.add("projectKey", se.projectKey);
        vc.add("seId", se.id);
        params.url = vc.expand(params.url);
        return (T)((StreamingEndpoint.StreamingEndpointParams)clazz.cast(params));
    }
}

