/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.unifiedmonitoring.MesMonitoringStatus;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectDataQualityDTO;
import com.dataiku.dip.unifiedmonitoring.project.ProjectExecutionStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectModelStatus;
import com.dataiku.dss_gh.api.models.governance_status.GovernanceStatus;
import com.dataiku.dss_gh.api.models.governance_status.ValidationStatus;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@UIModel
public enum UnifiedMonitoringStatus {
    NO_STATUS(-1),
    HEALTHY(0),
    WARNING(1),
    ERROR(2);

    public final int severity;

    private UnifiedMonitoringStatus(int severity) {
        this.severity = severity;
    }

    public static UnifiedMonitoringStatus map(DeploymentHealth deploymentHealth) {
        if (deploymentHealth == null) {
            return NO_STATUS;
        }
        return switch (deploymentHealth) {
            default -> throw new IncompatibleClassChangeError();
            case DeploymentHealth.UNHEALTHY, DeploymentHealth.ERROR -> ERROR;
            case DeploymentHealth.WARNING, DeploymentHealth.OUT_OF_SYNC -> WARNING;
            case DeploymentHealth.HEALTHY -> HEALTHY;
            case DeploymentHealth.UNKNOWN, DeploymentHealth.DISABLED -> NO_STATUS;
        };
    }

    public static UnifiedMonitoringStatus map(InfoMessage.Severity severity) {
        return switch (severity) {
            case InfoMessage.Severity.ERROR -> ERROR;
            case InfoMessage.Severity.WARNING -> WARNING;
            default -> NO_STATUS;
        };
    }

    public static UnifiedMonitoringStatus map(MesMonitoringStatus mesMonitoringStatus) {
        if (!mesMonitoringStatus.errors.isEmpty()) {
            return ERROR;
        }
        if (!mesMonitoringStatus.warnings.isEmpty()) {
            return WARNING;
        }
        if (!mesMonitoringStatus.successes.isEmpty()) {
            return HEALTHY;
        }
        return NO_STATUS;
    }

    public static UnifiedMonitoringStatus map(ModelStatus modelStatus) {
        if (modelStatus == null || modelStatus.mesMonitoringStatuses.isEmpty()) {
            return NO_STATUS;
        }
        Set mesStatuses = modelStatus.mesMonitoringStatuses.stream().map(UnifiedMonitoringStatus::map).collect(Collectors.toSet());
        if (mesStatuses.contains((Object)ERROR)) {
            return ERROR;
        }
        if (mesStatuses.contains((Object)WARNING)) {
            return WARNING;
        }
        if (mesStatuses.contains((Object)HEALTHY)) {
            return HEALTHY;
        }
        return NO_STATUS;
    }

    public static UnifiedMonitoringStatus map(ProjectModelStatus projectModelStatus) {
        if (projectModelStatus == null || projectModelStatus.statuses.isEmpty()) {
            return NO_STATUS;
        }
        return UnifiedMonitoringStatus.worstStatus(projectModelStatus.statuses.stream().map(UnifiedMonitoringStatus::map).collect(Collectors.toSet()));
    }

    public static UnifiedMonitoringStatus map(ProjectDataQualityDTO projectDataStatus) {
        if (projectDataStatus == null || projectDataStatus.activeRules == 0 || !projectDataStatus.hasDataset) {
            return NO_STATUS;
        }
        if (projectDataStatus.errorCount > 0L) {
            return ERROR;
        }
        if (projectDataStatus.warningCount > 0L) {
            return WARNING;
        }
        if (projectDataStatus.okCount > 0L) {
            return HEALTHY;
        }
        return NO_STATUS;
    }

    public static UnifiedMonitoringStatus map(GovernanceStatus governanceStatus) {
        if (governanceStatus == null || governanceStatus.validationStatus == null) {
            return NO_STATUS;
        }
        return switch (governanceStatus.validationStatus) {
            default -> throw new IncompatibleClassChangeError();
            case ValidationStatus.APPROVED -> HEALTHY;
            case ValidationStatus.ABANDONED, ValidationStatus.IN_VALIDATION -> WARNING;
            case ValidationStatus.REJECTED, ValidationStatus.NOT_VALIDATED -> ERROR;
            case ValidationStatus.NOT_APPLICABLE -> NO_STATUS;
        };
    }

    public static UnifiedMonitoringStatus map(ProjectExecutionStatus projectExecutionStatus) {
        if (projectExecutionStatus == null || projectExecutionStatus.webappMonitoringStatus == null && projectExecutionStatus.scenarioMonitoringStatus == null) {
            return NO_STATUS;
        }
        UnifiedMonitoringStatus scenarioStatus = NO_STATUS;
        if (projectExecutionStatus.scenarioMonitoringStatus != null) {
            if (!projectExecutionStatus.scenarioMonitoringStatus.failed.isEmpty()) {
                scenarioStatus = ERROR;
            } else if (!projectExecutionStatus.scenarioMonitoringStatus.warning.isEmpty()) {
                scenarioStatus = WARNING;
            } else if (!projectExecutionStatus.scenarioMonitoringStatus.successful.isEmpty()) {
                scenarioStatus = HEALTHY;
            }
        }
        UnifiedMonitoringStatus webappStatus = NO_STATUS;
        if (projectExecutionStatus.webappMonitoringStatus != null) {
            if (!projectExecutionStatus.webappMonitoringStatus.stopped.isEmpty() || !projectExecutionStatus.webappMonitoringStatus.notReady.isEmpty()) {
                webappStatus = ERROR;
            } else if (!projectExecutionStatus.webappMonitoringStatus.ready.isEmpty()) {
                webappStatus = HEALTHY;
            }
        }
        return UnifiedMonitoringStatus.worstStatus(scenarioStatus, webappStatus);
    }

    public static UnifiedMonitoringStatus worstStatus(UnifiedMonitoringStatus ... statuses) {
        return UnifiedMonitoringStatus.worstStatus(new HashSet<UnifiedMonitoringStatus>(List.of(statuses)));
    }

    public static UnifiedMonitoringStatus worstStatus(Collection<UnifiedMonitoringStatus> statuses) {
        if (statuses.contains((Object)ERROR)) {
            return ERROR;
        }
        if (statuses.contains((Object)WARNING)) {
            return WARNING;
        }
        if (statuses.contains((Object)HEALTHY)) {
            return HEALTHY;
        }
        return NO_STATUS;
    }
}

