/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.alerting;

import com.dataiku.dip.dao.UnifiedMonitoringSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringPaths;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertConfig;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertReporter;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertRunsInfo;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertType;
import com.dataiku.dip.unifiedmonitoring.alerting.UnifiedMonitoringAlertWithRunsInfo;
import com.dataiku.dip.unifiedmonitoring.settings.UnifiedMonitoringSettingsService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.api.client.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringAlertCRUDService {
    @Autowired
    private UnifiedMonitoringSettingsService unifiedMonitoringSettingsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.alerting.crudService");

    public List<UnifiedMonitoringAlertConfig> listAlertConfigs() throws IOException {
        UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsService.get();
        return unifiedMonitoringSettings.alertConfigs;
    }

    public List<UnifiedMonitoringAlertConfig> listAlertConfigs(String infrastructureId, UnifiedMonitoringAlertType type) throws IOException {
        return this.listAlertConfigs().stream().filter(alertConfig -> Objects.equals((Object)alertConfig.type, (Object)type) && Objects.equals(infrastructureId, alertConfig.infrastructureId)).collect(Collectors.toList());
    }

    public List<UnifiedMonitoringAlertWithRunsInfo> listAlertsWithRunsInfo() throws Exception {
        ArrayList<UnifiedMonitoringAlertWithRunsInfo> resp = new ArrayList<UnifiedMonitoringAlertWithRunsInfo>();
        for (UnifiedMonitoringAlertConfig alertConfig : this.listAlertConfigs()) {
            try {
                UnifiedMonitoringAlertRunsInfo alertRunsInfo = this.getAlertRunsInfo(alertConfig.id);
                resp.add(new UnifiedMonitoringAlertWithRunsInfo(alertConfig, alertRunsInfo));
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Could not retrieve the runs info of the alert configuration %s, skipping", new Object[]{alertConfig.id});
            }
        }
        return resp;
    }

    public void createAlertConfig(AuthCtx user, UnifiedMonitoringAlertConfig alertConfig) throws Exception {
        UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsService.get();
        if (alertConfig.id == null || alertConfig.id.isEmpty()) {
            alertConfig.id = SecretKeyGenerator.generate((int)8);
        } else if (unifiedMonitoringSettings.alertConfigs.stream().anyMatch(a -> Objects.equals(a.id, alertConfig.id))) {
            throw new IllegalArgumentException("Tried to create a new alert with an existing id (" + alertConfig.id + ")");
        }
        for (UnifiedMonitoringAlertReporter reporter : alertConfig.reporters) {
            if (reporter.id == null || reporter.id.isEmpty()) {
                reporter.id = SecretKeyGenerator.generate((int)8);
                continue;
            }
            if (!alertConfig.reporters.stream().anyMatch(a -> Objects.equals(a.id, reporter.id))) continue;
            throw new IllegalArgumentException("Tried to create a new reporter with an existing id (" + reporter.id + ")");
        }
        unifiedMonitoringSettings.alertConfigs.add(alertConfig);
        this.unifiedMonitoringSettingsService.save(user, unifiedMonitoringSettings);
    }

    public void editAlertConfig(AuthCtx user, UnifiedMonitoringAlertConfig alertConfig) throws Exception {
        UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsService.get();
        UnifiedMonitoringAlertConfig existingAlert = unifiedMonitoringSettings.alertConfigs.stream().filter(a -> Objects.equals(a.id, alertConfig.id)).findAny().orElseThrow(() -> new NoSuchElementException("Could not find alert with id " + alertConfig.id));
        unifiedMonitoringSettings.alertConfigs.set(unifiedMonitoringSettings.alertConfigs.indexOf(existingAlert), alertConfig);
        this.unifiedMonitoringSettingsService.save(user, unifiedMonitoringSettings);
    }

    public void deleteAlertConfigs(AuthCtx user, List<String> alertIds) throws Exception {
        UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsService.get();
        List<UnifiedMonitoringAlertConfig> toBeDeleted = unifiedMonitoringSettings.alertConfigs.stream().filter(alert -> alertIds.contains(alert.id)).toList();
        if (toBeDeleted.isEmpty()) {
            throw new NoSuchElementException("Could not find alerts to delete.");
        }
        unifiedMonitoringSettings.alertConfigs.removeAll(toBeDeleted);
        this.unifiedMonitoringSettingsService.save(user, unifiedMonitoringSettings);
    }

    public void activateAlertConfigs(AuthCtx user, List<String> alertIds, boolean isActive) throws Exception {
        UnifiedMonitoringSettings unifiedMonitoringSettings = this.unifiedMonitoringSettingsService.get();
        List<UnifiedMonitoringAlertConfig> toSet = unifiedMonitoringSettings.alertConfigs.stream().filter(alert -> alertIds.contains(alert.id)).collect(Collectors.toList());
        if (toSet.isEmpty()) {
            throw new NoSuchElementException("Could not find alerts to (de)activate.");
        }
        toSet.forEach(alert -> {
            alert.isActive = isActive;
        });
        this.unifiedMonitoringSettingsService.save(user, unifiedMonitoringSettings);
    }

    @Nullable
    public UnifiedMonitoringAlertRunsInfo getAlertRunsInfo(String alertConfigId) throws IOException {
        Preconditions.checkNotNull((Object)alertConfigId, (Object)"The alert configuration id cannot be null.");
        File alertRunsInfoFile = UnifiedMonitoringPaths.getAlertRunsInfo(alertConfigId);
        if (alertRunsInfoFile.exists() && alertRunsInfoFile.isFile()) {
            UnifiedMonitoringAlertRunsInfo alertRunsInfo = (UnifiedMonitoringAlertRunsInfo)JSON.parseFile((File)alertRunsInfoFile, UnifiedMonitoringAlertRunsInfo.class);
            alertRunsInfo.alertConfigId = alertConfigId;
            return alertRunsInfo;
        }
        return null;
    }

    public void saveAlertRunsInfo(UnifiedMonitoringAlertRunsInfo unifiedMonitoringAlertRunsInfo) throws IOException {
        Preconditions.checkNotNull((Object)unifiedMonitoringAlertRunsInfo.alertConfigId, (Object)"The alert configuration id cannot be null.");
        File alertRunsInfoFile = UnifiedMonitoringPaths.getAlertRunsInfo(unifiedMonitoringAlertRunsInfo.alertConfigId);
        DKUFileUtils.mkdirs((File)alertRunsInfoFile.getParentFile());
        JSON.prettyToFile((Object)unifiedMonitoringAlertRunsInfo, (File)alertRunsInfoFile);
    }
}

