/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.logs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringLogsService {
    public static final String UNIFIED_MONITORING_LOG_FILE = "unified-monitoring.log";
    private final ThreadLocal<Boolean> logToUnifiedMonitoringFile = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private boolean logAppenderStarted = false;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.logs");

    private synchronized void startLogAppender() {
        if (this.logAppenderStarted) {
            return;
        }
        try {
            File logDir = this.getLogsDir();
            DKUFileUtils.mkdirs((File)logDir);
            File log = new File(logDir, UNIFIED_MONITORING_LOG_FILE);
            RollingFileAppender logFileAppender = new RollingFileAppender();
            logFileAppender.setMaximumFileSize(0xA00000L);
            logFileAppender.setMaxBackupIndex(4);
            logFileAppender.setThreshold((Priority)Level.DEBUG);
            logFileAppender.setFile(log.getAbsolutePath(), true, false, 0);
            logFileAppender.addFilter(new Filter(){

                public int decide(LoggingEvent loggingEvent) {
                    if (Boolean.TRUE.equals(UnifiedMonitoringLogsService.this.logToUnifiedMonitoringFile.get())) {
                        return 1;
                    }
                    return -1;
                }
            });
            DKUtils.startLogAppender((Appender)logFileAppender);
            this.logAppenderStarted = true;
        }
        catch (IOException e) {
            logger.error((Object)"Error while starting log appender for unified monitoring", (Throwable)e);
        }
    }

    public void startLogging() {
        this.startLogAppender();
        this.logToUnifiedMonitoringFile.set(Boolean.TRUE);
    }

    public void stopLogging() {
        this.logToUnifiedMonitoringFile.set(Boolean.FALSE);
    }

    @Nonnull
    public List<LogsService.LogDesc> listLogFiles_Check(AuthCtx authCtx) throws UnauthorizedException {
        this.checkLogsPermissions(authCtx);
        File logsDir = this.getLogsDir();
        ArrayList<LogsService.LogDesc> logs = new ArrayList<LogsService.LogDesc>();
        for (Path path : this.getAllLogFiles()) {
            logs.add(new LogsService.LogDesc(path.toFile(), logsDir));
        }
        return logs;
    }

    @Nonnull
    public SmartLogTail getLogs_Check(AuthCtx authCtx, String fileName) throws UnauthorizedException, IOException {
        this.checkLogsPermissions(authCtx);
        File logFile = this.getLogFile(fileName);
        return DKUtils.smartTailFile((File)logFile, (int)500);
    }

    public void downloadAllLogs_Check(AuthCtx authCtx, OutputStream outputStream) throws UnauthorizedException, IOException {
        this.checkLogsPermissions(authCtx);
        this.zip(this.getAllLogFiles(), outputStream);
    }

    public void downloadLogs_Check(AuthCtx authCtx, String logFileName, OutputStream outputStream) throws UnauthorizedException, IOException {
        this.checkLogsPermissions(authCtx);
        this.zip(Collections.singletonList(this.getLogFile(logFileName).toPath()), outputStream);
    }

    @Nonnull
    public File getLogsDir() {
        return DKUFileUtils.getWithin((File)new File(System.getenv("DIP_HOME"), "run"), (String[])new String[]{"unified-monitoring"});
    }

    @Nonnull
    public List<Path> getAllLogFiles() {
        File logsDir = this.getLogsDir();
        ArrayList<Path> logFiles = new ArrayList<Path>();
        try {
            EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            Files.walkFileTree(logsDir.toPath(), opts, 5, new LogsService.LogFilesVisitor(logFiles));
        }
        catch (IOException e) {
            logger.warn((Object)"Listing log files failed", (Throwable)e);
        }
        return logFiles;
    }

    @Nonnull
    public File getLogFile(String fileName) throws IOException {
        File logsDir = this.getLogsDir();
        File logFile = DKUApp.getFile((File)logsDir, (String[])new String[]{fileName});
        if (logFile.exists() && logFile.isFile()) {
            return logFile;
        }
        throw new IOException("Log file " + fileName + " doesn't exist");
    }

    private void zip(Iterable<Path> paths, OutputStream outputStream) throws IOException {
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(outputStream);){
            for (Path path : paths) {
                logger.info((Object)("Adding " + path.toString()));
                File file = path.toFile();
                LogsService.LogDesc desc = new LogsService.LogDesc(file, this.getLogsDir());
                ZipArchiveEntry ae = zos.createArchiveEntry(file, desc.name);
                zos.putArchiveEntry(ae);
                try (FileInputStream is = new FileInputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)zos);
                }
                zos.closeArchiveEntry();
            }
        }
    }

    private void checkLogsPermissions(AuthCtx authCtx) throws UnauthorizedException {
        if (!authCtx.isAdmin()) {
            throw new UnauthorizedException("Action forbidden, you are not admin", "not-admin");
        }
    }

    public static class AutoClosableLogToUnifiedMonitoring
    implements AutoCloseable {
        public AutoClosableLogToUnifiedMonitoring() {
            ((UnifiedMonitoringLogsService)SpringUtils.getBean(UnifiedMonitoringLogsService.class)).startLogging();
        }

        @Override
        public void close() throws Exception {
            ((UnifiedMonitoringLogsService)SpringUtils.getBean(UnifiedMonitoringLogsService.class)).stopLogging();
        }
    }
}

