/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.standard;

import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppTemplate;
import com.dataiku.dip.webapps.standard.AbstractStandardWebAppHandler;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;

public class StandardWebAppHandler
extends AbstractStandardWebAppHandler {
    private RelFile directory;
    static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.standard");

    public StandardWebAppHandler(WebApp webapp) {
        super(webapp);
        this.directory = new RelFile(new String[]{"projects", webapp.projectKey, "web_apps", webapp.id});
    }

    @Override
    public void readCodeFiles() {
        try {
            TransactionRef t = TransactionContext.retrieveRead();
            this.params.html = t.readStringUTF8(this.getHtmlFile());
            this.params.js = t.readStringUTF8(this.getJsFile());
            this.params.css = t.readStringUTF8(this.getStyleFile());
            if (t.isFile(this.getBackendFile())) {
                this.params.python = t.readStringUTF8(this.getBackendFile());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read web app.", e);
        }
    }

    @Override
    public void initWebApp() throws IOException {
        this.initApiKey(null);
    }

    @Override
    public void initCustomWebApp() throws IOException {
    }

    @Override
    public void initWebAppTemplate(String templateId, File templateDir) throws IOException {
        this.initApiKey(null);
        logger.info((Object)("Init webapp with template: " + templateId));
        this.params.js = FileUtils.readFileToString((File)new File(templateDir, "app.js"));
        this.params.html = FileUtils.readFileToString((File)new File(templateDir, "app.html"));
        this.params.css = FileUtils.readFileToString((File)new File(templateDir, "app.css"));
        if (new File(templateDir, "app.py").isFile()) {
            this.params.python = FileUtils.readFileToString((File)new File(templateDir, "app.py"));
        }
        StandardWebAppMeta.StandardWebAppTemplate meta = (StandardWebAppMeta.StandardWebAppTemplate)JSON.parseFile((File)new File(templateDir, "meta.json"), StandardWebAppMeta.StandardWebAppTemplate.class);
        for (String lib : meta.libraries) {
            this.params.libraries.add(WebAppTemplate.JavaScriptLibrary.valueOf(lib));
        }
        this.params.backendEnabled = meta.backendEnabled;
        this.params.autoStartBackend = meta.autoStartBackend;
    }

    @Override
    public void writeCodeFiles() throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeStringUTF8(this.getHtmlFile(), this.params.html);
        t.writeStringUTF8(this.getStyleFile(), this.params.css);
        t.writeStringUTF8(this.getJsFile(), this.params.js);
        if (this.params.python != null) {
            t.writeStringUTF8(this.getBackendFile(), this.params.python);
        }
    }

    @Override
    public void deleteCodeFiles() throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteDirectory(this.directory);
    }

    private RelFile getHtmlFile() {
        return this.directory.append(new String[]{"body.html"});
    }

    private RelFile getStyleFile() {
        return this.directory.append(new String[]{"style.css"});
    }

    private RelFile getJsFile() {
        return this.directory.append(new String[]{"app.js"});
    }

    private RelFile getBackendFile() {
        return this.directory.append(new String[]{"backend.py"});
    }
}

