/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.model.serverconfig;

import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;

@PolyJSON(value={@Mapping(value=Disabled.class, type="DISABLED"), @Mapping(value=Pull.class, type="PULL_FROM_API_NODES"), @Mapping(value=PushExplicit.class, type="PUSH_TO_DEPLOYER"), @Mapping(value=PushAuto.class, type="PUSH_TO_DEPLOYER_AUTO")}, typeProperty="mode", enumClass=Mode.class)
public abstract class ActivityMonitoringSettings {
    public Mode mode = Mode.PULL_FROM_API_NODES;

    public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
    }

    public void decryptFields(PasswordEncryptionService passwordEncryptionService) {
    }

    public static enum Mode {
        DISABLED,
        PULL_FROM_API_NODES,
        PUSH_TO_DEPLOYER,
        PUSH_TO_DEPLOYER_AUTO;

    }

    public static class PushAuto
    extends Push {
        @Override
        public PushExplicit toPushSettings() {
            PushExplicit result = new PushExplicit();
            NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
            if (!nd.enabled) {
                throw new IllegalConfigurationException("Auto Push is not supported without a nodes directory.");
            }
            NodesDirectory.NodeRef deployer = nd.getById(nd.remoteDeployerNodeId).orElse(nd.getCurrentNode());
            if (!deployer.configureDeployerServer) {
                throw new IllegalConfigurationException("Auto Push is not supported without a deployer.");
            }
            result.activityServerAPIURL = deployer.url + "/public/api/admin/monitoring/activity-metrics";
            result.apiKey = deployer.adminAPIKey;
            result.trustAllSSLCertificates = true;
            return result;
        }

        public PushAuto() {
            this.mode = Mode.PUSH_TO_DEPLOYER_AUTO;
        }
    }

    public static class PushExplicit
    extends Push {
        public String activityServerAPIURL;
        public String apiKey;
        public boolean trustAllSSLCertificates;

        public PushExplicit() {
            this.mode = Mode.PUSH_TO_DEPLOYER;
        }

        @Override
        public PushExplicit toPushSettings() {
            return this;
        }

        @Override
        public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
            this.apiKey = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(this.apiKey);
        }

        @Override
        public void decryptFields(PasswordEncryptionService passwordEncryptionService) {
            this.apiKey = passwordEncryptionService.decryptIfEncrypted(this.apiKey);
        }
    }

    public static abstract class Push
    extends ActivityMonitoringSettings {
        public abstract PushExplicit toPushSettings();
    }

    public static class Pull
    extends ActivityMonitoringSettings {
        public Pull() {
            this.mode = Mode.PULL_FROM_API_NODES;
        }
    }

    public static class Disabled
    extends ActivityMonitoringSettings {
        public Disabled() {
            this.mode = Mode.DISABLED;
        }
    }
}

