/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.model.serverconfig;

import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class GenerationsMapping {
    public String auditRoutingKey;
    public JsonObject auditMetadata = new JsonObject();
    public Strategy strategy = Strategy.RANDOM;
    private GenerationsMappingMode mode = GenerationsMappingMode.MULTI_GENERATION;
    private String generation;
    @Nonnull
    private List<MappingEntry> entries = new ArrayList<MappingEntry>();
    public String openAPIGeneration;

    @Nonnull
    public List<MappingEntry> getEntries() {
        if (this.mode == GenerationsMappingMode.SINGLE_GENERATION) {
            if (StringUtils.isNotBlank((String)this.generation)) {
                return Lists.newArrayList((Object[])new MappingEntry[]{new MappingEntry(this.generation, 1.0)});
            }
            return Lists.newArrayList();
        }
        return this.entries;
    }

    public GenerationsMappingMode getMode() {
        return this.mode;
    }

    public void setSingleGeneration(String generation) {
        this.mode = GenerationsMappingMode.SINGLE_GENERATION;
        this.generation = generation;
        this.entries = Lists.newArrayList((Object[])new MappingEntry[]{new MappingEntry(generation, 1.0)});
        this.openAPIGeneration = generation;
    }

    public String getDefaultOpenAPIGeneration() {
        if (this.isSingleGeneration()) {
            return this.generation;
        }
        return this.entries.get((int)0).generation;
    }

    @Transient
    public boolean isSingleGeneration() {
        return this.mode == GenerationsMappingMode.SINGLE_GENERATION;
    }

    @Transient
    public void validate() {
        if (this.mode == GenerationsMappingMode.MULTI_GENERATION) {
            double totalProba = 0.0;
            if (this.entries.isEmpty()) {
                throw ErrorContext.iae((String)"Invalid mapping: no mapping entries");
            }
            for (MappingEntry me : this.entries) {
                if (me.proba < 0.0) {
                    throw ErrorContext.iae((String)"Invalid mapping entry: proba < 0");
                }
                if (me.proba > 1.0) {
                    throw ErrorContext.iae((String)"Invalid mapping entry: proba > 1");
                }
                totalProba += me.proba;
                if (!StringUtils.isBlank((String)me.generation)) continue;
                throw ErrorContext.iae((String)"Invalid mapping entry: no generation");
            }
            if (Math.abs(1.0 - totalProba) > 0.001) {
                throw ErrorContext.iae((String)"Invalid mapping: sum of probas must equal 1.0");
            }
        }
    }

    @Transient
    public boolean isUsed(String generationToCheck) {
        assert (!StringUtils.isBlank((String)generationToCheck));
        switch (this.mode) {
            case SINGLE_GENERATION: {
                return Objects.equals(this.generation, generationToCheck);
            }
            case MULTI_GENERATION: {
                for (MappingEntry me : this.entries) {
                    if (!me.generation.equals(generationToCheck)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new Error("unreachable");
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + this.mode.hashCode();
        if (this.mode == GenerationsMappingMode.SINGLE_GENERATION) {
            hash = hash * 31 + (this.generation == null ? 0 : this.generation.hashCode());
        } else {
            hash = hash * 31 + this.strategy.hashCode();
            int sum = 0;
            for (MappingEntry me : this.entries) {
                sum += me.hashCode();
            }
            hash = hash * 71 + sum;
        }
        hash = hash * 101 + (this.auditRoutingKey == null ? 0 : this.auditRoutingKey.hashCode());
        return hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GenerationsMapping)) {
            return false;
        }
        GenerationsMapping other = (GenerationsMapping)o;
        if (!Objects.equals(this.auditRoutingKey, other.auditRoutingKey)) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.mode == GenerationsMappingMode.SINGLE_GENERATION) {
            return Objects.equals(this.generation, other.generation);
        }
        if (this.strategy != other.strategy) {
            return false;
        }
        if (this.entries.size() != other.entries.size()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            MappingEntry oME;
            MappingEntry me = this.entries.get(i);
            if (Objects.equals(me, oME = other.entries.get(i))) continue;
            return false;
        }
        return true;
    }

    public static enum Strategy {
        RANDOM,
        HASH_BASED;

    }

    public static enum GenerationsMappingMode {
        SINGLE_GENERATION,
        MULTI_GENERATION;

    }

    public static class MappingEntry {
        public String generation;
        public double proba;

        public MappingEntry(String generation, double proba) {
            this.generation = generation;
            this.proba = proba;
        }

        public int hashCode() {
            return (this.generation == null ? 0 : this.generation.hashCode()) * 17 + String.valueOf(this.proba).hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MappingEntry)) {
                return false;
            }
            MappingEntry other = (MappingEntry)o;
            return Objects.equals(this.generation, other.generation) && Double.compare(this.proba, other.proba) == 0;
        }
    }
}

