/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.tools;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.processes.CGroupHelper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.BackendVariablesService;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.lambda.dataload.LoadedDataMapping;
import com.dataiku.lambda.model.serverconfig.AdminAPIKey;
import com.dataiku.lambda.model.serverconfig.LambdaServerAdminAuthConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.util.Strings;

public class LambdaHomeDevBootstrapper {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.kernels.lambdadev.bootstrap");

    private LambdaHomeDevBootstrapper() {
    }

    public static void bootstrap(@Nonnull File lambdaHome, String adminApiKey, @Nonnull AuthCtx user, @Nonnull String projectKey, String targetUnixUser) throws IOException, InterruptedException, DKUSecurityException {
        logger.infoV("Bootstrapping lambda dev server home directory in %s for user %s, projectKey %s%s", new Object[]{lambdaHome.getAbsolutePath(), user.toString(), projectKey, Strings.isNotEmpty((String)targetUnixUser) ? " and target unix user " + targetUnixUser : ""});
        if (lambdaHome.isDirectory()) {
            DKUFileUtils.forceDelete((File)lambdaHome);
        }
        DKUFileUtils.mkdirs((File)lambdaHome);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(lambdaHome);
        FilesystemACLUtils.grantFSReadACLs(user, projectKey, lambdaHome);
        File configFolder = new File(lambdaHome, "config");
        DKUFileUtils.mkdirs((File)configFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(configFolder);
        DKUFileUtils.mkdirs((File)new File(lambdaHome, "services"));
        LambdaServerConfig lsc = new LambdaServerConfig();
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginRead();){
            VariablesContext vc = ((BackendVariablesService)SpringUtils.getBean(BackendVariablesService.class)).getGlobalContext();
            for (Map.Entry<String, DSSConnection> conn : ConnectionsDAO.get().list().entrySet()) {
                DSSConnection connection = conn.getValue();
                if (!connection.isFreelyUsableBy(user)) continue;
                if (connection instanceof AbstractSQLConnection) {
                    AbstractSQLConnection sqlConnection = (AbstractSQLConnection)connection;
                    AbstractSQLConnection.SQLManagedDatasetNamingRule namingRule = sqlConnection.getParams().namingRule;
                    if (StringUtils.isNotBlank((String)namingRule.catalog)) {
                        namingRule.catalog = vc.expandAllowUnresolved(namingRule.catalog);
                    }
                    if (StringUtils.isNotBlank((String)namingRule.schemaName)) {
                        namingRule.schemaName = vc.expandAllowUnresolved(namingRule.schemaName);
                    }
                }
                connection.usableBy = DSSConnection.ConnectionUsableBy.ALL;
                lsc.remappedConnections.put(conn.getKey(), connection);
            }
            logger.infoV("Added %d connection%s to the remapped connections list: [%s]", new Object[]{lsc.remappedConnections.size(), lsc.remappedConnections.size() > 1 ? "s" : "", String.join((CharSequence)", ", lsc.remappedConnections.keySet())});
            String devBConn = ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).read().lambdaDevBundledConnection;
            if (!StringUtils.isBlank((String)devBConn)) {
                DSSConnection bundledConnection = ConnectionsDAO.get().getConnection(user, devBConn);
                if (null == bundledConnection) {
                    throw ErrorContext.iaef((String)"Connection %s defined as the bundled connection for dev server does not exist", (Object)devBConn, (Object[])new Object[0]);
                }
                if (!bundledConnection.isFreelyUsableBy(user)) {
                    throw ErrorContext.iaef((String)"User %s does not have access to the connection %s defined as the bundled connection for dev server", (Object)user.toString(), (Object[])new Object[]{devBConn});
                }
                if (!LambdaHomeDevBootstrapper.isSQLConnectionType(bundledConnection.getType())) {
                    throw ErrorContext.iaef((String)"Connection %s defined as the bundled connection for dev server is not SQL type", (Object)devBConn, (Object[])new Object[0]);
                }
                lsc.bundledConnection = lsc.remappedConnections.get(devBConn);
                logger.infoV("Added bundled connection %s", new Object[]{lsc.bundledConnection.name});
            }
        }
        lsc.devLambdaServerSettings = new LambdaServerConfig.DevLambdaServerSettings();
        CGroupHelper cGroupHelper = new CGroupHelper(user, projectKey, GeneralSettingsDAO.CGrouppableProcessType.LAMBDA_DEV_SERVER);
        lsc.devLambdaServerSettings.cgroupsEnabled = cGroupHelper.isEnabled();
        if (lsc.devLambdaServerSettings.cgroupsEnabled) {
            lsc.devLambdaServerSettings.cgroupsHierarchiesMountPoint = cGroupHelper.getHierarchiesMountPoint();
            lsc.devLambdaServerSettings.targetCGroups = cGroupHelper.getTargetCGroups();
            lsc.devLambdaServerSettings.cgroupsVersion = cGroupHelper.getCGroupsVersion();
            lsc.devLambdaServerSettings.cgroupsV2Controllers = cGroupHelper.getCGroupsV2Controllers();
            logger.infoV("Configured lambda dev server to use cgroups under %s: %s", new Object[]{lsc.devLambdaServerSettings.cgroupsHierarchiesMountPoint, String.join((CharSequence)", ", lsc.devLambdaServerSettings.targetCGroups)});
        }
        if (null != targetUnixUser) {
            lsc.devLambdaServerSettings.unixUser = targetUnixUser;
            logger.infoV("Configured lambda dev server to impersonate unix user %s for custom code kernels", new Object[]{targetUnixUser});
        }
        lsc.devLambdaServerSettings.hostNodeType = ApplicationConfigurator.getNodeType();
        lsc.devLambdaServerSettings.projectKey = projectKey;
        lsc.hashApiKeys = ApiKeyUtils.useHashedApiKeys();
        lsc.isRequestMetadataEnabled = true;
        JSON.prettyToFile((Object)lsc, (File)new File(lambdaHome, "config/server.json"));
        LambdaServerAdminAuthConfig auc = new LambdaServerAdminAuthConfig();
        AdminAPIKey ak = new AdminAPIKey();
        ak.key = ApiKeyUtils.hashIfNecessary((String)adminApiKey);
        ak.label = "Lambda Dev Server key";
        auc.keys.add(ak);
        JSON.prettyToFile((Object)auc, (File)new File(lambdaHome, "config/adminkeys.json"));
        JSON.prettyToFile((Object)new LoadedDataMapping(), (File)new File(lambdaHome, "loaded-data-mapping.json"));
        logger.infoV("Done bootstrapping lambda dev server home directory in %s", new Object[]{lambdaHome.getAbsolutePath()});
    }

    protected static boolean isSQLConnectionType(String type) {
        try {
            ConnectionUtils.SQLConnectionType.valueOf(type.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

